/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.block_entities;

import com.cyanogen.experienceobelisk.ModTags;
import com.cyanogen.experienceobelisk.block_entities.ModTileEntitiesInit;
import com.cyanogen.experienceobelisk.config.Config;
import com.cyanogen.experienceobelisk.fluid.ModFluidsInit;
import com.cyanogen.experienceobelisk.network.experienceobelisk.UpdateToServer;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class XPObeliskEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected static final RawAnimation IDLE = RawAnimation.begin().thenPlay("xpobelisk.idle");
    protected boolean redstoneEnabled = false;
    protected double radius = 2.5;
    protected FluidTank tank = this.xpObeliskTank();
    private final LazyOptional<IFluidHandler> handler = LazyOptional.of(() -> this.tank);
    private static final Fluid rawExperience = ((FlowingFluid)ModFluidsInit.RAW_EXPERIENCE.get()).m_5613_();
    private static final Fluid cognitium = ((FlowingFluid)ModFluidsInit.COGNITIUM.get()).m_5613_();
    public static final int capacity = (Integer)Config.COMMON.capacity.get();

    public XPObeliskEntity(BlockPos pPos, BlockState pState) {
        super((BlockEntityType)ModTileEntitiesInit.XPOBELISK_BE.get(), pPos, pState);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, animationState -> animationState.setAndContinue(IDLE))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static <T> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        level.m_7260_(pos, state, state, 2);
        boolean isRedstonePowered = level.m_276867_(pos);
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof XPObeliskEntity) {
            XPObeliskEntity xpobelisk = (XPObeliskEntity)entity;
            if (level.m_46467_() % 3L == 0L) {
                boolean absorb = !xpobelisk.isRedstoneEnabled() || isRedstonePowered;
                double radius = xpobelisk.getRadius();
                if (absorb) {
                    AABB area = new AABB((double)pos.m_123341_() - radius, (double)pos.m_123342_() - radius, (double)pos.m_123343_() - radius, (double)pos.m_123341_() + radius, (double)pos.m_123342_() + radius, (double)pos.m_123343_() + radius);
                    List list = level.m_45976_(ExperienceOrb.class, area);
                    for (ExperienceOrb orb : list) {
                        int value = orb.m_20801_() * 20;
                        if (xpobelisk.getSpace() < value || !orb.m_6084_()) continue;
                        xpobelisk.fill(value);
                        orb.m_146870_();
                    }
                }
            }
        }
    }

    public boolean isRedstoneEnabled() {
        return this.redstoneEnabled;
    }

    public void setRedstoneEnabled(boolean state) {
        this.redstoneEnabled = state;
        this.m_6596_();
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
        this.m_6596_();
    }

    private FluidTank xpObeliskTank() {
        return new FluidTank(capacity){

            protected void onContentsChanged() {
                XPObeliskEntity.this.m_6596_();
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return this.isFluidValid(stack);
            }

            public boolean isFluidValid(FluidStack stack) {
                String fluidName = String.valueOf(ForgeRegistries.FLUIDS.getKey((Object)stack.getFluid()));
                if (stack.getFluid() == rawExperience || stack.getFluid() == cognitium) {
                    return true;
                }
                return stack.getFluid().m_205067_(ModTags.Fluids.EXPERIENCE) && ((List)Config.COMMON.allowedFluids.get()).contains(fluidName);
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (this.isFluidValid(resource)) {
                    XPObeliskEntity.this.m_6596_();
                    if (resource.getFluid() == rawExperience) {
                        return super.fill(new FluidStack(cognitium, resource.getAmount() * 20), action);
                    }
                    return super.fill(new FluidStack(cognitium, resource.getAmount()), action);
                }
                return 0;
            }

            @NotNull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                XPObeliskEntity.this.m_6596_();
                return super.drain(maxDrain, action);
            }

            @NotNull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                XPObeliskEntity.this.m_6596_();
                return super.drain(resource, action);
            }

            public void setFluid(FluidStack stack) {
                this.fluid = stack;
                XPObeliskEntity.this.m_6596_();
            }
        };
    }

    public int fill(int amount) {
        return this.tank.fill(new FluidStack(cognitium, amount), IFluidHandler.FluidAction.EXECUTE);
    }

    public void drain(int amount) {
        this.tank.drain(new FluidStack(cognitium, amount), IFluidHandler.FluidAction.EXECUTE);
    }

    public void setFluid(int amount) {
        this.tank.setFluid(new FluidStack(cognitium, amount));
    }

    public int getFluidAmount() {
        return this.tank.getFluidAmount();
    }

    public int getSpace() {
        return this.tank.getSpace();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.tank.readFromNBT(tag);
        this.radius = tag.m_128459_("Radius");
        this.redstoneEnabled = tag.m_128471_("isRedstoneControllable");
        if (this.tank.getFluid().getFluid() == rawExperience) {
            int amount = this.tank.getFluidAmount() * 20;
            this.tank.drain(capacity, IFluidHandler.FluidAction.EXECUTE);
            this.tank.setFluid(new FluidStack(cognitium, amount));
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.tank.writeToNBT(tag);
        tag.m_128347_("Radius", this.radius);
        tag.m_128379_("isRedstoneControllable", this.redstoneEnabled);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.tank.writeToNBT(tag);
        tag.m_128347_("Radius", this.radius);
        tag.m_128379_("isRedstoneControllable", this.redstoneEnabled);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.handler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public static int levelsToXP(int levels) {
        if (levels <= 16) {
            return (int)(Math.pow(levels, 2.0) + (double)(6 * levels));
        }
        if (levels <= 31) {
            return (int)(2.5 * Math.pow(levels, 2.0) - 40.5 * (double)levels + 360.0);
        }
        return (int)(4.5 * Math.pow(levels, 2.0) - 162.5 * (double)levels + 2220.0);
    }

    public void handleRequest(UpdateToServer.Request request, int XP, ServerPlayer sender) {
        long playerXP = XPObeliskEntity.levelsToXP(sender.f_36078_) + Math.round(sender.f_36080_ * (float)sender.m_36323_());
        if (request == UpdateToServer.Request.FILL && this.getSpace() != 0) {
            long finalXP = XPObeliskEntity.levelsToXP(sender.f_36078_ - XP) + Math.round(sender.f_36080_ * (float)(XPObeliskEntity.levelsToXP(sender.f_36078_ - XP + 1) - XPObeliskEntity.levelsToXP(sender.f_36078_ - XP)));
            long addAmount = (playerXP - finalXP) * 20L;
            if (addAmount >= (long)this.getSpace()) {
                sender.m_6756_(-this.fill(this.getSpace()) / 20);
            } else if (sender.f_36078_ >= XP) {
                this.fill((int)addAmount);
                sender.m_6749_(-XP);
            } else if (playerXP >= 1L) {
                this.fill((int)(playerXP * 20L));
                sender.m_8985_(0);
                sender.m_9174_(0);
            }
        } else if (request == UpdateToServer.Request.DRAIN) {
            long finalXP;
            long drainAmount;
            int amount = this.getFluidAmount();
            if ((long)amount >= (drainAmount = ((finalXP = (long)(XPObeliskEntity.levelsToXP(sender.f_36078_ + XP) + Math.round(sender.f_36080_ * (float)(XPObeliskEntity.levelsToXP(sender.f_36078_ + XP + 1) - XPObeliskEntity.levelsToXP(sender.f_36078_ + XP))))) - playerXP) * 20L)) {
                this.drain((int)drainAmount);
                sender.m_6749_(XP);
            } else if (amount >= 1) {
                sender.m_6756_(amount / 20);
                this.setFluid(0);
            }
        } else if (request == UpdateToServer.Request.FILL_ALL) {
            if (playerXP * 20L <= (long)this.getSpace()) {
                this.fill((int)(playerXP * 20L));
                sender.m_8985_(0);
                sender.m_9174_(0);
            } else {
                sender.m_6756_(-this.getSpace() / 20);
                this.setFluid(capacity);
            }
        } else if (request == UpdateToServer.Request.DRAIN_ALL) {
            sender.m_6756_(this.getFluidAmount() / 20);
            this.setFluid(0);
        }
    }
}

