/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.fluid;

import com.cyanogen.experienceobelisk.block.ModBlocksInit;
import com.cyanogen.experienceobelisk.item.ModItemsInit;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class ModFluidsInit {
    public static final ResourceLocation flowingTexture = new ResourceLocation("experienceobelisk:block/green");
    public static final ResourceLocation stillTexture = new ResourceLocation("experienceobelisk:block/green");
    public static final ResourceLocation overlay = new ResourceLocation("block/water_overlay");
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FLUIDS, (String)"experienceobelisk");
    public static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.FLUID_TYPES, (String)"experienceobelisk");
    public static final RegistryObject<FlowingFluid> RAW_EXPERIENCE = FLUIDS.register("raw_experience", () -> new ForgeFlowingFluid.Source(RAW_EXPERIENCE_PROPERTIES));
    public static final RegistryObject<FlowingFluid> RAW_EXPERIENCE_FLOWING = FLUIDS.register("raw_experience_flowing", () -> new ForgeFlowingFluid.Flowing(RAW_EXPERIENCE_PROPERTIES));
    public static final RegistryObject<FlowingFluid> COGNITIUM = FLUIDS.register("cognitium", () -> new ForgeFlowingFluid.Source(COGNITIUM_PROPERTIES));
    public static final RegistryObject<FlowingFluid> COGNITIUM_FLOWING = FLUIDS.register("cognitium_flowing", () -> new ForgeFlowingFluid.Flowing(COGNITIUM_PROPERTIES));
    public static final RegistryObject<FluidType> RAW_EXPERIENCE_FLUID_TYPE = FLUID_TYPES.register("raw_experience", () -> new FluidType(FluidType.Properties.create().lightLevel(10).viscosity(200).canDrown(false).canSwim(false).canPushEntity(false).canConvertToSource(false).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_)){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return stillTexture;
                }

                public ResourceLocation getFlowingTexture() {
                    return flowingTexture;
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    return new Vector3f(0.2f, 1.0f, 0.3f);
                }
            });
            super.initializeClient(consumer);
        }
    });
    public static final ForgeFlowingFluid.Properties RAW_EXPERIENCE_PROPERTIES = new ForgeFlowingFluid.Properties(RAW_EXPERIENCE_FLUID_TYPE, RAW_EXPERIENCE, RAW_EXPERIENCE_FLOWING).bucket(ModItemsInit.RAW_EXPERIENCE_BUCKET).block(ModBlocksInit.RAW_EXPERIENCE);
    public static final RegistryObject<FluidType> COGNITIUM_FLUID_TYPE = FLUID_TYPES.register("cognitium", () -> new FluidType(FluidType.Properties.create().lightLevel(10).viscosity(200).canDrown(false).canSwim(false).canPushEntity(false).canConvertToSource(false).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_)){

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return stillTexture;
                }

                public ResourceLocation getFlowingTexture() {
                    return flowingTexture;
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    return new Vector3f(0.2f, 1.0f, 0.3f);
                }
            });
            super.initializeClient(consumer);
        }
    });
    public static final ForgeFlowingFluid.Properties COGNITIUM_PROPERTIES = new ForgeFlowingFluid.Properties(COGNITIUM_FLUID_TYPE, COGNITIUM, COGNITIUM_FLOWING).bucket(ModItemsInit.COGNITIUM_BUCKET).block(ModBlocksInit.COGNITIUM);

    public static void register(IEventBus eventBus) {
        FLUIDS.register(eventBus);
        FLUID_TYPES.register(eventBus);
    }
}

