/*
 * Decompiled with CFR 0.152.
 */
package com.cyanogen.experienceobelisk.gui;

import com.cyanogen.experienceobelisk.block_entities.XPObeliskEntity;
import com.cyanogen.experienceobelisk.gui.ExperienceObeliskOptionsScreen;
import com.cyanogen.experienceobelisk.network.PacketHandler;
import com.cyanogen.experienceobelisk.network.experienceobelisk.UpdateToServer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ExperienceObeliskScreen
extends Screen {
    public Level level;
    public Player player;
    public BlockPos pos;
    public XPObeliskEntity xpobelisk;
    private final ResourceLocation texture = new ResourceLocation("experienceobelisk:textures/gui/container/dark_bg2.png");
    private final List<Button> buttons = new ArrayList<Button>();

    public ExperienceObeliskScreen(Level level, Player player, BlockPos pos) {
        super((Component)Component.m_237113_((String)"Experience Obelisk"));
        this.level = level;
        this.player = player;
        this.pos = pos;
        this.xpobelisk = (XPObeliskEntity)level.m_7702_(pos);
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256 || pKeyCode == 69) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public boolean m_7043_() {
        return false;
    }

    public Minecraft getMinecraft() {
        return this.f_96541_;
    }

    public static int levelsToXP(int levels) {
        if (levels <= 16) {
            return (int)(Math.pow(levels, 2.0) + (double)(6 * levels));
        }
        if (levels <= 31) {
            return (int)(2.5 * Math.pow(levels, 2.0) - 40.5 * (double)levels + 360.0);
        }
        return (int)(4.5 * Math.pow(levels, 2.0) - 162.5 * (double)levels + 2220.0);
    }

    public static int xpToLevels(long xp) {
        if (xp < 394L) {
            return (int)(Math.sqrt(xp + 9L) - 3.0);
        }
        if (xp < 1628L) {
            return (int)((Math.sqrt(40L * xp - 7839L) + 81.0) * 0.1);
        }
        return (int)((Math.sqrt(72L * xp - 54215L) + 325.0) / 18.0);
    }

    protected void m_7856_() {
        this.setupWidgetElements();
        super.m_7856_();
    }

    public void m_88315_(GuiGraphics gui, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.player.m_20182_().m_82554_(Vec3.m_82512_((Vec3i)this.pos)) > 7.0) {
            this.m_7379_();
        }
        this.m_280273_(gui);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.texture);
        int textureWidth = 256;
        int textureHeight = 256;
        int x = this.f_96543_ / 2 - 88;
        int y = this.f_96544_ / 2 - 83;
        int experiencePoints = this.xpobelisk.getFluidAmount() / 20;
        int n = experiencePoints - ExperienceObeliskScreen.levelsToXP(ExperienceObeliskScreen.xpToLevels(experiencePoints));
        int m = ExperienceObeliskScreen.levelsToXP(ExperienceObeliskScreen.xpToLevels(experiencePoints) + 1) - ExperienceObeliskScreen.levelsToXP(ExperienceObeliskScreen.xpToLevels(experiencePoints));
        int p = n * 138 / m;
        gui.m_280163_(this.texture, x, y, 0.0f, 0.0f, 176, 166, textureWidth, textureHeight);
        gui.m_280163_(this.texture, this.f_96543_ / 2 - 69, this.f_96544_ / 2 + 50, 0.0f, 169.0f, 138, 5, textureWidth, textureHeight);
        gui.m_280163_(this.texture, this.f_96543_ / 2 - 69, this.f_96544_ / 2 + 50, 0.0f, 173.0f, p, 5, textureWidth, textureHeight);
        gui.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"title.experienceobelisk.experience_obelisk"), this.f_96543_ / 2, this.f_96544_ / 2 - 76, 0xFFFFFF);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"title.experienceobelisk.experience_obelisk.store"), this.f_96543_ / 2 - 77, this.f_96544_ / 2 - 56, 0xFFFFFF);
        gui.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"title.experienceobelisk.experience_obelisk.retrieve"), this.f_96543_ / 2 - 77, this.f_96544_ / 2 - 10, 0xFFFFFF);
        gui.m_280137_(this.f_96547_, experiencePoints * 20 + " mB", this.f_96543_ / 2, this.f_96544_ / 2 + 35, 0xFFFFFF);
        gui.m_280137_(this.f_96547_, String.valueOf(ExperienceObeliskScreen.xpToLevels(experiencePoints)), this.f_96543_ / 2, this.f_96544_ / 2 + 60, 5111570);
        this.m_169413_();
        this.loadWidgetElements();
        for (Renderable widget : this.f_169369_) {
            widget.m_88315_(gui, pMouseX, pMouseY, pPartialTick);
        }
    }

    private void loadWidgetElements() {
        if (!this.buttons.isEmpty()) {
            for (Button b : this.buttons) {
                b.m_93692_(false);
                this.m_142416_((GuiEventListener)b);
            }
        }
    }

    private void setupWidgetElements() {
        Style style = Style.f_131099_;
        Style green = style.m_178520_(4587355);
        Style red = style.m_178520_(16729419);
        int w = 50;
        int h = 20;
        int s = 2;
        int y1 = 43;
        int y2 = -3;
        Button settings = Button.m_253074_((Component)Component.m_237115_((String)"button.experienceobelisk.experience_obelisk.settings"), onPress -> Minecraft.m_91087_().m_91152_((Screen)new ExperienceObeliskOptionsScreen(this.level, this.player, this.pos, this))).m_253046_(20, 20).m_252794_(this.f_96543_ / 2 + 91, this.f_96544_ / 2 - 78).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.experienceobelisk.experience_obelisk.settings"))).m_253136_();
        Button deposit1 = Button.m_253074_((Component)Component.m_237113_((String)"+1").m_130940_(ChatFormatting.GREEN), onPress -> PacketHandler.INSTANCE.sendToServer((Object)new UpdateToServer(this.pos, 1, UpdateToServer.Request.FILL))).m_253046_(w, h).m_252794_((int)((double)(this.f_96543_ / 2) - 1.5 * (double)w - (double)s), this.f_96544_ / 2 - y1).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.experienceobelisk.experience_obelisk.add1"))).m_253136_();
        Button deposit10 = Button.m_253074_((Component)Component.m_237113_((String)"+10").m_130940_(ChatFormatting.GREEN), onPress -> PacketHandler.INSTANCE.sendToServer((Object)new UpdateToServer(this.pos, 10, UpdateToServer.Request.FILL))).m_253046_(w, h).m_252794_(this.f_96543_ / 2 - w / 2, this.f_96544_ / 2 - y1).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.experienceobelisk.experience_obelisk.add10"))).m_253136_();
        Button depositAll = Button.m_253074_((Component)Component.m_237113_((String)"+All").m_130940_(ChatFormatting.GREEN), onPress -> PacketHandler.INSTANCE.sendToServer((Object)new UpdateToServer(this.pos, 0, UpdateToServer.Request.FILL_ALL))).m_253046_(w, h).m_252794_((int)((double)(this.f_96543_ / 2) + 0.5 * (double)w + (double)s), this.f_96544_ / 2 - y1).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.experienceobelisk.experience_obelisk.addAll"))).m_253136_();
        Button withdraw1 = Button.m_253074_((Component)Component.m_237113_((String)"-1").m_130940_(ChatFormatting.RED), onPress -> PacketHandler.INSTANCE.sendToServer((Object)new UpdateToServer(this.pos, 1, UpdateToServer.Request.DRAIN))).m_253046_(w, h).m_252794_((int)((double)(this.f_96543_ / 2) - 1.5 * (double)w - (double)s), this.f_96544_ / 2 - y2).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.experienceobelisk.experience_obelisk.drain1"))).m_253136_();
        Button withdraw10 = Button.m_253074_((Component)Component.m_237113_((String)"-10").m_130940_(ChatFormatting.RED), onPress -> PacketHandler.INSTANCE.sendToServer((Object)new UpdateToServer(this.pos, 10, UpdateToServer.Request.DRAIN))).m_253046_(w, h).m_252794_(this.f_96543_ / 2 - w / 2, this.f_96544_ / 2 - y2).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.experienceobelisk.experience_obelisk.drain10"))).m_253136_();
        Button withdrawAll = Button.m_253074_((Component)Component.m_237113_((String)"-All").m_130940_(ChatFormatting.RED), onPress -> PacketHandler.INSTANCE.sendToServer((Object)new UpdateToServer(this.pos, 0, UpdateToServer.Request.DRAIN_ALL))).m_253046_(w, h).m_252794_((int)((double)(this.f_96543_ / 2) + 0.5 * (double)w + (double)s), this.f_96544_ / 2 - y2).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.experienceobelisk.experience_obelisk.drainAll"))).m_253136_();
        this.buttons.add(settings);
        this.buttons.add(deposit1);
        this.buttons.add(deposit10);
        this.buttons.add(depositAll);
        this.buttons.add(withdraw1);
        this.buttons.add(withdraw10);
        this.buttons.add(withdrawAll);
    }
}

