/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.blockentity;

import de.teamlapen.lib.lib.inventory.InventoryContainerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class InventoryBlockEntity
extends BaseContainerBlockEntity
implements MenuProvider {
    protected final int MAX_DIST_SQRT = 64;
    @NotNull
    protected final NonNullList<ItemStack> inventorySlots;
    protected InventoryContainerMenu.SelectorInfo[] selectors;

    public InventoryBlockEntity(@NotNull BlockEntityType<?> tileEntityTypeIn, @NotNull BlockPos pos, @NotNull BlockState state, ItemCombinerMenuSlotDefinition slotDefinition) {
        this(tileEntityTypeIn, pos, state, slotDefinition.m_266578_(), (InventoryContainerMenu.SelectorInfo[])slotDefinition.m_266233_().stream().map(d -> new InventoryContainerMenu.SelectorInfo(d.f_265897_(), d.f_266065_(), d.f_265926_())).toArray(InventoryContainerMenu.SelectorInfo[]::new));
    }

    public InventoryBlockEntity(@NotNull BlockEntityType<?> tileEntityTypeIn, @NotNull BlockPos pos, @NotNull BlockState state, int size, InventoryContainerMenu.SelectorInfo ... selectorInfos) {
        super(tileEntityTypeIn, pos, state);
        this.inventorySlots = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        if (selectorInfos.length != size) {
            throw new IllegalArgumentException("Selector count must match inventory size");
        }
        this.selectors = selectorInfos;
    }

    public boolean m_7013_(int slot, @NotNull ItemStack stack) {
        if (slot < 0 || slot >= this.selectors.length) {
            return false;
        }
        return this.selectors[slot].validate(stack);
    }

    public void m_6211_() {
        this.inventorySlots.clear();
    }

    public int m_6643_() {
        return this.inventorySlots.size();
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        return (ItemStack)this.inventorySlots.get(index);
    }

    public boolean m_7983_() {
        return this.inventorySlots.isEmpty();
    }

    public void m_142466_(@NotNull CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.inventorySlots.clear();
        ContainerHelper.m_18980_((CompoundTag)tagCompound, this.inventorySlots);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amt) {
        return ContainerHelper.m_18969_(this.inventorySlots, (int)slot, (int)amt);
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.inventorySlots, (int)index);
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        ContainerHelper.m_18973_((CompoundTag)pTag, this.inventorySlots);
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        this.inventorySlots.set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public void m_5856_(@NotNull Player player) {
    }

    public boolean m_6542_(@NotNull Player player) {
        if (!this.m_58898_()) {
            return false;
        }
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @NotNull
    protected InvWrapper createWrapper() {
        return new SelectorInvWrapper((Container)this);
    }

    protected boolean isFull() {
        for (ItemStack s : this.inventorySlots) {
            if (!s.m_41619_() && s.m_41613_() >= s.m_41741_()) continue;
            return false;
        }
        return true;
    }

    private class SelectorInvWrapper
    extends InvWrapper {
        SelectorInvWrapper(Container inv) {
            super(inv);
        }

        public int getSlotLimit(int slot) {
            return slot < 0 || slot >= InventoryBlockEntity.this.selectors.length ? 0 : InventoryBlockEntity.this.selectors[slot].stackLimit;
        }
    }
}

