/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.world.VampirismWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class FogDiffuserBlockEntity
extends BlockEntity {
    @NotNull
    private State state = State.IDLE;
    private boolean activated = false;
    private float bootProgress = 0.0f;

    public FogDiffuserBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModTiles.FOG_DIFFUSER.get(), pPos, pBlockState);
    }

    protected void m_183515_(@NotNull CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128359_("state", this.state.name());
        pTag.m_128350_("bootProgress", this.bootProgress);
        pTag.m_128379_("activated", this.activated);
    }

    public void m_142466_(@NotNull CompoundTag pTag) {
        super.m_142466_(pTag);
        this.state = State.valueOf(pTag.m_128461_("state"));
        this.bootProgress = pTag.m_128457_("bootProgress");
        this.activated = pTag.m_128471_("activated");
    }

    protected int getRange() {
        return 40;
    }

    @NotNull
    public State getState() {
        return this.state;
    }

    public float getBootProgress() {
        return this.bootProgress;
    }

    protected AABB getArea() {
        return this.getArea(this.getRange());
    }

    protected AABB getArea(int range) {
        return new AABB(this.f_58858_.m_7918_(-range, -range, -range), this.f_58858_.m_7918_(range, range, range));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FogDiffuserBlockEntity blockEntity) {
        switch (blockEntity.state) {
            case IDLE: {
                if (!blockEntity.activated) break;
                blockEntity.state = State.BOOTING;
                blockEntity.bootProgress = 0.0f;
                break;
            }
            case BOOTING: {
                if (level.m_46467_() % 128L != 0L) break;
                blockEntity.bootProgress = (float)((double)blockEntity.bootProgress + 0.1);
                if (blockEntity.bootProgress >= 1.0f) {
                    blockEntity.state = State.ACTIVE;
                }
                blockEntity.updateFogArea(level);
                break;
            }
        }
    }

    public void m_7651_() {
        this.updateFogArea((AABB)null);
        super.m_7651_();
    }

    public void updateFogArea(Level level) {
        this.updateFogArea(switch (this.state) {
            case State.BOOTING -> this.getArea((int)((float)this.getRange() * this.bootProgress));
            case State.ACTIVE -> this.getArea();
            default -> null;
        });
    }

    protected void updateFogArea(AABB area) {
        VampirismWorld.getOpt(this.f_58857_).ifPresent(vw -> vw.updateArtificialFogBoundingBox(this.f_58858_, area));
    }

    public void interact(ItemStack itemInHand) {
        if (!this.activated && itemInHand.m_204117_(ModTags.Items.PURE_BLOOD)) {
            this.activated = true;
            itemInHand.m_41774_(1);
        }
    }

    public static enum State {
        IDLE,
        BOOTING,
        ACTIVE;

    }
}

