/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blockentity;

import de.teamlapen.lib.lib.util.SimpleSpawnerLogic;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.entity.hunter.AdvancedHunterEntity;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class TentBlockEntity
extends BlockEntity {
    @NotNull
    private final SimpleSpawnerLogic<BasicHunterEntity> spawnerLogicHunter;
    @NotNull
    private final SimpleSpawnerLogic<AdvancedHunterEntity> spawnerLogicAdvancedHunter;
    private boolean spawn = false;
    private boolean advanced = false;

    public TentBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        super((BlockEntityType)ModTiles.TENT.get(), pos, state);
        this.spawnerLogicHunter = new SimpleSpawnerLogic((EntityType)ModEntities.HUNTER.get()).setActivateRange(64).setSpawnRange(6).setMinSpawnDelay(600).setMaxSpawnDelay(1000).setMaxNearbyEntities(2).setDailyLimit((Integer)VampirismConfig.BALANCE.hunterTentMaxSpawn.get()).setLimitTotalEntities(VReference.HUNTER_CREATURE_TYPE).setOnSpawned(hunter -> hunter.makeCampHunter(this.f_58858_));
        this.spawnerLogicAdvancedHunter = new SimpleSpawnerLogic((EntityType)ModEntities.ADVANCED_HUNTER.get()).setActivateRange(64).setSpawnRange(6).setMinSpawnDelay(1200).setMaxSpawnDelay(2000).setMaxNearbyEntities(1).setDailyLimit(1).setLimitTotalEntities(VReference.HUNTER_CREATURE_TYPE).setOnSpawned(hunter -> hunter.makeCampHunter(this.f_58858_));
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public AABB getRenderBoundingBox() {
        return super.getRenderBoundingBox().m_82377_(1.0, 0.0, 1.0);
    }

    public boolean isSpawner() {
        return this.spawn;
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("spawner_logic_1")) {
            this.spawnerLogicHunter.readFromNbt(nbt.m_128469_("spawner_logic_1"));
        }
        if (nbt.m_128441_("spawner_logic_2")) {
            this.spawnerLogicAdvancedHunter.readFromNbt(nbt.m_128469_("spawner_logic_2"));
        }
        if (nbt.m_128441_("advanced")) {
            this.advanced = nbt.m_128471_("advanced");
        }
        this.spawn = nbt.m_128471_("spawn");
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        CompoundTag logic1 = new CompoundTag();
        CompoundTag logic2 = new CompoundTag();
        this.spawnerLogicHunter.writeToNbt(logic1);
        this.spawnerLogicAdvancedHunter.writeToNbt(logic2);
        compound.m_128365_("spawner_logic_1", (Tag)logic1);
        compound.m_128365_("spawner_logic_2", (Tag)logic2);
        compound.m_128379_("spawn", this.spawn);
        compound.m_128379_("advanced", this.advanced);
    }

    public void setAdvanced(boolean advanced) {
        this.advanced = advanced;
    }

    public void setSpawn(boolean spawn) {
        this.spawn = spawn;
    }

    public static void serverTick(@NotNull Level level, @NotNull BlockPos pos, BlockState state, @NotNull TentBlockEntity blockEntity) {
        if (blockEntity.spawn) {
            if (level.m_46467_() % 64L == 0L && UtilLib.isInsideStructure(level, pos, (TagKey<Structure>)StructureTags.f_215889_)) {
                blockEntity.spawn = false;
            }
            blockEntity.spawnerLogicHunter.serverTick(level, pos);
            if (blockEntity.advanced) {
                blockEntity.spawnerLogicAdvancedHunter.serverTick(level, pos);
            }
        }
    }

    public boolean m_7531_(int id, int type) {
        return this.spawnerLogicHunter.setDelayToMin(id, this.f_58857_) || this.spawnerLogicAdvancedHunter.setDelayToMin(id, this.f_58857_) || super.m_7531_(id, type);
    }
}

