/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blocks.VampirismBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class AltarPillarBlock
extends VampirismBlock {
    public static final EnumProperty<EnumPillarType> TYPE_PROPERTY = EnumProperty.m_61587_((String)"type", EnumPillarType.class);
    protected static final VoxelShape pillarShape = AltarPillarBlock.makeShape();
    protected static final VoxelShape pillarShapeFilled = AltarPillarBlock.makeShapeFull();

    @NotNull
    private static VoxelShape makeShape() {
        VoxelShape a = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
        VoxelShape b1 = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)4.0, (double)16.0, (double)4.0);
        VoxelShape b2 = Block.m_49796_((double)12.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)4.0);
        VoxelShape b3 = Block.m_49796_((double)3.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)13.0);
        VoxelShape b4 = Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)13.0, (double)16.0, (double)13.0);
        VoxelShape c = Block.m_49796_((double)3.0, (double)15.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        return Shapes.m_83124_((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b1, b2, b3, b4, c});
    }

    @NotNull
    private static VoxelShape makeShapeFull() {
        VoxelShape b = Block.m_49796_((double)4.0, (double)1.0, (double)2.0, (double)12.0, (double)15.0, (double)14.0);
        VoxelShape c = Block.m_49796_((double)2.0, (double)1.0, (double)4.0, (double)14.0, (double)15.0, (double)12.0);
        return Shapes.m_83124_((VoxelShape)pillarShape, (VoxelShape[])new VoxelShape[]{b, c});
    }

    public AltarPillarBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_60978_(0.9f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(TYPE_PROPERTY, (Comparable)((Object)EnumPillarType.NONE)));
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return state.m_61143_(TYPE_PROPERTY) != EnumPillarType.NONE ? pillarShapeFilled : pillarShape;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player playerIn, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        EnumPillarType type = (EnumPillarType)((Object)state.m_61143_(TYPE_PROPERTY));
        ItemStack heldItem = playerIn.m_21120_(hand);
        if (type != EnumPillarType.NONE && heldItem.m_41619_()) {
            if (!playerIn.m_150110_().f_35937_) {
                playerIn.m_8061_(hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Item.m_41439_((Block)type.fillerBlock)));
            }
            worldIn.m_46597_(pos, (BlockState)state.m_61124_(TYPE_PROPERTY, (Comparable)((Object)EnumPillarType.NONE)));
            return InteractionResult.SUCCESS;
        }
        if (type == EnumPillarType.NONE && !heldItem.m_41619_()) {
            for (EnumPillarType t : EnumPillarType.values()) {
                if (!heldItem.m_41720_().equals(t.fillerBlock.m_5456_())) continue;
                if (!playerIn.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
                worldIn.m_46597_(pos, (BlockState)state.m_61124_(TYPE_PROPERTY, (Comparable)((Object)t)));
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE_PROPERTY});
    }

    public static enum EnumPillarType implements StringRepresentable
    {
        NONE(0, "none", 0.0f, Blocks.f_50016_),
        STONE(1, "stone", 1.0f, Blocks.f_50222_),
        IRON(2, "iron", 2.0f, Blocks.f_50075_),
        GOLD(3, "gold", 3.0f, Blocks.f_50074_),
        BONE(4, "bone", 1.5f, Blocks.f_50453_);

        public final String name;
        public final Block fillerBlock;
        public final int meta;
        private final float value;

        private EnumPillarType(int meta, String name, float value, Block fillerBlock) {
            this.meta = meta;
            this.name = name;
            this.fillerBlock = fillerBlock;
            this.value = value;
        }

        @NotNull
        public String getName() {
            return this.m_7912_();
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public float getValue() {
            return this.value;
        }

        @NotNull
        public String toString() {
            return this.getName();
        }
    }
}

