/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui.screens;

import de.teamlapen.lib.lib.client.gui.components.HoverList;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.gui.screens.AppearanceScreen;
import de.teamlapen.vampirism.client.renderer.entity.HunterMinionRenderer;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.network.ServerboundAppearancePacket;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class HunterMinionAppearanceScreen
extends AppearanceScreen<HunterMinionEntity> {
    private static final Component NAME = Component.m_237115_((String)"gui.vampirism.minion_appearance");
    private int skinType;
    private int hatType;
    private boolean useLordSkin;
    private boolean isMinionSpecificSkin;
    private HoverList<?> skinList;
    private HoverList<?> hatList;
    private ExtendedButton skinButton;
    private ExtendedButton hatButton;
    private Checkbox useLordSkinButton;
    private EditBox nameWidget;
    private int normalSkinCount;
    private int minionSkinCount;

    public HunterMinionAppearanceScreen(HunterMinionEntity minion, Screen backScreen) {
        super(NAME, minion, backScreen);
    }

    public void m_7861_() {
        Object name = this.nameWidget.m_94155_();
        if (((String)name).isEmpty()) {
            name = Component.m_237115_((String)"text.vampirism.minion").toString() + String.valueOf(((HunterMinionEntity)this.entity).getMinionId().orElse(0));
        }
        VampirismMod.dispatcher.sendToServer(new ServerboundAppearancePacket(((HunterMinionEntity)this.entity).m_19879_(), (String)name, this.skinType, this.hatType, (this.isMinionSpecificSkin ? 2 : 0) | (this.useLordSkin ? 1 : 0)));
        super.m_7861_();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.nameWidget = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.guiLeft + 21, this.guiTop + 29, 98, 12, (Component)Component.m_237115_((String)"gui.vampirism.minion_appearance.name")));
        this.nameWidget.m_94144_(((HunterMinionEntity)this.entity).getMinionData().map(MinionData::getName).orElse("Minion"));
        this.nameWidget.m_94205_(-1);
        this.nameWidget.m_94202_(-1);
        this.nameWidget.m_94199_(15);
        this.nameWidget.m_94151_(this::onNameChanged);
        this.normalSkinCount = ((HunterMinionRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)((HunterMinionEntity)this.entity))).getHunterTextureCount();
        this.minionSkinCount = ((HunterMinionRenderer)Minecraft.m_91087_().m_91290_().m_114382_((Entity)((HunterMinionEntity)this.entity))).getMinionSpecificTextureCount();
        this.isMinionSpecificSkin = ((HunterMinionEntity)this.entity).hasMinionSpecificSkin();
        if (this.isMinionSpecificSkin && this.minionSkinCount > 0) {
            this.skinType %= this.minionSkinCount;
        } else {
            this.skinType %= this.normalSkinCount;
            this.isMinionSpecificSkin = false;
        }
        this.hatType = ((HunterMinionEntity)this.entity).getHatType();
        this.useLordSkin = ((HunterMinionEntity)this.entity).shouldRenderLordSkin();
        this.useLordSkinButton = (Checkbox)this.m_142416_((GuiEventListener)new Checkbox(this.guiLeft + 20, this.guiTop + 86, 99, 20, (Component)Component.m_237115_((String)"gui.vampirism.minion_appearance.use_lord_skin"), this.useLordSkin){

            public void m_5691_() {
                super.m_5691_();
                HunterMinionAppearanceScreen.this.useLordSkin = this.m_93840_();
                ((HunterMinionEntity)HunterMinionAppearanceScreen.this.entity).setUseLordSkin(HunterMinionAppearanceScreen.this.useLordSkin);
            }
        });
        this.hatList = (HoverList)this.m_142416_((GuiEventListener)HoverList.builder(this.guiLeft + 20, this.guiTop + 64 + 19, 99, 60).componentsWithClickAndHover(IntStream.range(0, 3).mapToObj(id -> Component.m_237115_((String)"gui.vampirism.minion_appearance.hat").m_130946_(" " + (id + 1))).toList(), this::hat, this::previewHat).build());
        this.hatButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.hatList.getLeft(), this.hatList.getTop() - 20, this.hatList.getWidth(), 20, (Component)Component.m_237113_((String)""), b -> this.setHatListVisibility(!this.hatList.isVisible)));
        this.skinList = (HoverList)this.m_142416_((GuiEventListener)HoverList.builder(this.guiLeft + 20, this.guiTop + 43 + 19, 99, 80).componentsWithClickAndHover(IntStream.range(0, this.normalSkinCount + this.minionSkinCount).mapToObj(id -> Component.m_237115_((String)"gui.vampirism.minion_appearance.skin").m_130946_(" " + (id + 1))).toList(), this::skin, this::previewSkin).build());
        this.skinButton = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(this.skinList.getLeft(), this.skinList.getTop() - 20, this.skinList.getWidth(), 20, (Component)Component.m_237113_((String)""), b -> this.setSkinListVisibility(!this.skinList.isVisible)));
        this.setSkinListVisibility(false);
        this.setHatListVisibility(false);
    }

    private void hat(int type) {
        this.hatType = type;
        ((HunterMinionEntity)this.entity).setHatType(this.hatType);
        this.setHatListVisibility(false);
    }

    private void onNameChanged(String newName) {
        ((HunterMinionEntity)this.entity).changeMinionName(newName);
    }

    private void previewHat(int type, boolean hovered) {
        if (hovered) {
            ((HunterMinionEntity)this.entity).setHatType(type);
        } else if (((HunterMinionEntity)this.entity).getHatType() == type) {
            ((HunterMinionEntity)this.entity).setHatType(this.hatType);
        }
    }

    private void previewSkin(int type, boolean hovered) {
        boolean minionSpecific;
        boolean bl = minionSpecific = type >= this.normalSkinCount;
        if (hovered) {
            ((HunterMinionEntity)this.entity).setHunterType(type, minionSpecific);
        } else if (((HunterMinionEntity)this.entity).getHunterType() == type && ((HunterMinionEntity)this.entity).hasMinionSpecificSkin() == minionSpecific) {
            ((HunterMinionEntity)this.entity).setHunterType(this.skinType, this.isMinionSpecificSkin);
        }
    }

    private void setHatListVisibility(boolean show) {
        this.hatButton.m_93666_((Component)Component.m_237115_((String)"gui.vampirism.minion_appearance.hat").m_130946_(" " + (this.hatType + 1)));
        this.hatList.isVisible = show;
        if (show) {
            this.skinList.isVisible = false;
        }
        this.useLordSkinButton.f_93624_ = !show;
    }

    private void setSkinListVisibility(boolean show) {
        this.skinButton.m_93666_((Component)Component.m_237115_((String)"gui.vampirism.minion_appearance.skin").m_130946_(" " + (this.skinType + 1)));
        this.skinList.isVisible = show;
        this.hatButton.f_93624_ = !show;
        boolean bl = this.useLordSkinButton.f_93624_ = !show;
        if (show) {
            this.hatList.isVisible = false;
        }
    }

    private void skin(int type) {
        boolean minionSpecific = type >= this.normalSkinCount;
        this.skinType = type;
        this.isMinionSpecificSkin = minionSpecific;
        ((HunterMinionEntity)this.entity).setHunterType(this.skinType, this.isMinionSpecificSkin);
        this.setSkinListVisibility(false);
    }
}

