/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import de.teamlapen.vampirism.client.core.ModEntitiesRender;
import de.teamlapen.vampirism.client.model.HunterMinionModel;
import de.teamlapen.vampirism.client.renderer.entity.DualBipedRenderer;
import de.teamlapen.vampirism.client.renderer.entity.layers.PlayerBodyOverlayLayer;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class HunterMinionRenderer
extends DualBipedRenderer<HunterMinionEntity, HunterMinionModel<HunterMinionEntity>> {
    private final Pair<ResourceLocation, Boolean> @NotNull [] textures = this.gatherTextures("textures/entity/hunter", true);
    private final Pair<ResourceLocation, Boolean> @NotNull [] minionSpecificTextures = this.gatherTextures("textures/entity/minion/hunter", false);

    public HunterMinionRenderer(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull EntityRendererProvider.Context context) {
        super(context, new HunterMinionModel(context.m_174023_(ModEntitiesRender.GENERIC_BIPED), false), new HunterMinionModel(context.m_174023_(ModEntitiesRender.GENERIC_BIPED_SLIM), true), 0.5f);
        this.m_115326_(new PlayerBodyOverlayLayer<HunterMinionEntity, HunterMinionModel<HunterMinionEntity>>(this));
        this.m_115326_((RenderLayer)new DualBipedRenderer.ArmorLayer((DualBipedRenderer)this, (RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171167_)), (HumanoidModel)new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171164_)), (HumanoidModel)new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171168_)), (HumanoidModel)new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171165_)), context.m_266367_()));
    }

    public int getHunterTextureCount() {
        return this.textures.length;
    }

    public int getMinionSpecificTextureCount() {
        return this.minionSpecificTextures.length;
    }

    @Override
    protected Pair<ResourceLocation, Boolean> determineTextureAndModel(@NotNull HunterMinionEntity entity) {
        Pair<ResourceLocation, Boolean> p;
        Pair<ResourceLocation, Boolean> pair = p = entity.hasMinionSpecificSkin() && this.minionSpecificTextures.length > 0 ? this.minionSpecificTextures[entity.getHunterType() % this.minionSpecificTextures.length] : this.textures[entity.getHunterType() % this.textures.length];
        if (entity.shouldRenderLordSkin()) {
            return entity.getOverlayPlayerProperties().map(Pair::getRight).map(b -> Pair.of((Object)((ResourceLocation)p.getLeft()), (Object)b)).orElse(p);
        }
        return p;
    }

    protected void scale(@NotNull HunterMinionEntity entityIn, @NotNull PoseStack matrixStackIn, float partialTickTime) {
        float s = entityIn.m_6134_();
        matrixStackIn.m_85841_(s, s, s);
    }

    protected void renderNameTag(@NotNull HunterMinionEntity pEntity, @NotNull Component pDisplayName, @NotNull PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.m_85836_();
        pMatrixStack.m_252880_(0.0f, 0.4f, 0.0f);
        super.m_7649_((Entity)pEntity, pDisplayName, pMatrixStack, pBuffer, pPackedLight);
        pMatrixStack.m_85849_();
    }
}

