/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.mojang.serialization.Codec;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.IVampirismEntityRegistry;
import de.teamlapen.vampirism.api.entity.convertible.Converter;
import de.teamlapen.vampirism.core.ModAttributes;
import de.teamlapen.vampirism.entity.AreaParticleCloudEntity;
import de.teamlapen.vampirism.entity.BlindingBatEntity;
import de.teamlapen.vampirism.entity.CrossbowArrowEntity;
import de.teamlapen.vampirism.entity.DarkBloodProjectileEntity;
import de.teamlapen.vampirism.entity.GhostEntity;
import de.teamlapen.vampirism.entity.RemainsDefenderEntity;
import de.teamlapen.vampirism.entity.SoulOrbEntity;
import de.teamlapen.vampirism.entity.ThrowableItemEntity;
import de.teamlapen.vampirism.entity.VampirismBoatEntity;
import de.teamlapen.vampirism.entity.VampirismChestBoatEntity;
import de.teamlapen.vampirism.entity.VulnerableRemainsDummyEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedCowEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedCreatureEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedDonkeyEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedFoxEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedGoatEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedHorseEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedMuleEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedSheepEntity;
import de.teamlapen.vampirism.entity.converted.ConvertedVillagerEntity;
import de.teamlapen.vampirism.entity.converted.converter.DefaultConverter;
import de.teamlapen.vampirism.entity.converted.converter.SpecialConverter;
import de.teamlapen.vampirism.entity.hunter.AdvancedHunterEntity;
import de.teamlapen.vampirism.entity.hunter.AggressiveVillagerEntity;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import de.teamlapen.vampirism.entity.hunter.DummyHunterTrainerEntity;
import de.teamlapen.vampirism.entity.hunter.HunterBaseEntity;
import de.teamlapen.vampirism.entity.hunter.HunterTaskMasterEntity;
import de.teamlapen.vampirism.entity.hunter.HunterTrainerEntity;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.vampire.AdvancedVampireEntity;
import de.teamlapen.vampirism.entity.vampire.BasicVampireEntity;
import de.teamlapen.vampirism.entity.vampire.DummyBittenAnimalEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaronEntity;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.entity.vampire.VampireTaskMasterEntity;
import de.teamlapen.vampirism.sit.SitEntity;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"vampirism");
    public static final DeferredRegister<Codec<? extends Converter>> CONVERTING_HELPER = DeferredRegister.create(VampirismRegistries.ENTITY_CONVERTER_ID, (String)"vampirism");
    public static final RegistryObject<EntityType<BasicHunterEntity>> HUNTER = ModEntities.prepareEntityType("hunter", () -> EntityType.Builder.m_20704_(BasicHunterEntity::new, (MobCategory)VReference.HUNTER_CREATURE_TYPE).m_20699_(0.6f, 1.95f), true);
    public static final RegistryObject<EntityType<HunterTrainerEntity>> HUNTER_TRAINER = ModEntities.prepareEntityType("hunter_trainer", () -> EntityType.Builder.m_20704_(HunterTrainerEntity::new, (MobCategory)VReference.HUNTER_CREATURE_TYPE).m_20699_(0.6f, 1.95f), true);
    public static final RegistryObject<EntityType<AdvancedHunterEntity>> ADVANCED_HUNTER = ModEntities.prepareEntityType("advanced_hunter", () -> EntityType.Builder.m_20704_(AdvancedHunterEntity::new, (MobCategory)VReference.HUNTER_CREATURE_TYPE).m_20699_(0.6f, 1.95f), true);
    public static final RegistryObject<EntityType<VampireBaronEntity>> VAMPIRE_BARON = ModEntities.prepareEntityType("vampire_baron", () -> EntityType.Builder.m_20704_(VampireBaronEntity::new, (MobCategory)VReference.VAMPIRE_CREATURE_TYPE).m_20699_(0.6f, 1.95f), true);
    public static final RegistryObject<EntityType<BasicVampireEntity>> VAMPIRE = ModEntities.prepareEntityType("vampire", () -> EntityType.Builder.m_20704_(BasicVampireEntity::new, (MobCategory)VReference.VAMPIRE_CREATURE_TYPE).m_20699_(0.6f, 1.95f), true);
    public static final RegistryObject<EntityType<AdvancedVampireEntity>> ADVANCED_VAMPIRE = ModEntities.prepareEntityType("advanced_vampire", () -> EntityType.Builder.m_20704_(AdvancedVampireEntity::new, (MobCategory)VReference.VAMPIRE_CREATURE_TYPE).m_20699_(0.6f, 1.95f), true);
    public static final RegistryObject<EntityType<ConvertedCreatureEntity<?>>> CONVERTED_CREATURE = ModEntities.prepareEntityType("converted_creature", () -> EntityType.Builder.m_20704_(ConvertedCreatureEntity::new, (MobCategory)MobCategory.CREATURE), false);
    public static final RegistryObject<EntityType<DummyBittenAnimalEntity>> DUMMY_CREATURE = ModEntities.prepareEntityType("dummy_creature", () -> EntityType.Builder.m_20704_(DummyBittenAnimalEntity::new, (MobCategory)MobCategory.CREATURE), true);
    public static final RegistryObject<EntityType<BlindingBatEntity>> BLINDING_BAT = ModEntities.prepareEntityType("blinding_bat", () -> EntityType.Builder.m_20704_(BlindingBatEntity::new, (MobCategory)MobCategory.AMBIENT).m_20699_(0.5f, 0.9f), true);
    public static final RegistryObject<EntityType<AdvancedHunterEntity.IMob>> ADVANCED_HUNTER_IMOB = ModEntities.prepareEntityType("advanced_hunter_imob", () -> EntityType.Builder.m_20704_(AdvancedHunterEntity.IMob::new, (MobCategory)VReference.HUNTER_CREATURE_TYPE).m_20699_(0.6f, 1.95f), false);
    public static final RegistryObject<EntityType<AdvancedVampireEntity.IMob>> ADVANCED_VAMPIRE_IMOB = ModEntities.prepareEntityType("advanced_vampire_imob", () -> EntityType.Builder.m_20704_(AdvancedVampireEntity.IMob::new, (MobCategory)VReference.VAMPIRE_CREATURE_TYPE).m_20699_(0.6f, 1.95f), false);
    public static final RegistryObject<EntityType<ConvertedCreatureEntity.IMob<?>>> CONVERTED_CREATURE_IMOB = ModEntities.prepareEntityType("converted_creature_imob", () -> EntityType.Builder.m_20704_(ConvertedCreatureEntity.IMob::new, (MobCategory)MobCategory.CREATURE), false);
    public static final RegistryObject<EntityType<ConvertedSheepEntity>> CONVERTED_SHEEP = ModEntities.prepareEntityType("converted_sheep", () -> EntityType.Builder.m_20704_(ConvertedSheepEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f), false);
    public static final RegistryObject<EntityType<ConvertedCowEntity>> CONVERTED_COW = ModEntities.prepareEntityType("converted_cow", () -> EntityType.Builder.m_20704_(ConvertedCowEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.4f), false);
    public static final RegistryObject<EntityType<CrossbowArrowEntity>> CROSSBOW_ARROW = ModEntities.prepareEntityType("crossbow_arrow", () -> EntityType.Builder.m_20704_(CrossbowArrowEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setCustomClientFactory((spawnEntity, world) -> new CrossbowArrowEntity((EntityType<? extends CrossbowArrowEntity>)((EntityType)CROSSBOW_ARROW.get()), (Level)world)), false);
    public static final RegistryObject<EntityType<DarkBloodProjectileEntity>> DARK_BLOOD_PROJECTILE = ModEntities.prepareEntityType("dark_blood_projectile", () -> EntityType.Builder.m_20704_(DarkBloodProjectileEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.6f, 0.6f).m_20719_().setCustomClientFactory((spawnEntity, world) -> new DarkBloodProjectileEntity((EntityType<? extends DarkBloodProjectileEntity>)((EntityType)DARK_BLOOD_PROJECTILE.get()), (Level)world)), false);
    public static final RegistryObject<EntityType<DummyHunterTrainerEntity>> HUNTER_TRAINER_DUMMY = ModEntities.prepareEntityType("hunter_trainer_dummy", () -> EntityType.Builder.m_20704_(DummyHunterTrainerEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.6f, 1.95f), true);
    public static final RegistryObject<EntityType<AreaParticleCloudEntity>> PARTICLE_CLOUD = ModEntities.prepareEntityType("particle_cloud", () -> EntityType.Builder.m_20704_(AreaParticleCloudEntity::new, (MobCategory)MobCategory.MISC).m_20699_(6.0f, 0.5f).m_20719_().setCustomClientFactory((spawnEntity, world) -> new AreaParticleCloudEntity((EntityType<? extends AreaParticleCloudEntity>)((EntityType)PARTICLE_CLOUD.get()), (Level)world)), false);
    public static final RegistryObject<EntityType<SoulOrbEntity>> SOUL_ORB = ModEntities.prepareEntityType("soul_orb", () -> EntityType.Builder.m_20704_(SoulOrbEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20719_().setCustomClientFactory((spawnEntity, world) -> new SoulOrbEntity((EntityType<? extends SoulOrbEntity>)((EntityType)SOUL_ORB.get()), (Level)world)), false);
    public static final RegistryObject<EntityType<ThrowableItemEntity>> THROWABLE_ITEM = ModEntities.prepareEntityType("throwable_item", () -> EntityType.Builder.m_20704_(ThrowableItemEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).setCustomClientFactory((spawnEntity, world) -> new ThrowableItemEntity((EntityType<? extends ThrowableItemEntity>)((EntityType)THROWABLE_ITEM.get()), (Level)world)), false);
    public static final RegistryObject<EntityType<BasicVampireEntity.IMob>> VAMPIRE_IMOB = ModEntities.prepareEntityType("vampire_imob", () -> EntityType.Builder.m_20704_(BasicVampireEntity.IMob::new, (MobCategory)VReference.VAMPIRE_CREATURE_TYPE).m_20699_(0.6f, 1.95f), false);
    public static final RegistryObject<EntityType<BasicHunterEntity.IMob>> HUNTER_IMOB = ModEntities.prepareEntityType("hunter_imob", () -> EntityType.Builder.m_20704_(BasicHunterEntity.IMob::new, (MobCategory)VReference.HUNTER_CREATURE_TYPE).m_20699_(0.6f, 1.95f), false);
    public static final RegistryObject<EntityType<AggressiveVillagerEntity>> VILLAGER_ANGRY = ModEntities.prepareEntityType("villager_angry", () -> EntityType.Builder.m_20704_(AggressiveVillagerEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.95f), false);
    public static final RegistryObject<EntityType<ConvertedVillagerEntity>> VILLAGER_CONVERTED = ModEntities.prepareEntityType("villager_converted", () -> EntityType.Builder.m_20704_(ConvertedVillagerEntity::new, (MobCategory)VReference.VAMPIRE_CREATURE_TYPE).m_20699_(0.6f, 1.95f), true);
    public static final RegistryObject<EntityType<ConvertedHorseEntity>> CONVERTED_HORSE = ModEntities.prepareEntityType("converted_horse", () -> EntityType.Builder.m_20704_(ConvertedHorseEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.3964844f, 1.6f), true);
    public static final RegistryObject<EntityType<VampireMinionEntity>> VAMPIRE_MINION = ModEntities.prepareEntityType("vampire_minion", () -> EntityType.Builder.m_20704_(VampireMinionEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.95f), false);
    public static final RegistryObject<EntityType<ConvertedDonkeyEntity>> CONVERTED_DONKEY = ModEntities.prepareEntityType("converted_donkey", () -> EntityType.Builder.m_20704_(ConvertedDonkeyEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.3964844f, 1.5f), true);
    public static final RegistryObject<EntityType<ConvertedMuleEntity>> CONVERTED_MULE = ModEntities.prepareEntityType("converted_mule", () -> EntityType.Builder.m_20704_(ConvertedMuleEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(1.3964844f, 1.5f), true);
    public static final RegistryObject<EntityType<HunterMinionEntity>> HUNTER_MINION = ModEntities.prepareEntityType("hunter_minion", () -> EntityType.Builder.m_20704_(HunterMinionEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.95f), false);
    public static final RegistryObject<EntityType<VampireTaskMasterEntity>> TASK_MASTER_VAMPIRE = ModEntities.prepareEntityType("task_master_vampire", () -> EntityType.Builder.m_20704_(VampireTaskMasterEntity::new, (MobCategory)VReference.VAMPIRE_CREATURE_TYPE).m_20699_(0.6f, 1.95f), true);
    public static final RegistryObject<EntityType<HunterTaskMasterEntity>> TASK_MASTER_HUNTER = ModEntities.prepareEntityType("task_master_hunter", () -> EntityType.Builder.m_20704_(HunterTaskMasterEntity::new, (MobCategory)VReference.HUNTER_CREATURE_TYPE).m_20699_(0.6f, 1.95f), true);
    public static final RegistryObject<EntityType<SitEntity>> dummy_sit_entity = ModEntities.prepareEntityType("dummy_sit_entity", () -> EntityType.Builder.m_20704_(SitEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0E-4f, 1.0E-4f).setTrackingRange(256).setUpdateInterval(20), false);
    public static final RegistryObject<EntityType<VampirismBoatEntity>> BOAT = ModEntities.prepareEntityType("boat", () -> EntityType.Builder.m_20704_(VampirismBoatEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).setCustomClientFactory((spawnEntity, level) -> new VampirismBoatEntity((Level)level, spawnEntity.getPosX(), spawnEntity.getPosY(), spawnEntity.getPosZ())), false);
    public static final RegistryObject<EntityType<VampirismChestBoatEntity>> CHEST_BOAT = ModEntities.prepareEntityType("chest_boat", () -> EntityType.Builder.m_20704_(VampirismChestBoatEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).setCustomClientFactory((spawnEntity, level) -> new VampirismChestBoatEntity((Level)level, spawnEntity.getPosX(), spawnEntity.getPosY(), spawnEntity.getPosZ())), false);
    public static final RegistryObject<EntityType<ConvertedFoxEntity>> CONVERTED_FOX = ModEntities.prepareEntityType("converted_fox", () -> EntityType.Builder.m_20704_(ConvertedFoxEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 0.7f).m_20714_(new Block[]{Blocks.f_50685_}), true);
    public static final RegistryObject<EntityType<ConvertedGoatEntity>> CONVERTED_GOAT = ModEntities.prepareEntityType("converted_goat", () -> EntityType.Builder.m_20704_(ConvertedGoatEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.9f, 1.3f), true);
    public static final RegistryObject<EntityType<VulnerableRemainsDummyEntity>> VULNERABLE_REMAINS_DUMMY = ModEntities.prepareEntityType("vulnerable_remains_dummy", () -> EntityType.Builder.m_20704_(VulnerableRemainsDummyEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.02f, 1.02f).setTrackingRange(10).setUpdateInterval(20), false);
    public static final RegistryObject<EntityType<RemainsDefenderEntity>> REMAINS_DEFENDER = ModEntities.prepareEntityType("remains_defender", () -> EntityType.Builder.m_20704_(RemainsDefenderEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.3f, 0.3f).setTrackingRange(10).setUpdateInterval(20), false);
    public static final RegistryObject<EntityType<GhostEntity>> GHOST = ModEntities.prepareEntityType("ghost", () -> EntityType.Builder.m_20704_(GhostEntity::new, (MobCategory)VReference.VAMPIRE_CREATURE_TYPE).m_20699_(0.35f, 0.5f).setTrackingRange(10).setUpdateInterval(20).m_20719_(), true);
    public static final RegistryObject<Codec<? extends Converter>> DEFAULT_CONVERTER = CONVERTING_HELPER.register("default", () -> DefaultConverter.CODEC);
    public static final RegistryObject<Codec<? extends Converter>> SPECIAL_CONVERTER = CONVERTING_HELPER.register("special", () -> SpecialConverter.CODEC);

    static void registerCustomExtendedCreatures() {
        IVampirismEntityRegistry registry = VampirismAPI.entityRegistry();
    }

    static void register(IEventBus bus) {
        ENTITY_TYPES.register(bus);
        CONVERTING_HELPER.register(bus);
    }

    static void onRegisterSpawns(@NotNull SpawnPlacementRegisterEvent event) {
        event.register((EntityType)ADVANCED_HUNTER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HunterBaseEntity::spawnPredicateHunter, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)ADVANCED_VAMPIRE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, VampireBaseEntity::spawnPredicateVampire, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)BLINDING_BAT.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, BlindingBatEntity::spawnPredicate, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)DUMMY_CREATURE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, DummyBittenAnimalEntity::spawnPredicate, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)CONVERTED_CREATURE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedCreatureEntity::spawnPredicate, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)CONVERTED_SHEEP.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedSheepEntity::checkConvertedSheepSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)CONVERTED_COW.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedCowEntity::checkConvertedCowSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)HUNTER_TRAINER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)HUNTER_TRAINER_DUMMY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)VAMPIRE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, VampireBaseEntity::spawnPredicateVampire, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)VAMPIRE_BARON.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, VampireBaronEntity::spawnPredicateBaron, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)HUNTER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, HunterBaseEntity::spawnPredicateHunter, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)VILLAGER_ANGRY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)VILLAGER_CONVERTED.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Mob::m_217057_, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)CONVERTED_HORSE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedHorseEntity::checkConvertedHorseSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)CONVERTED_DONKEY.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedDonkeyEntity::checkConvertedDonkeySpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)CONVERTED_MULE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedMuleEntity::checkConvertedMuleSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)CONVERTED_FOX.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedFoxEntity::checkConvertedFoxSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register((EntityType)CONVERTED_GOAT.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, ConvertedGoatEntity::checkConvertedGoatSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
    }

    static void onRegisterEntityTypeAttributes(@NotNull EntityAttributeCreationEvent event) {
        event.put((EntityType)ADVANCED_HUNTER.get(), AdvancedHunterEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)ADVANCED_HUNTER_IMOB.get(), AdvancedHunterEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)ADVANCED_VAMPIRE.get(), AdvancedVampireEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)ADVANCED_VAMPIRE_IMOB.get(), AdvancedVampireEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)BLINDING_BAT.get(), Bat.m_27455_().m_22265_());
        event.put((EntityType)CONVERTED_CREATURE.get(), BasicVampireEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)CONVERTED_CREATURE_IMOB.get(), BasicVampireEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)CONVERTED_HORSE.get(), ConvertedHorseEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)CONVERTED_SHEEP.get(), ConvertedSheepEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)CONVERTED_COW.get(), ConvertedCowEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)CONVERTED_DONKEY.get(), ConvertedDonkeyEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)CONVERTED_MULE.get(), ConvertedMuleEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)DUMMY_CREATURE.get(), BasicVampireEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)HUNTER.get(), BasicHunterEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)HUNTER_IMOB.get(), BasicHunterEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)HUNTER_TRAINER.get(), HunterTrainerEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)HUNTER_TRAINER_DUMMY.get(), HunterTrainerEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)VAMPIRE.get(), BasicVampireEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)VAMPIRE_IMOB.get(), BasicVampireEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)VAMPIRE_BARON.get(), VampireBaronEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)VILLAGER_ANGRY.get(), AggressiveVillagerEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)VILLAGER_CONVERTED.get(), ConvertedVillagerEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)HUNTER_MINION.get(), HunterMinionEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)VAMPIRE_MINION.get(), VampireMinionEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)TASK_MASTER_HUNTER.get(), HunterTaskMasterEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)TASK_MASTER_VAMPIRE.get(), VampireTaskMasterEntity.getAttributeBuilder().m_22265_());
        event.put((EntityType)CONVERTED_FOX.get(), ConvertedFoxEntity.m_28553_().m_22265_());
        event.put((EntityType)CONVERTED_GOAT.get(), ConvertedGoatEntity.m_149401_().m_22265_());
        event.put((EntityType)VULNERABLE_REMAINS_DUMMY.get(), VulnerableRemainsDummyEntity.createAttributes().m_22265_());
        event.put((EntityType)REMAINS_DEFENDER.get(), RemainsDefenderEntity.createAttributes().m_22265_());
        event.put((EntityType)GHOST.get(), GhostEntity.createAttributes().m_22265_());
    }

    static void onModifyEntityTypeAttributes(@NotNull EntityAttributeModificationEvent event) {
        event.add(EntityType.f_20532_, (Attribute)ModAttributes.SUNDAMAGE.get());
        event.add(EntityType.f_20532_, (Attribute)ModAttributes.BLOOD_EXHAUSTION.get());
        event.add(EntityType.f_20532_, (Attribute)ModAttributes.NEONATAL_DURATION.get());
        event.add(EntityType.f_20532_, (Attribute)ModAttributes.DBNO_DURATION.get());
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> prepareEntityType(String id, @NotNull Supplier<EntityType.Builder<T>> builder, boolean spawnable) {
        return ENTITY_TYPES.register(id, () -> {
            EntityType.Builder type = ((EntityType.Builder)builder.get()).setTrackingRange(80).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true);
            if (!spawnable) {
                type.m_20698_();
            }
            return type.m_20712_("vampirism:" + id);
        });
    }

    @NotNull
    public static Set<EntityType<?>> getAllEntities() {
        return ENTITY_TYPES.getEntries().stream().map(RegistryObject::get).collect(Collectors.toUnmodifiableSet());
    }
}

