/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.vampirism.mixin.LootTableAccessor;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ModLootTables {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<ResourceLocation> LOOT_TABLES = Sets.newHashSet();
    public static final ResourceLocation CHEST_HUNTER_TRAINER = ModLootTables.register("chests/village/hunter_trainer");
    public static final ResourceLocation CHEST_VAMPIRE_DUNGEON = ModLootTables.register("chests/dungeon/vampire_dungeon");
    public static final ResourceLocation CHEST_VAMPIRE_HUT = ModLootTables.register("chests/vampire_hut");
    public static final ResourceLocation CHEST_VAMPIRE_ALTAR = ModLootTables.register("chests/vampire_altar");
    public static final ResourceLocation CHEST_CRYPT = ModLootTables.register("chests/crypt");
    public static final ResourceLocation CHEST_HUNTER_OUTPOST_SMITH = ModLootTables.register("chests/hunter_outpost_smith");
    public static final ResourceLocation CHEST_HUNTER_OUTPOST_TENT = ModLootTables.register("chests/hunter_outpost_tent");
    public static final ResourceLocation CHEST_HUNTER_OUTPOST_ALCHEMY = ModLootTables.register("chests/hunter_outpost_alchemy");
    public static final ResourceLocation CHEST_HUNTER_OUTPOST_TOWER_FOOD = ModLootTables.register("chests/hunter_outpost_tower_food");
    public static final ResourceLocation CHEST_HUNTER_OUTPOST_TOWER_BASIC = ModLootTables.register("chests/hunter_outpost_tower_basic");
    public static final ResourceLocation CHEST_HUNTER_OUTPOST_TOWER_SPECIAL = ModLootTables.register("chests/hunter_outpost_tower_special");
    private static final Map<String, ResourceLocation> INJECTION_TABLES = Maps.newHashMap();
    public static final ResourceLocation ABANDONED_MINESHAFT = ModLootTables.registerInject("abandoned_mineshaft");
    public static final ResourceLocation JUNGLE_TEMPLE = ModLootTables.registerInject("jungle_temple");
    public static final ResourceLocation STRONGHOLD_CORRIDOR = ModLootTables.registerInject("stronghold_corridor");
    public static final ResourceLocation DESERT_PYRAMID = ModLootTables.registerInject("desert_pyramid");
    public static final ResourceLocation STRONGHOLD_LIBRARY = ModLootTables.registerInject("stronghold_library");
    private static int injected = 0;

    @NotNull
    static ResourceLocation registerInject(String resourceName) {
        ResourceLocation registryName = ModLootTables.register("inject/" + resourceName);
        INJECTION_TABLES.put(resourceName, registryName);
        return registryName;
    }

    @NotNull
    static ResourceLocation register(@NotNull String resourceName) {
        return ModLootTables.register(new ResourceLocation("vampirism", resourceName));
    }

    @NotNull
    static ResourceLocation register(@NotNull ResourceLocation resourceLocation) {
        LOOT_TABLES.add(resourceLocation);
        return resourceLocation;
    }

    @NotNull
    public static Set<ResourceLocation> getLootTables() {
        return ImmutableSet.copyOf(LOOT_TABLES);
    }

    @SubscribeEvent
    public static void onLootLoad(@NotNull LootTableLoadEvent event) {
        String file;
        String prefix = "minecraft:chests/";
        String name = event.getName().toString();
        if (name.startsWith(prefix) && INJECTION_TABLES.containsKey(file = name.substring(name.indexOf(prefix) + prefix.length()))) {
            try {
                ((LootTableAccessor)event.getTable()).getPools().add(ModLootTables.getInjectPool(file));
                ++injected;
            }
            catch (NullPointerException e) {
                LOGGER.warn("Loottable {} is broken by some other mod. Cannot add Vampirism loot to it.", (Object)name);
            }
        }
    }

    @NotNull
    private static LootPool getInjectPool(String entryName) {
        LootPoolSingletonContainer.Builder entryBuilder = LootTableReference.m_79776_((ResourceLocation)INJECTION_TABLES.get(entryName)).m_79707_(1);
        return LootPool.m_79043_().m_165135_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entryBuilder).m_79082_();
    }

    public static int checkAndResetInsertedAll() {
        int i = injected;
        injected = 0;
        return Math.max(0, INJECTION_TABLES.size() - i);
    }
}

