/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class ModStats {
    private static final Map<ResourceLocation, StatFormatter> ALL_STATS = new HashMap<ResourceLocation, StatFormatter>();
    private static final Map<ResourceKey<IAction<?>>, ResourceLocation> ACTION_USED_STATS = new HashMap();
    private static final Map<ResourceKey<IAction<?>>, ResourceLocation> ACTION_TIME_STATS = new HashMap();
    private static final StatFormatter BUCKED_FORMATTER = stat -> StatFormatter.f_12873_.m_12886_(stat) + " mb";
    public static final ResourceLocation weapon_table = ModStats.add("weapon_table");
    public static final ResourceLocation interact_alchemical_cauldron = ModStats.add("interact_alchemical_cauldron");
    public static final ResourceLocation interact_with_alchemy_table = ModStats.add("interact_with_alchemy_table");
    public static final ResourceLocation interact_with_altar_of_infusion = ModStats.add("interact_with_altar_of_infusion");
    public static final ResourceLocation interact_with_altar_inspiration = ModStats.add("interact_with_altar_inspiration");
    public static final ResourceLocation interact_with_blood_grinder = ModStats.add("interact_with_blood_grinder");
    public static final ResourceLocation interact_with_garlic_diffuser = ModStats.add("interact_with_garlic_diffuser");
    public static final ResourceLocation interact_with_fog_diffuser = ModStats.add("interact_with_fog_diffuser");
    public static final ResourceLocation interact_with_research_table = ModStats.add("interact_with_research_table");
    public static final ResourceLocation interact_with_ancient_beacon = ModStats.add("interact_with_ancient_beacon");
    public static final ResourceLocation interact_with_totem = ModStats.add("interact_with_totem");
    public static final ResourceLocation interact_with_potion_table = ModStats.add("interact_with_potion_table");
    public static final ResourceLocation interact_with_injection_chair = ModStats.add("interact_with_injection_chair");
    public static final ResourceLocation interact_with_coffin = ModStats.add("interact_with_coffin");
    public static final ResourceLocation interact_with_throne = ModStats.add("interact_with_throne");
    public static final ResourceLocation capture_village = ModStats.add("capture_village");
    public static final ResourceLocation defend_village = ModStats.add("defend_village");
    public static final ResourceLocation win_village_capture = ModStats.add("win_village_capture");
    public static final ResourceLocation infected_creatures = ModStats.add("infected_creatures");
    public static final ResourceLocation mother_defeated = ModStats.add("mother_defeated");
    public static final ResourceLocation killed_with_stake = ModStats.add("killed_with_stake");
    public static final ResourceLocation resurrected = ModStats.add("resurrected");
    public static final ResourceLocation actions_used = ModStats.add("actions_used");
    public static final ResourceLocation skills_unlocked = ModStats.add("skills_unlocked");
    public static final ResourceLocation skills_reset = ModStats.add("skills_reset");
    public static final ResourceLocation tasks_accepted = ModStats.add("tasks_accepted");
    public static final ResourceLocation tasks_completed = ModStats.add("tasks_completed");
    public static final ResourceLocation blood_drunk = ModStats.add("blood_drunk", BUCKED_FORMATTER);
    public static final ResourceLocation amount_bitten = ModStats.add("amount_bitten");
    public static final ResourceLocation altar_of_inspiration_rituals_performed = ModStats.add("altar_of_inspiration_rituals_performed");
    public static final ResourceLocation altar_of_infusion_rituals_performed = ModStats.add("altar_of_infusion_rituals_performed");
    public static final ResourceLocation items_filled_on_blood_pedestal = ModStats.add("items_filled_on_blood_pedestal");

    static void registerCustomStats() {
        ModRegistries.ACTIONS.get().getEntries().forEach(entry -> {
            ResourceLocation location = ((ResourceKey)entry.getKey()).m_135782_();
            ACTION_USED_STATS.put((ResourceKey)entry.getKey(), ModStats.add(location.m_246208_("action_used_")));
        });
        ModRegistries.ACTIONS.get().getEntries().stream().filter(s -> s.getValue() instanceof ILastingAction).forEach(entry -> {
            ResourceLocation location = ((ResourceKey)entry.getKey()).m_135782_();
            ACTION_TIME_STATS.put((ResourceKey)entry.getKey(), ModStats.add(location.m_246208_("action_time_"), StatFormatter.f_12876_));
        });
        ALL_STATS.forEach(ModStats::register);
    }

    public static Optional<Component> getStatDisplay(ResourceLocation stat) {
        if (ACTION_TIME_STATS.containsValue(stat)) {
            return Optional.of(Component.m_237110_((String)"stat.vampirism.action_time", (Object[])new Object[]{Component.m_237115_((String)("action." + stat.m_135827_() + "." + stat.m_135815_().substring(12)))}));
        }
        if (ACTION_USED_STATS.containsValue(stat)) {
            return Optional.of(Component.m_237110_((String)"stat.vampirism.action_used", (Object[])new Object[]{Component.m_237115_((String)("action." + stat.m_135827_() + "." + stat.m_135815_().substring(12)))}));
        }
        return Optional.empty();
    }

    private static ResourceLocation add(String name) {
        return ModStats.add(name, StatFormatter.f_12873_);
    }

    private static ResourceLocation add(String name, StatFormatter formatter) {
        return ModStats.add(new ResourceLocation("vampirism", name), formatter);
    }

    private static ResourceLocation add(ResourceLocation id) {
        return ModStats.add(id, StatFormatter.f_12873_);
    }

    private static ResourceLocation add(ResourceLocation id, StatFormatter formatter) {
        ALL_STATS.put(id, formatter);
        return id;
    }

    private static void register(@NotNull ResourceLocation id, StatFormatter formatter) {
        Registry.m_122965_((Registry)BuiltInRegistries.f_256771_, (ResourceLocation)id, (Object)id);
        Stats.f_12988_.m_12899_((Object)id, formatter);
    }

    public static void updateActionTime(Player player, ILastingAction<?> action) {
        RegUtil.key(action).ifPresent(key -> {
            ResourceLocation location = ACTION_TIME_STATS.get(key);
            player.m_36220_(location);
        });
    }

    public static void updateActionUsed(Player player, IAction<?> action) {
        RegUtil.key(action).ifPresent(key -> {
            ResourceLocation location = ACTION_USED_STATS.get(key);
            player.m_36220_(location);
        });
        player.m_36220_(actions_used);
    }
}

