/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.effects;

import de.teamlapen.lib.lib.util.LogUtil;
import de.teamlapen.vampirism.api.entity.effect.EffectWithNoCounter;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModStats;
import de.teamlapen.vampirism.effects.VampirismEffect;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.skills.SkillHandler;
import de.teamlapen.vampirism.entity.player.skills.SkillNode;
import de.teamlapen.vampirism.misc.VampirismLogger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class OblivionEffect
extends VampirismEffect
implements EffectWithNoCounter {
    private static final Logger LOGGER = LogManager.getLogger();

    public OblivionEffect() {
        super(MobEffectCategory.NEUTRAL, 5149489);
    }

    @Override
    @NotNull
    public List<ItemStack> getCurativeItems() {
        return Collections.emptyList();
    }

    @Override
    public void m_6742_(@NotNull LivingEntity entityLivingBaseIn, int amplifier) {
        if (!entityLivingBaseIn.m_20193_().f_46443_ && entityLivingBaseIn instanceof Player) {
            entityLivingBaseIn.m_7292_(new MobEffectInstance(MobEffects.f_19604_, this.getTickDuration(amplifier), 5, false, false, false, null, Optional.empty()));
            FactionPlayerHandler.getOpt((Player)entityLivingBaseIn).map(FactionPlayerHandler::getCurrentFactionPlayer).flatMap(factionPlayer -> factionPlayer).ifPresent(factionPlayer -> {
                ISkillHandler<?> skillHandler = factionPlayer.getSkillHandler();
                Optional<SkillNode> nodeOPT = ((SkillHandler)skillHandler).anyLastNode();
                if (nodeOPT.isPresent()) {
                    for (ISkill<?> element : nodeOPT.get().getElements()) {
                        skillHandler.disableSkill(element);
                    }
                } else {
                    entityLivingBaseIn.m_21195_((MobEffect)ModEffects.OBLIVION.get());
                    ((Player)entityLivingBaseIn).m_5661_((Component)Component.m_237115_((String)"text.vampirism.skill.skills_reset"), true);
                    LOGGER.debug(LogUtil.FACTION, "Skills were reset for {}", (Object)entityLivingBaseIn.m_7755_().getString());
                    VampirismLogger.info(VampirismLogger.SKILLS, "Skills were reset for {}", entityLivingBaseIn.m_7755_().getString());
                    ((Player)entityLivingBaseIn).m_36220_(ModStats.skills_reset);
                }
            });
        }
    }

    @Override
    public boolean m_6584_(int duration, int amplifier) {
        return duration % this.getTickDuration(amplifier) == 0;
    }

    private int getTickDuration(int amplifier) {
        return 1000 / (amplifier + 1);
    }
}

