/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.converted;

import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.converted.CurableConvertedCreature;
import de.teamlapen.vampirism.entity.vampire.VampireBaseEntity;
import de.teamlapen.vampirism.mixin.WalkAnimationStateAccessor;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertedCreatureEntity<T extends PathfinderMob>
extends VampireBaseEntity
implements CurableConvertedCreature<T, ConvertedCreatureEntity<T>>,
ISyncable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EntityDataAccessor<Boolean> CONVERTING = SynchedEntityData.m_135353_(ConvertedCreatureEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> OVERLAY_TEXTURE = SynchedEntityData.m_135353_(ConvertedCreatureEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private boolean entityChanged = false;
    public Optional<T> entityCreature = Optional.empty();
    private boolean canDespawn = false;
    private final CurableConvertedCreature.Data<T> convertibleData = new CurableConvertedCreature.Data();

    public static boolean spawnPredicate(EntityType<? extends ConvertedCreatureEntity<?>> entityType, @NotNull LevelAccessor iWorld, MobSpawnType spawnReason, @NotNull BlockPos blockPos, RandomSource random) {
        return (iWorld.m_8055_(blockPos.m_7495_()).m_60734_() == Blocks.f_50440_ || iWorld.m_8055_(blockPos.m_7495_()).m_204336_(ModTags.Blocks.CURSED_EARTH)) && iWorld.m_45524_(blockPos, 0) > 8;
    }

    public ConvertedCreatureEntity(EntityType<? extends ConvertedCreatureEntity<?>> type, Level world) {
        super(type, world, false);
        this.enableImobConversion();
        this.f_21364_ = 2;
    }

    @Override
    public CurableConvertedCreature.Data<T> data() {
        return this.convertibleData;
    }

    @Override
    public void handleEntityEventSuper(byte id) {
        super.m_7822_(id);
    }

    @Override
    public InteractionResult mobInteractSuper(@NotNull Player player, @NotNull InteractionHand hand) {
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean hurtSuper(DamageSource damageSource, float amount) {
        return super.m_6469_(damageSource, amount);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.writeOldEntityToNBT(pCompound);
        pCompound.m_128379_("converter_canDespawn", this.canDespawn);
        this.addAdditionalSaveDataC(pCompound);
    }

    @Override
    public void m_8107_() {
        this.entityCreature.ifPresent(creature -> this.aiStepC(creature.m_6095_()));
        super.m_8107_();
    }

    @Override
    public void m_6667_(@NotNull DamageSource pDamageSource) {
        super.m_6667_(pDamageSource);
        this.dieC(pDamageSource);
    }

    @Override
    @NotNull
    public MobType m_6336_() {
        return VReference.VAMPIRE_CREATURE_ATTRIBUTE;
    }

    @NotNull
    public Component m_7755_() {
        return this.entityCreature.map(creature -> this.getNameC(() -> ((EntityType)creature.m_6095_()).m_20676_())).orElseGet(() -> super.m_7755_());
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        return this.hurtC(pSource, pAmount);
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        return this.mobInteractC(pPlayer, pHand);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.registerConvertingData(this);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.registerGoalsC();
    }

    @Override
    protected void m_6153_() {
        super.m_6153_();
        this.tickDeathC();
    }

    @Override
    public void m_8119_() {
        if (!this.m_9236_().f_46443_ && this.entityCreature.isEmpty()) {
            LOGGER.debug("Setting dead, since creature is null");
            this.m_146870_();
        }
        super.m_8119_();
        this.tickC();
    }

    @Override
    public T cureEntity(@NotNull ServerLevel world, @NotNull PathfinderMob entity, @NotNull EntityType<T> newType) {
        return (T)this.entityCreature.map(creature -> {
            creature.revive();
            return creature;
        }).orElseGet(() -> CurableConvertedCreature.super.cureEntity(world, entity, newType));
    }

    public void m_6075_() {
        super.m_6075_();
        this.entityCreature.ifPresent(entityCreature -> {
            entityCreature.m_20359_((Entity)this);
            entityCreature.f_19856_ = this.f_19856_;
            entityCreature.f_19855_ = this.f_19855_;
            entityCreature.f_19854_ = this.f_19854_;
            entityCreature.f_20885_ = this.f_20885_;
            entityCreature.f_19860_ = this.f_19860_;
            entityCreature.f_19859_ = this.f_19859_;
            entityCreature.f_20886_ = this.f_20886_;
            entityCreature.m_20256_(this.m_20184_());
            entityCreature.f_19790_ = this.f_19790_;
            entityCreature.f_19791_ = this.f_19791_;
            entityCreature.f_19792_ = this.f_19792_;
            entityCreature.f_20916_ = this.f_20916_;
            entityCreature.f_20917_ = this.f_20917_;
            entityCreature.f_20921_ = this.f_20921_;
            entityCreature.f_20920_ = this.f_20920_;
            ((WalkAnimationStateAccessor)entityCreature.f_267362_).setSpeed(((WalkAnimationStateAccessor)this.f_267362_).getSpeed());
            ((WalkAnimationStateAccessor)entityCreature.f_267362_).setSpeedOld(((WalkAnimationStateAccessor)this.f_267362_).getSpeedOld());
            ((WalkAnimationStateAccessor)entityCreature.f_267362_).setPosition(((WalkAnimationStateAccessor)this.f_267362_).getPosition());
            entityCreature.f_20883_ = this.f_20883_;
            entityCreature.f_20884_ = this.f_20884_;
            entityCreature.f_20919_ = this.f_20919_;
        });
        if (this.entityChanged) {
            this.updateEntityAttributes();
            this.entityChanged = false;
        }
    }

    @Override
    @NotNull
    public EntityDataAccessor<Boolean> getConvertingDataParam() {
        return CONVERTING;
    }

    @Override
    public EntityDataAccessor<String> getSourceEntityDataParam() {
        return OVERLAY_TEXTURE;
    }

    public Optional<T> getOldCreature() {
        return this.entityCreature;
    }

    @Override
    public void loadUpdateFromNBT(@NotNull CompoundTag nbt) {
        if (nbt.m_128441_("entity_old")) {
            this.setEntityCreature(EntityType.m_20642_((CompoundTag)nbt.m_128469_("entity_old"), (Level)this.m_20193_()).orElse(null));
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.readAdditionalSaveDataC(nbt);
        if (nbt.m_128441_("entity_old")) {
            this.setEntityCreature(EntityType.m_20642_((CompoundTag)nbt.m_128469_("entity_old"), (Level)this.m_9236_()).orElse(null));
            if (this.entityCreature.isEmpty()) {
                LOGGER.warn("Failed to create old entity {}. Maybe the entity does not exist anymore", (Object)nbt.m_128469_("entity_old"));
            }
        } else {
            LOGGER.warn("Saved entity did not have a old entity");
        }
        if (nbt.m_128441_("converted_canDespawn")) {
            this.canDespawn = nbt.m_128471_("converted_canDespawn");
        }
        if (nbt.m_128425_("ConversionTime", 99) && nbt.m_128451_("ConversionTime") > -1) {
            this.startConverting(nbt.m_128403_("ConversionPlayer") ? nbt.m_128342_("ConversionPlayer") : null, nbt.m_128451_("ConversionTime"), this);
        }
        if (!nbt.m_128441_("source_entity")) {
            this.getSourceEntityDataParamOpt().ifPresent(p -> this.getOldCreature().ifPresent(old -> this.getRepresentingEntity().m_20088_().m_135381_(p, (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)old.m_6095_()).toString())));
        }
    }

    public void m_8032_() {
        this.entityCreature.ifPresent(Mob::m_8032_);
    }

    public void m_6210_() {
        super.m_6210_();
        this.f_19816_ = this.entityCreature.map(Entity::m_20192_).orElse(Float.valueOf(0.5f)).floatValue();
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return super.m_6785_(distanceToClosestPlayer) && this.canDespawn;
    }

    public void setCanDespawn() {
        this.canDespawn = true;
    }

    public void setEntityCreature(@Nullable T creature) {
        PathfinderMob old = this.entityCreature.orElse(null);
        if (!Objects.equals(old, creature)) {
            this.entityCreature = Optional.ofNullable(creature);
            this.entityChanged = true;
            this.f_19815_ = this.entityCreature.map(s -> s.f_19815_).orElseGet(() -> EntityDimensions.m_20398_((float)0.5f, (float)0.5f));
        }
        if (this.entityCreature.isPresent() && this.getConvertedHandler() == null) {
            LOGGER.warn("Cannot find converting handler for converted creature {} ({})", (Object)this, this.entityCreature);
            this.entityCreature = Optional.empty();
        }
    }

    @Nullable
    public ItemEntity m_5552_(@NotNull ItemStack stack, float offsetY) {
        ItemStack actualDrop = stack;
        Item item = stack.m_41720_();
        if (item.m_41472_() && item.getFoodProperties(stack, (LivingEntity)this).m_38746_()) {
            actualDrop = new ItemStack((ItemLike)Items.f_42583_, stack.m_41613_());
        }
        return super.m_5552_(actualDrop, offsetY);
    }

    @NotNull
    public String toString() {
        return "[" + super.toString() + " representing " + String.valueOf(this.entityCreature) + "]";
    }

    @Override
    public void writeFullUpdateToNBT(@NotNull CompoundTag nbt) {
        this.writeOldEntityToNBT(nbt);
    }

    @Nullable
    protected IConvertingHandler<?> getConvertedHandler() {
        if (this.entityCreature.isEmpty()) {
            return null;
        }
        IConvertingHandler handler = this.entityCreature.map(s -> VampirismAPI.entityRegistry().getEntry((PathfinderMob)s)).map(s -> s.convertingHandler).orElse(null);
        if (handler == null) {
            LOGGER.warn("No converting handler found for {}", this.entityCreature.get());
        }
        return handler;
    }

    @Override
    @NotNull
    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return iMob ? (EntityType)ModEntities.CONVERTED_CREATURE_IMOB.get() : (EntityType)ModEntities.CONVERTED_CREATURE.get();
    }

    @NotNull
    protected ResourceLocation m_7582_() {
        return this.entityCreature.map(Mob::m_5743_).orElseGet(() -> super.m_7582_());
    }

    protected void updateEntityAttributes() {
        IConvertingHandler<?> convertedHandler = this.getConvertedHandler();
        if (convertedHandler != null) {
            convertedHandler.updateEntityAttributes(this);
        }
    }

    private void writeOldEntityToNBT(@NotNull CompoundTag nbt) {
        this.entityCreature.ifPresent(creature -> {
            try {
                CompoundTag entity = new CompoundTag();
                creature.revive();
                creature.m_20223_(entity);
                creature.m_146870_();
                nbt.m_128365_("entity_old", (Tag)entity);
            }
            catch (Exception e) {
                LOGGER.error(String.format("Failed to write old entity (%s) to NBT. If this happens more often please report this to the mod author.", creature), (Throwable)e);
                this.setEntityCreature(null);
            }
        });
    }

    @Override
    public boolean m_6573_(@NotNull Player player) {
        return true;
    }

    @Override
    public float calculateFireDamage(float amount) {
        return CurableConvertedCreature.super.calculateFireDamage(amount);
    }

    public static class IMob<T extends PathfinderMob>
    extends ConvertedCreatureEntity<T>
    implements Enemy {
        public IMob(EntityType<? extends IMob<?>> type, Level world) {
            super((EntityType<? extends ConvertedCreatureEntity<?>>)type, world);
        }
    }
}

