/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.factions;

import de.teamlapen.lib.HelperLib;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.lib.lib.util.LogUtil;
import de.teamlapen.vampirism.REFERENCE;
import de.teamlapen.vampirism.advancements.critereon.FactionCriterionTrigger;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.VampirismCapabilities;
import de.teamlapen.vampirism.api.VampirismRegistries;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModAdvancements;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.entity.player.IVampirismPlayer;
import de.teamlapen.vampirism.entity.player.VampirismPlayerAttributes;
import de.teamlapen.vampirism.misc.VampirismLogger;
import de.teamlapen.vampirism.util.DamageHandler;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.RegUtil;
import de.teamlapen.vampirism.util.ScoreboardUtil;
import de.teamlapen.vampirism.util.VampirismEventFactory;
import de.teamlapen.vampirism.world.MinionWorldData;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FactionPlayerHandler
implements ISyncable.ISyncableEntityCapabilityInst,
IFactionPlayerHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Capability<IFactionPlayerHandler> CAP = VampirismCapabilities.FACTION_HANDLER_PLAYER;
    private final Player player;
    @NotNull
    private final Int2ObjectMap<IAction<?>> boundActions = new Int2ObjectArrayMap();
    @Nullable
    private IPlayableFaction<?> currentFaction = null;
    private int currentLevel = 0;
    private int currentLordLevel = 0;
    @Nullable
    private Boolean titleGender = null;

    @Deprecated
    @NotNull
    public static FactionPlayerHandler get(@NotNull Player player) {
        return (FactionPlayerHandler)player.getCapability(CAP, null).orElseThrow(() -> new IllegalStateException("Cannot get FactionPlayerHandler from EntityPlayer " + String.valueOf(player)));
    }

    @NotNull
    public static LazyOptional<FactionPlayerHandler> getOpt(@NotNull Player player) {
        LazyOptional opt = player.getCapability(CAP, null).cast();
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get Faction player capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt;
    }

    @NotNull
    public static Optional<? extends IFactionPlayer<?>> getCurrentFactionPlayer(@NotNull Player player) {
        LazyOptional opt = player.getCapability(CAP, null).cast();
        if (!opt.isPresent()) {
            LOGGER.warn("Cannot get Faction player capability. This might break mod functionality.", new Throwable().fillInStackTrace());
        }
        return opt.resolve().flatMap(FactionPlayerHandler::getCurrentFactionPlayer);
    }

    @NotNull
    public static ICapabilityProvider createNewCapability(final Player player) {
        return new ICapabilitySerializable<CompoundTag>(){
            final FactionPlayerHandler inst;
            final LazyOptional<IFactionPlayerHandler> opt;
            {
                this.inst = new FactionPlayerHandler(player);
                this.opt = LazyOptional.of(() -> this.inst);
            }

            public void deserializeNBT(@NotNull CompoundTag nbt) {
                this.inst.loadNBTData(nbt);
            }

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, Direction facing) {
                return CAP.orEmpty(capability, this.opt);
            }

            @NotNull
            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                this.inst.saveNBTData(tag);
                return tag;
            }
        };
    }

    private FactionPlayerHandler(Player player) {
        this.player = player;
    }

    @Override
    public boolean canJoin(IPlayableFaction<?> faction) {
        Event.Result res = VampirismEventFactory.fireCanJoinFactionEvent(this, this.currentFaction, faction);
        if (res == Event.Result.DEFAULT) {
            return this.currentFaction == null;
        }
        return res == Event.Result.ALLOW;
    }

    @Override
    public boolean canLeaveFaction() {
        return this.currentFaction == null || this.currentFaction.getPlayerCapability(this.player).map(IFactionPlayer::canLeaveFaction).orElse(false) != false;
    }

    public void copyFrom(@NotNull Player old) {
        FactionPlayerHandler oldP = FactionPlayerHandler.get(old);
        this.currentFaction = oldP.currentFaction;
        this.currentLevel = oldP.currentLevel;
        this.currentLordLevel = oldP.currentLordLevel;
        this.boundActions.putAll(oldP.boundActions);
        this.titleGender = oldP.titleGender;
        this.updateCache();
        this.notifyFaction(oldP.currentFaction, oldP.currentLevel);
    }

    @Nullable
    public IAction<?> getBoundAction(int id) {
        return (IAction)this.boundActions.get(id);
    }

    @Override
    @NotNull
    public ResourceLocation getCapKey() {
        return REFERENCE.FACTION_PLAYER_HANDLER_KEY;
    }

    @Override
    @Nullable
    public IPlayableFaction<?> getCurrentFaction() {
        return this.currentFaction;
    }

    @Override
    @NotNull
    public Optional<? extends IFactionPlayer<?>> getCurrentFactionPlayer() {
        return this.currentFaction == null ? Optional.empty() : this.currentFaction.getPlayerCapability(this.player).map(Optional::of).orElse(Optional.empty());
    }

    @Override
    public int getCurrentLevel() {
        return this.currentLevel;
    }

    @Override
    public int getCurrentLevel(IPlayableFaction<?> f) {
        return this.isInFaction(f) ? this.currentLevel : 0;
    }

    @Override
    public float getCurrentLevelRelative() {
        return this.currentFaction == null ? 0.0f : (float)this.currentLevel / (float)this.currentFaction.getHighestReachableLevel();
    }

    @Override
    @Nullable
    public IPlayableFaction<?> getLordFaction() {
        return this.currentLordLevel > 0 ? this.currentFaction : null;
    }

    @Override
    public int getLordLevel() {
        return this.currentLordLevel;
    }

    @Override
    @Nullable
    public Component getLordTitle() {
        return this.currentLordLevel == 0 || this.currentFaction == null ? null : this.currentFaction.getLordTitle(this.currentLordLevel, this.titleGender != null && this.titleGender != false);
    }

    @Override
    public boolean useFemaleLordTitle() {
        return this.titleGender != null && this.titleGender != false;
    }

    public int getMaxMinions() {
        return this.currentLordLevel * (Integer)VampirismConfig.BALANCE.miMinionPerLordLevel.get();
    }

    @Override
    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public int getTheEntityID() {
        return this.player.m_19879_();
    }

    @Override
    public boolean isInFaction(@Nullable IFaction<?> f) {
        return Objects.equals(this.currentFaction, f);
    }

    @Override
    public void joinFaction(@NotNull IPlayableFaction<?> faction) {
        if (this.canJoin(faction)) {
            this.setFactionAndLevel(faction, 1);
        }
    }

    @Override
    public void loadUpdateFromNBT(@NotNull CompoundTag nbt) {
        IPlayableFaction<?> old = this.currentFaction;
        int oldLevel = this.currentLevel;
        String f = nbt.m_128461_("faction");
        if ("null".equals(f)) {
            this.currentFaction = null;
            this.currentLevel = 0;
            this.currentLordLevel = 0;
        } else {
            this.currentFaction = this.getFactionFromKey(new ResourceLocation(f));
            if (this.currentFaction == null) {
                LOGGER.error("Cannot find faction {} on client. You have to register factions on both sides!", (Object)f);
                this.currentLevel = 0;
            } else {
                this.currentLevel = nbt.m_128451_("level");
                this.currentLordLevel = nbt.m_128451_("lord_level");
            }
        }
        if (old != this.currentFaction || oldLevel != this.currentLevel) {
            VampirismEventFactory.fireFactionLevelChangedEvent(this, old, oldLevel, this.currentFaction, this.currentLevel);
        }
        if (nbt.m_128441_("title_gender")) {
            this.titleGender = nbt.m_128471_("title_gender");
        }
        this.loadBoundActions(nbt);
        this.updateCache();
        this.notifyFaction(old, oldLevel);
    }

    @Override
    public boolean onEntityAttacked(DamageSource src, float amt) {
        if (((Boolean)VampirismConfig.SERVER.pvpOnlyBetweenFactions.get()).booleanValue() && src.m_7639_() instanceof Player) {
            IPlayableFaction otherFaction = FactionPlayerHandler.getOpt((Player)src.m_7639_()).resolve().map(FactionPlayerHandler::getCurrentFaction).orElse(null);
            if (this.currentFaction == null || otherFaction == null) {
                return (Boolean)VampirismConfig.SERVER.pvpOnlyBetweenFactionsIncludeHumans.get();
            }
            return !this.currentFaction.equals(otherFaction);
        }
        return true;
    }

    public void onPlayerLoggedIn() {
        if (this.titleGender == null) {
            this.titleGender = Helper.attemptToGuessGenderSafe(this.player);
        }
    }

    public void resetLordTasks(int minLevel) {
        this.getCurrentFactionPlayer().map(IFactionPlayer::getTaskManager).ifPresent(manager -> this.player.m_9236_().m_9598_().m_175515_(VampirismRegistries.TASK_ID).m_206058_(ModTags.Tasks.AWARDS_LORD_LEVEL).forEach(holder -> holder.m_203543_().ifPresent(manager::resetUniqueTask)));
    }

    public void setBoundAction(int id, @Nullable IAction<?> boundAction, boolean sync, boolean notify) {
        if (boundAction == null) {
            this.boundActions.remove(id);
        } else {
            this.boundActions.put(id, boundAction);
        }
        if (notify) {
            this.player.m_5661_((Component)Component.m_237110_((String)"text.vampirism.actions.bind_action", (Object[])new Object[]{boundAction != null ? boundAction.getName() : "none", id}), true);
        }
        if (sync) {
            this.sync(false);
        }
    }

    @Override
    public boolean setFactionAndLevel(@Nullable IPlayableFaction<?> faction, int level) {
        IPlayableFaction<?> old = this.currentFaction;
        int oldLevel = this.currentLevel;
        int newLordLevel = this.currentLordLevel;
        if (!(this.currentFaction == null || this.currentFaction.equals(faction) && level != 0 || this.currentFaction.getPlayerCapability(this.player).map(IFactionPlayer::canLeaveFaction).orElse(false).booleanValue())) {
            LOGGER.info("You cannot leave faction {}, it is prevented by respective mod", (Object)this.currentFaction.getID());
            return false;
        }
        if (faction != null && (level < 0 || level > faction.getHighestReachableLevel())) {
            LOGGER.warn("Level {} in faction {} cannot be reached", (Object)level, (Object)faction.getID());
            return false;
        }
        if (VampirismEventFactory.fireChangeLevelOrFactionEvent(this, old, oldLevel, faction, faction == null ? 0 : level)) {
            LOGGER.debug("Faction or Level change event canceled");
            return false;
        }
        if (this.currentFaction != null && faction != this.currentFaction) {
            this.currentFaction.getPlayerCapability(this.player).ifPresent(factionPlayer -> factionPlayer.getTaskManager().reset());
        }
        if (faction == null) {
            this.currentFaction = null;
            this.currentLevel = 0;
            newLordLevel = 0;
        } else {
            this.currentFaction = faction;
            this.currentLevel = level;
            if (this.currentLevel != this.currentFaction.getHighestReachableLevel() || this.currentFaction != old) {
                newLordLevel = 0;
            }
        }
        if (this.currentLevel == 0) {
            this.currentFaction = null;
            newLordLevel = 0;
        }
        if (this.currentLordLevel != newLordLevel) {
            this.setLordLevel(newLordLevel, false);
        }
        this.updateSkillTypes();
        this.updateCache();
        this.notifyFaction(old, oldLevel);
        if (this.player instanceof ServerPlayer && (this.currentFaction != old || oldLevel != this.currentLevel)) {
            if (old == this.currentFaction) {
                VampirismLogger.info(VampirismLogger.LEVEL, "{} has new faction level {} {}, was {}", this.player.m_7755_().getString(), this.currentFaction.getID(), this.currentLevel, oldLevel);
            } else if (this.currentFaction != null) {
                VampirismLogger.info(VampirismLogger.LEVEL, "{} is now in faction {} {}", this.player.m_7755_().getString(), this.currentFaction.getID(), this.currentLevel);
            } else {
                VampirismLogger.info(VampirismLogger.LEVEL, "{} has now no level", this.player.m_7755_().getString());
            }
        }
        if (old != this.currentFaction || oldLevel != this.currentLevel) {
            VampirismEventFactory.fireFactionLevelChangedEvent(this, old, oldLevel, this.currentFaction, this.currentLevel);
        }
        this.sync(!Objects.equals(old, this.currentFaction));
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (old != faction) {
                ModAdvancements.TRIGGER_FACTION.revokeAll(serverPlayer);
                ModAdvancements.revoke(ModAdvancements.TRIGGER_MOTHER_WIN, serverPlayer);
            } else if (oldLevel > level) {
                ModAdvancements.TRIGGER_FACTION.revokeLevel(serverPlayer, faction, FactionCriterionTrigger.Type.LEVEL, level);
            }
            ModAdvancements.TRIGGER_FACTION.trigger(serverPlayer, this.currentFaction, this.currentLevel, this.currentLordLevel);
        }
        return true;
    }

    @Override
    public boolean setFactionLevel(@NotNull IPlayableFaction<?> faction, int level) {
        return faction.equals(this.currentFaction) && this.setFactionAndLevel(faction, level);
    }

    @Override
    public boolean setLordLevel(int level) {
        return this.setLordLevel(level, true);
    }

    public boolean setTitleGender(boolean female) {
        if (this.titleGender == null || female != this.titleGender) {
            this.titleGender = female;
            this.player.refreshDisplayName();
            if (!this.player.m_9236_().m_5776_()) {
                this.sync(true);
            }
        }
        this.titleGender = female;
        return true;
    }

    @Override
    public void writeFullUpdateToNBT(@NotNull CompoundTag nbt) {
        nbt.m_128359_("faction", this.currentFaction == null ? "null" : this.currentFaction.getID().toString());
        nbt.m_128405_("level", this.currentLevel);
        nbt.m_128405_("lord_level", this.currentLordLevel);
        nbt.m_128379_("title_gender", this.titleGender != null && this.titleGender != false);
        this.writeBoundActions(nbt);
    }

    @Override
    public void leaveFaction(boolean die) {
        IPlayableFaction<?> oldFaction = this.currentFaction;
        if (oldFaction == null) {
            return;
        }
        this.setFactionAndLevel(null, 0);
        this.player.m_5661_((Component)Component.m_237110_((String)"command.vampirism.base.level.successful", (Object[])new Object[]{this.player.m_7755_(), oldFaction.getName(), 0}), true);
        if (die) {
            DamageHandler.kill((Entity)this.player, 10000);
        }
    }

    @Nullable
    private IPlayableFaction<?> getFactionFromKey(ResourceLocation key) {
        for (IPlayableFaction<?> p : VampirismAPI.factionRegistry().getPlayableFactions()) {
            if (!p.getID().equals((Object)key)) continue;
            return p;
        }
        return null;
    }

    private void loadBoundActions(@NotNull CompoundTag nbt) {
        CompoundTag bounds = nbt.m_128469_("bound_actions");
        for (String s : bounds.m_128431_()) {
            int id = Integer.parseInt(s);
            IAction<?> action = RegUtil.getAction(new ResourceLocation(bounds.m_128461_(s)));
            if (action == null) {
                LOGGER.warn("Cannot find bound action {}", (Object)bounds.m_128461_(s));
                continue;
            }
            this.boundActions.put(id, action);
        }
    }

    private void loadNBTData(@NotNull CompoundTag nbt) {
        if (nbt.m_128441_("faction")) {
            this.currentFaction = this.getFactionFromKey(new ResourceLocation(nbt.m_128461_("faction")));
            if (this.currentFaction == null) {
                LOGGER.warn("Could not find faction {}. Did mods change?", (Object)nbt.m_128461_("faction"));
            } else {
                this.currentLevel = Math.min(nbt.m_128451_("level"), this.currentFaction.getHighestReachableLevel());
                this.currentLordLevel = Math.min(nbt.m_128451_("lord_level"), this.currentFaction.getHighestLordLevel());
                this.updateSkillTypes();
                this.updateCache();
                this.notifyFaction(null, 0);
            }
        }
        if (nbt.m_128441_("title_gender")) {
            this.titleGender = nbt.m_128471_("title_gender");
        }
        this.loadBoundActions(nbt);
        this.updateCache();
    }

    private void updateSkillTypes() {
        this.getCurrentFactionPlayer().ifPresent(a -> a.getSkillHandler().enableRootSkills());
    }

    private void notifyFaction(@Nullable IPlayableFaction<?> oldFaction, int oldLevel) {
        if (oldFaction != null && !oldFaction.equals(this.currentFaction)) {
            LOGGER.debug(LogUtil.FACTION, "{} is leaving faction {}", (Object)this.player.m_7755_().getString(), (Object)oldFaction.getID());
            VampirismLogger.info(VampirismLogger.LEVEL, "{} is leaving faction {}", this.player.m_7755_().getString(), oldFaction.getID());
            oldFaction.getPlayerCapability(this.player).ifPresent(c -> c.onLevelChanged(0, oldLevel));
        }
        if (this.currentFaction != null) {
            LOGGER.debug(LogUtil.FACTION, "{} has new faction level {} {}", (Object)this.player.m_7755_().getString(), (Object)this.currentFaction.getID(), (Object)this.currentLevel);
            this.currentFaction.getPlayerCapability(this.player).ifPresent(c -> c.onLevelChanged(this.currentLevel, Objects.equals(oldFaction, this.currentFaction) ? oldLevel : 0));
        }
        ScoreboardUtil.updateScoreboard(this.player, ScoreboardUtil.FACTION_CRITERIA, this.currentFaction == null ? 0 : this.currentFaction.getID().hashCode());
    }

    private void saveNBTData(@NotNull CompoundTag nbt) {
        if (this.currentFaction != null) {
            nbt.m_128359_("faction", this.currentFaction.getID().toString());
            nbt.m_128405_("level", this.currentLevel);
            nbt.m_128405_("lord_level", this.currentLordLevel);
        }
        if (this.titleGender != null) {
            nbt.m_128379_("title_gender", this.titleGender.booleanValue());
        }
        this.writeBoundActions(nbt);
    }

    private boolean setLordLevel(int level, boolean sync) {
        int oldLevel = this.currentLordLevel;
        if (level > 0 && (this.currentFaction == null || this.currentLevel != this.currentFaction.getHighestReachableLevel() || level > this.currentFaction.getHighestLordLevel())) {
            return false;
        }
        if (level < this.currentLordLevel) {
            this.resetLordTasks(level);
        }
        this.currentLordLevel = level;
        this.getCurrentFactionPlayer().ifPresent(player -> player.getSkillHandler().addSkillPoints((int)((double)(level - oldLevel) * (Double)VampirismConfig.BALANCE.skillPointsPerLordLevel.get())));
        if (this.currentLordLevel > 0) {
            this.updateSkillTypes();
        }
        this.updateCache();
        MinionWorldData.getData(this.player.m_9236_()).ifPresent(data -> {
            PlayerMinionController c = data.getController(this.player.m_20148_());
            if (c != null) {
                c.setMaxMinions(this.currentFaction, this.getMaxMinions());
            }
        });
        if (level == 0) {
            LOGGER.debug(LogUtil.FACTION, "Resetting lord level for {}", (Object)this.player.m_7755_().getString());
            VampirismLogger.info(VampirismLogger.LORD_LEVEL, "Resetting lord level for {}", this.player.m_7755_().getString());
        } else {
            LOGGER.debug(LogUtil.FACTION, "{} has now lord level {}", (Object)this.player.m_7755_().getString(), (Object)level);
            VampirismLogger.info(VampirismLogger.LORD_LEVEL, "{} has now lord level {}", this.player.m_7755_().getString(), level);
        }
        Player player2 = this.player;
        if (player2 instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player2;
            if (this.currentLordLevel < oldLevel) {
                ModAdvancements.TRIGGER_FACTION.revokeLevel(serverPlayer, this.currentFaction, FactionCriterionTrigger.Type.LORD, this.currentLordLevel);
            }
            ModAdvancements.TRIGGER_FACTION.trigger(serverPlayer, this.currentFaction, this.currentLevel, this.currentLordLevel);
        }
        if (sync) {
            this.sync(false);
        }
        return true;
    }

    private void sync(boolean all) {
        HelperLib.sync(this, (Entity)this.player, all);
    }

    private void updateCache() {
        this.player.refreshDisplayName();
        VampirismPlayerAttributes atts = ((IVampirismPlayer)this.player).getVampAtts();
        atts.hunterLevel = this.currentFaction == VReference.HUNTER_FACTION ? this.currentLevel : 0;
        atts.vampireLevel = this.currentFaction == VReference.VAMPIRE_FACTION ? this.currentLevel : 0;
        atts.lordLevel = this.currentLordLevel;
        atts.faction = this.currentFaction;
    }

    private void writeBoundActions(@NotNull CompoundTag nbt) {
        CompoundTag bounds = new CompoundTag();
        for (Int2ObjectMap.Entry entry : this.boundActions.int2ObjectEntrySet()) {
            bounds.m_128359_(String.valueOf(entry.getIntKey()), RegUtil.id((IAction)entry.getValue()).toString());
        }
        nbt.m_128365_("bound_actions", (Tag)bounds);
    }
}

