/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire.action;

import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.vampire.action.VampireEntityAction;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class IgnoreSunDamageEntityAction<T extends PathfinderMob>
extends VampireEntityAction<T>
implements ILastingAction<T> {
    public IgnoreSunDamageEntityAction(@NotNull EntityActionTier tier, EntityClassType ... param) {
        super(tier, param);
    }

    @Override
    public void activate(@NotNull T entity) {
        entity.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SUNSCREEN.get(), this.getDuration(((IAdjustableLevel)entity).getEntityLevel()), 0));
    }

    @Override
    public void deactivate(@NotNull T entity) {
        if (entity.m_21124_((MobEffect)ModEffects.SUNSCREEN.get()) != null && entity.m_21124_((MobEffect)ModEffects.SUNSCREEN.get()).m_19564_() == 0) {
            entity.m_21195_((MobEffect)ModEffects.SUNSCREEN.get());
        }
    }

    @Override
    public int getCooldown(int level) {
        return (Integer)VampirismConfig.BALANCE.eaIgnoreSundamageCooldown.get() * 20;
    }

    @Override
    public int getDuration(int level) {
        return (Integer)VampirismConfig.BALANCE.eaIgnoreSundamageDuration.get() * 20;
    }

    @Override
    public int getWeight(@NotNull PathfinderMob entity) {
        if (!entity.m_20193_().m_46461_() || entity.m_20193_().m_46471_()) {
            return 0;
        }
        return ((IVampire)entity).isGettingSundamage((LevelAccessor)entity.m_9236_()) ? 3 : 1;
    }

    @Override
    public void onUpdate(T entity, int duration) {
    }
}

