/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.blocks.HunterTableBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.player.hunter.HunterLeveling;
import de.teamlapen.vampirism.items.PureBloodItem;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.IContainerFactory;
import org.jetbrains.annotations.NotNull;

public class HunterTableMenu
extends ItemCombinerMenu {
    private final Optional<HunterLeveling.HunterTableRequirement> tableRequirement;

    public HunterTableMenu(int id, @NotNull Inventory playerInventory, ContainerLevelAccess worldPosCallable) {
        super((MenuType)ModContainer.HUNTER_TABLE.get(), id, playerInventory, worldPosCallable);
        int hunterLevel = FactionPlayerHandler.get(playerInventory.f_35978_).getCurrentLevel(VReference.HUNTER_FACTION);
        this.tableRequirement = HunterLeveling.getTrainerRequirement(hunterLevel + 1).map(HunterLeveling.HunterTrainerRequirement::tableRequirement);
    }

    public Optional<HunterLeveling.HunterTableRequirement> getTableRequirement() {
        return this.tableRequirement.filter(this::doesTableFulfillRequirement);
    }

    public Optional<HunterLeveling.HunterTableRequirement> getRequirement() {
        return this.tableRequirement;
    }

    @NotNull
    protected ItemCombinerMenuSlotDefinition m_266183_() {
        return ItemCombinerMenuSlotDefinition.m_266303_().m_266197_(0, 15, 28, stack -> stack.m_150930_(Items.f_42517_)).m_266197_(1, 42, 28, stack -> stack.m_150930_((Item)ModItems.VAMPIRE_FANG.get())).m_266197_(2, 69, 28, stack -> this.tableRequirement.filter(req -> {
            int n;
            int n2 = req.pureBloodLevel();
            Item patt2615$temp = stack.m_41720_();
            if (patt2615$temp instanceof PureBloodItem) {
                PureBloodItem pure = (PureBloodItem)patt2615$temp;
                n = pure.getLevel();
            } else {
                n = -1;
            }
            return n2 <= n;
        }).isPresent()).m_266197_(3, 96, 28, stack -> stack.m_150930_((Item)ModItems.VAMPIRE_BOOK.get())).m_266198_(4, 146, 28).m_266441_();
    }

    protected boolean m_6560_(@NotNull Player pPlayer, boolean pHasStack) {
        return true;
    }

    protected void m_142365_(@NotNull Player player, @NotNull ItemStack stack) {
        this.tableRequirement.ifPresent(req -> InventoryHelper.removeItems(this.f_39769_, req.bookQuantity(), req.vampireFangQuantity(), req.pureBloodQuantity(), req.vampireBookQuantity()));
    }

    protected boolean m_8039_(@NotNull BlockState pState) {
        return pState.m_60713_((Block)ModBlocks.HUNTER_TABLE.get());
    }

    public void m_6640_() {
        this.tableRequirement.filter(this::isRequirementFulfilled).map(s -> s.resultIntelItem().get()).ifPresentOrElse(intel -> this.f_39768_.m_6836_(0, intel.m_7968_()), () -> this.f_39768_.m_6836_(0, ItemStack.f_41583_));
    }

    private boolean isRequirementFulfilled(HunterLeveling.HunterTableRequirement req) {
        return this.f_39769_.m_18947_(Items.f_42517_) >= 1 && this.f_39769_.m_18947_((Item)ModItems.VAMPIRE_FANG.get()) >= req.vampireFangQuantity() && this.countPureBlood(req) >= req.pureBloodQuantity() && this.f_39769_.m_18947_((Item)ModItems.VAMPIRE_BOOK.get()) >= req.vampireBookQuantity();
    }

    private int countPureBlood(HunterLeveling.HunterTableRequirement req) {
        return IntStream.range(req.pureBloodLevel(), 5).mapToObj(PureBloodItem::getBloodItemForLevel).mapToInt(arg_0 -> ((Container)this.f_39769_).m_18947_(arg_0)).sum();
    }

    public boolean doesTableFulfillRequirement(HunterLeveling.HunterTableRequirement req) {
        return req.requiredTableTier() <= (Integer)this.f_39770_.m_39299_((level, pos) -> {
            BlockState state = level.m_8055_(pos);
            return state.m_61138_(HunterTableBlock.VARIANT) ? ((HunterTableBlock.TABLE_VARIANT)((Object)((Object)state.m_61143_(HunterTableBlock.VARIANT)))).tier : 0;
        }, (Object)0);
    }

    public static class Factory
    implements IContainerFactory<HunterTableMenu> {
        @NotNull
        public HunterTableMenu create(int windowId, @NotNull Inventory inv, @NotNull FriendlyByteBuf data) {
            BlockPos pos = data.m_130135_();
            return new HunterTableMenu(windowId, inv, ContainerLevelAccess.m_39289_((Level)inv.f_35978_.m_9236_(), (BlockPos)pos));
        }
    }
}

