/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items.crossbow;

import de.teamlapen.vampirism.api.items.IArrowContainer;
import de.teamlapen.vampirism.api.items.IVampirismCrossbowArrow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrowContainer
extends Item
implements IArrowContainer {
    private final int maxCount;
    private final Predicate<ItemStack> arrowPredicate;

    public ArrowContainer(Item.Properties properties, int maxCount, Predicate<ItemStack> arrowPredicate) {
        super(properties);
        this.maxCount = maxCount;
        this.arrowPredicate = arrowPredicate;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> texts, @NotNull TooltipFlag flag) {
        this.getArrows(stack).stream().map(ItemStack::m_41720_).collect(Collectors.groupingBy(a -> a)).forEach((item, items) -> texts.add((Component)item.m_7626_(item.m_7968_()).m_6881_().m_130946_(" " + items.size())));
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        return ((MutableComponent)super.m_7626_(stack)).m_130946_(" (" + this.getArrows(stack).size() + "/" + this.maxCount + ")");
    }

    @Override
    public Collection<ItemStack> getArrows(ItemStack container) {
        ListTag arrows = container.m_41784_().m_128437_("arrows", 10);
        return arrows.stream().map(t -> ItemStack.m_41712_((CompoundTag)((CompoundTag)t))).collect(Collectors.toList());
    }

    @Override
    public boolean addArrow(ItemStack container, ItemStack arrow) {
        CompoundTag tag = container.m_41784_();
        ListTag arrows = tag.m_128437_("arrows", 10);
        if (arrows.size() >= this.maxCount) {
            return false;
        }
        arrows.add((Object)arrow.m_41739_(new CompoundTag()));
        tag.m_128365_("arrows", (Tag)arrows);
        return true;
    }

    @Override
    public void addArrows(ItemStack container, Collection<ItemStack> arrowStacks) {
        CompoundTag tag = container.m_41784_();
        ListTag arrows = tag.m_128437_("arrows", 10);
        for (ItemStack arrowStack : arrowStacks) {
            if (arrows.size() >= this.maxCount) break;
            arrows.add((Object)arrowStack.m_41739_(new CompoundTag()));
        }
        tag.m_128365_("arrows", (Tag)arrows);
    }

    @Override
    public Collection<ItemStack> getAndRemoveArrows(ItemStack container) {
        Collection<ItemStack> arrows = this.getArrows(container);
        container.m_41783_().m_128473_("arrows");
        return arrows;
    }

    @Override
    public void removeArrows(ItemStack container) {
        container.m_41784_().m_128473_("arrows");
    }

    @Override
    public boolean removeArrow(ItemStack container, ItemStack arrow) {
        CompoundTag tag = container.m_41784_();
        ListTag arrows = tag.m_128437_("arrows", 10);
        for (int i = 0; i < arrows.size(); ++i) {
            if (!ItemStack.m_41712_((CompoundTag)((CompoundTag)arrows.get(i))).equals(arrow)) continue;
            arrows.remove(i);
            tag.m_128365_("arrows", (Tag)arrows);
            return true;
        }
        return false;
    }

    @Override
    public boolean isDiscardedOnUse(ItemStack container) {
        return false;
    }

    @Override
    public int getMaxArrows(ItemStack container) {
        return this.maxCount;
    }

    @Override
    public boolean canBeRefilled(ItemStack container) {
        return true;
    }

    @Override
    public boolean canContainArrow(ItemStack container, ItemStack arrow) {
        return this.arrowPredicate.test(arrow);
    }

    public boolean m_142305_(@NotNull ItemStack container, @NotNull ItemStack otherStack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        if (action == ClickAction.SECONDARY && slot.m_150651_(player)) {
            int i;
            if (!otherStack.m_41619_() && (i = this.addArrows(container, otherStack)) > 0) {
                this.playInsertSound((Entity)player);
                otherStack.m_41774_(i);
            }
            return true;
        }
        return false;
    }

    private int addArrows(ItemStack container, ItemStack otherStack) {
        int i = 0;
        if (otherStack.m_41720_() instanceof IVampirismCrossbowArrow && this.canContainArrow(container, otherStack)) {
            i = otherStack.m_41613_();
            if (i > this.getMaxArrows(container) - this.getArrows(container).size()) {
                i = this.getMaxArrows(container) - this.getArrows(container).size();
            }
            ArrayList<ItemStack> arrows = new ArrayList<ItemStack>();
            ItemStack copy = otherStack.m_41777_();
            copy.m_41764_(i);
            for (int j = 0; j < i; ++j) {
                arrows.add(copy.m_41777_());
            }
            if (i > 0) {
                this.addArrows(container, arrows);
            }
        }
        return i;
    }

    private void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }
}

