/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.misc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import de.teamlapen.lib.lib.util.ResourceLocationTypeAdapter;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.settings.ISettingsProvider;
import de.teamlapen.vampirism.api.settings.Supporter;
import de.teamlapen.vampirism.misc.SupporterDeserializer;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsProvider
implements ISettingsProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(ResourceLocation.class, (Object)new ResourceLocationTypeAdapter()).registerTypeHierarchyAdapter(Supporter.class, (Object)new SupporterDeserializer()).create();
    private final HttpClient client;
    private final String baseUrl;
    private final Map<String, String> settingValues = new HashMap<String, String>();

    public SettingsProvider(String baseUrl) {
        this.baseUrl = baseUrl;
        this.client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).executor(Util.m_183992_()).build();
    }

    @Override
    public void syncSettingsCache() {
        ((CompletableFuture)this.retrieveSettingValuesAsync().handleAsync(this::checkSettings)).thenAccept(newValues -> {
            this.settingValues.clear();
            newValues.ifPresent(this.settingValues::putAll);
        });
    }

    @Override
    @NotNull
    public Optional<String> getSettingsValue(@NotNull String key) {
        return Optional.ofNullable(this.settingValues.get(key));
    }

    @Override
    public boolean isSettingTrue(@NotNull String key) {
        return "true".equals(this.settingValues.get(key));
    }

    @Override
    @NotNull
    public CompletableFuture<Optional<Collection<Supporter>>> getSupportersAsync() {
        return this.retrieveSupportersAsync().handleAsync(this::checkSupporter);
    }

    @Nullable
    public CompletableFuture<String> getSettingValueAsync(String key) {
        return this.get("config/get?configId=" + key);
    }

    public CompletableFuture<Map<String, String>> retrieveSettingValuesAsync() {
        return this.get("config/list").thenApply(x -> (Map)GSON.fromJson(x, TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, String.class}).getType()));
    }

    public CompletableFuture<Map<String, String>> retrieveSettingValuesAsync(String modid) {
        return this.get("config/list?modid=" + modid).thenApply(x -> (Map)GSON.fromJson(x, TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, String.class}).getType()));
    }

    public CompletableFuture<Collection<Supporter>> retrieveSupportersAsync() {
        return this.get("supporter/list").thenApply(x -> (Collection)GSON.fromJson(x, TypeToken.getParameterized(List.class, (Type[])new Type[]{Supporter.class}).getType()));
    }

    public CompletableFuture<Collection<Supporter>> retrieveSupportersAsync(String modid) {
        return this.retrieveSupportersAsync().thenApply(x -> x.stream().filter(y -> y.faction().m_135827_().equals(modid)).collect(Collectors.toList()));
    }

    private CompletableFuture<String> get(String path) {
        try {
            HttpRequest request = HttpRequest.newBuilder(new URI(this.baseUrl + "/" + path)).GET().build();
            return this.client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body);
        }
        catch (URISyntaxException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private Optional<Map<String, String>> checkSettings(Map<String, String> settings, Throwable error) {
        InputStream inputStream;
        if (error != null) {
            LOGGER.error("Failed to retrieve settings from server", error);
        }
        if ((VampirismMod.inDev || settings == null) && (inputStream = VampirismMod.class.getResourceAsStream("/default_remote_config.json")) != null) {
            try {
                return Optional.of((Map)GSON.fromJson(new JsonReader((Reader)new InputStreamReader(inputStream)), TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, String.class}).getType()));
            }
            catch (JsonSyntaxException ex) {
                LOGGER.error("Failed to retrieve settings from file", (Throwable)ex);
            }
        }
        return Optional.ofNullable(settings);
    }

    private Optional<Collection<Supporter>> checkSupporter(Collection<Supporter> file, Throwable error) {
        InputStream inputStream;
        if (error != null) {
            LOGGER.error("Failed to retrieve supporter from server", error);
        }
        if ((VampirismMod.inDev || file == null) && (inputStream = VampirismMod.class.getResourceAsStream("/supporters.json")) != null) {
            try {
                List list = (List)GSON.fromJson(new JsonReader((Reader)new InputStreamReader(inputStream)), TypeToken.getParameterized(List.class, (Type[])new Type[]{Supporter.class}).getType());
                return Optional.of(list);
            }
            catch (JsonSyntaxException ex) {
                LOGGER.error("Failed to retrieve supporter from file", (Throwable)ex);
            }
        }
        return Optional.ofNullable(file);
    }
}

