/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.api.items.oil.IApplicableOil;
import de.teamlapen.vampirism.client.gui.screens.AlchemicalCauldronScreen;
import de.teamlapen.vampirism.client.gui.screens.AlchemyTableScreen;
import de.teamlapen.vampirism.client.gui.screens.PotionTableScreen;
import de.teamlapen.vampirism.client.gui.screens.WeaponTableScreen;
import de.teamlapen.vampirism.core.ModContainer;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.core.ModRegistries;
import de.teamlapen.vampirism.entity.player.tasks.TaskUtil;
import de.teamlapen.vampirism.inventory.AlchemicalCauldronMenu;
import de.teamlapen.vampirism.inventory.WeaponTableMenu;
import de.teamlapen.vampirism.items.BlessableItem;
import de.teamlapen.vampirism.items.VampirismSwordItem;
import de.teamlapen.vampirism.items.crossbow.TechCrossbowItem;
import de.teamlapen.vampirism.items.crossbow.VampirismCrossbowItem;
import de.teamlapen.vampirism.mixin.RecipeManagerAccessor;
import de.teamlapen.vampirism.modcompat.jei.AlchemicalCauldronRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.AlchemyTableRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.BlessingRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.JEIPotionMix;
import de.teamlapen.vampirism.modcompat.jei.PotionTableRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.TaskRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.WeaponTableRecipeCategory;
import de.teamlapen.vampirism.recipes.AlchemicalCauldronRecipe;
import de.teamlapen.vampirism.recipes.AlchemyTableRecipe;
import de.teamlapen.vampirism.util.OilUtils;
import de.teamlapen.vampirism.util.RegUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class VampirismJEIPlugin
implements IModPlugin {
    public static final RecipeType<IWeaponTableRecipe> WEAPON_TABLE = RecipeType.create((String)"vampirism", (String)"hunter_weapon", IWeaponTableRecipe.class);
    public static final RecipeType<AlchemicalCauldronRecipe> ALCHEMICAL_CAULDRON = RecipeType.create((String)"vampirism", (String)"alchemical_cauldron", AlchemicalCauldronRecipe.class);
    public static final RecipeType<Task> TASK = RecipeType.create((String)"vampirism", (String)"task", Task.class);
    public static final RecipeType<BlessableItem.Recipe> BLESSING = RecipeType.create((String)"vampirism", (String)"blessing", BlessableItem.Recipe.class);
    public static final RecipeType<JEIPotionMix> POTION = RecipeType.create((String)"vampirism", (String)"potion", JEIPotionMix.class);
    public static final RecipeType<AlchemyTableRecipe> ALCHEMY_TABLE = RecipeType.create((String)"vampirism", (String)"alchemy_table", AlchemyTableRecipe.class);
    private static final ResourceLocation ID = new ResourceLocation("vampirism", "plugin");

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(@NotNull IRecipeCategoryRegistration registration) {
        IGuiHelper helper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new AlchemicalCauldronRecipeCategory(helper), new WeaponTableRecipeCategory(helper), new TaskRecipeCategory(helper), new PotionTableRecipeCategory(helper), new AlchemyTableRecipeCategory(helper), new BlessingRecipeCategory(helper)});
    }

    public void registerGuiHandlers(@NotNull IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(AlchemicalCauldronScreen.class, 80, 34, 20, 15, new RecipeType[]{ALCHEMICAL_CAULDRON});
        registration.addRecipeClickArea(WeaponTableScreen.class, 114, 46, 20, 15, new RecipeType[]{WEAPON_TABLE});
        registration.addRecipeClickArea(PotionTableScreen.class, 145, 17, 9, 28, new RecipeType[]{POTION});
        registration.addRecipeClickArea(AlchemyTableScreen.class, 73, 57, 28, 8, new RecipeType[]{ALCHEMY_TABLE});
        registration.addRecipeClickArea(AlchemyTableScreen.class, 104, 36, 32, 32, new RecipeType[]{ALCHEMY_TABLE});
    }

    public void registerRecipeTransferHandlers(@NotNull IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(AlchemicalCauldronMenu.class, (MenuType)ModContainer.ALCHEMICAL_CAULDRON.get(), ALCHEMICAL_CAULDRON, 0, 2, 4, 36);
        registration.addRecipeTransferHandler(AlchemicalCauldronMenu.class, (MenuType)ModContainer.ALCHEMICAL_CAULDRON.get(), RecipeTypes.FUELING, 3, 1, 4, 36);
        registration.addRecipeTransferHandler(WeaponTableMenu.class, (MenuType)ModContainer.WEAPON_TABLE.get(), WEAPON_TABLE, 1, 16, 17, 36);
    }

    public void registerItemSubtypes(@NotNull ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.OIL_BOTTLE.get(), (IIngredientSubtypeInterpreter)OilNBT.INSTANCE);
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        RecipeManager recipeManager = world.m_7465_();
        registration.addRecipes(ALCHEMICAL_CAULDRON, ((RecipeManagerAccessor)recipeManager).getByType((net.minecraft.world.item.crafting.RecipeType)ModRecipes.ALCHEMICAL_CAULDRON_TYPE.get()).values().stream().toList());
        registration.addRecipes(WEAPON_TABLE, ((RecipeManagerAccessor)recipeManager).getByType((net.minecraft.world.item.crafting.RecipeType)ModRecipes.WEAPONTABLE_CRAFTING_TYPE.get()).values().stream().toList());
        registration.addRecipes(TASK, TaskUtil.getItemRewardTasks(world.m_9598_()));
        registration.addRecipes(POTION, VampirismAPI.extendedBrewingRecipeRegistry().getPotionMixes().stream().map(JEIPotionMix::createFromMix).flatMap(Collection::stream).collect(Collectors.toList()));
        registration.addRecipes(RecipeTypes.ANVIL, this.getRepairRecipes(registration.getVanillaRecipeFactory()));
        registration.addRecipes(ALCHEMY_TABLE, recipeManager.m_44054_((net.minecraft.world.item.crafting.RecipeType)ModRecipes.ALCHEMICAL_TABLE_TYPE.get()).values().stream().toList());
        registration.addRecipes(RecipeTypes.CRAFTING, this.getApplicableOilRecipes());
        registration.addRecipes(BLESSING, BlessableItem.getBlessableRecipes());
        registration.addRecipes(RecipeTypes.CRAFTING, this.getCleanOilRecipes(world.m_9598_()));
    }

    public void registerVanillaCategoryExtensions(@NotNull IVanillaCategoryExtensionRegistration registration) {
    }

    @NotNull
    private <T extends Item> List<IJeiAnvilRecipe> getRepairRecipes(@NotNull IVanillaRecipeFactory factory) {
        ArrayList<IJeiAnvilRecipe> recipes = new ArrayList<IJeiAnvilRecipe>();
        this.addRepairItem(factory, recipes::add, axe -> axe.m_43314_().m_6282_(), (Item[])new VampirismSwordItem[]{(VampirismSwordItem)((Object)ModItems.HUNTER_AXE_NORMAL.get()), (VampirismSwordItem)((Object)ModItems.HUNTER_AXE_ENHANCED.get()), (VampirismSwordItem)((Object)ModItems.HUNTER_AXE_ULTIMATE.get()), (VampirismSwordItem)((Object)ModItems.HEART_SEEKER_ENHANCED.get()), (VampirismSwordItem)((Object)ModItems.HEART_SEEKER_ULTIMATE.get()), (VampirismSwordItem)((Object)ModItems.HEART_STRIKER_ENHANCED.get()), (VampirismSwordItem)((Object)ModItems.HEART_STRIKER_ULTIMATE.get()), (VampirismSwordItem)((Object)ModItems.HEART_SEEKER_NORMAL.get()), (VampirismSwordItem)((Object)ModItems.HEART_STRIKER_NORMAL.get())});
        this.addRepairItem(factory, recipes::add, armor -> armor.m_40401_().m_6230_(), (Item[])new ArmorItem[]{(ArmorItem)ModItems.HUNTER_COAT_CHEST_NORMAL.get(), (ArmorItem)ModItems.HUNTER_COAT_CHEST_ENHANCED.get(), (ArmorItem)ModItems.HUNTER_COAT_CHEST_ULTIMATE.get(), (ArmorItem)ModItems.HUNTER_COAT_HEAD_NORMAL.get(), (ArmorItem)ModItems.HUNTER_COAT_HEAD_ENHANCED.get(), (ArmorItem)ModItems.HUNTER_COAT_HEAD_ULTIMATE.get(), (ArmorItem)ModItems.HUNTER_COAT_LEGS_NORMAL.get(), (ArmorItem)ModItems.HUNTER_COAT_LEGS_ENHANCED.get(), (ArmorItem)ModItems.HUNTER_COAT_LEGS_ULTIMATE.get(), (ArmorItem)ModItems.HUNTER_COAT_FEET_NORMAL.get(), (ArmorItem)ModItems.HUNTER_COAT_FEET_ENHANCED.get(), (ArmorItem)ModItems.HUNTER_COAT_FEET_ULTIMATE.get(), (ArmorItem)ModItems.ARMOR_OF_SWIFTNESS_CHEST_NORMAL.get(), (ArmorItem)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ENHANCED.get(), (ArmorItem)ModItems.ARMOR_OF_SWIFTNESS_CHEST_ULTIMATE.get(), (ArmorItem)ModItems.ARMOR_OF_SWIFTNESS_HEAD_NORMAL.get(), (ArmorItem)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ENHANCED.get(), (ArmorItem)ModItems.ARMOR_OF_SWIFTNESS_HEAD_ULTIMATE.get(), (ArmorItem)ModItems.ARMOR_OF_SWIFTNESS_LEGS_NORMAL.get(), (ArmorItem)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ENHANCED.get(), (ArmorItem)ModItems.ARMOR_OF_SWIFTNESS_LEGS_ULTIMATE.get(), (ArmorItem)ModItems.ARMOR_OF_SWIFTNESS_FEET_NORMAL.get(), (ArmorItem)ModItems.ARMOR_OF_SWIFTNESS_FEET_ENHANCED.get(), (ArmorItem)ModItems.ARMOR_OF_SWIFTNESS_FEET_ULTIMATE.get(), (ArmorItem)ModItems.VAMPIRE_CLOTHING_CROWN.get(), (ArmorItem)ModItems.VAMPIRE_CLOTHING_HAT.get(), (ArmorItem)ModItems.VAMPIRE_CLOTHING_LEGS.get(), (ArmorItem)ModItems.VAMPIRE_CLOTHING_BOOTS.get(), (ArmorItem)ModItems.VAMPIRE_CLOAK_RED_BLACK.get(), (ArmorItem)ModItems.VAMPIRE_CLOAK_BLACK_RED.get(), (ArmorItem)ModItems.VAMPIRE_CLOAK_BLACK_WHITE.get(), (ArmorItem)ModItems.VAMPIRE_CLOAK_WHITE_BLACK.get(), (ArmorItem)ModItems.VAMPIRE_CLOAK_BLACK_BLUE.get()});
        this.addRepairItem(factory, recipes::add, crossbow -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42401_}), (Item[])new VampirismCrossbowItem[]{(VampirismCrossbowItem)ModItems.BASIC_CROSSBOW.get(), (VampirismCrossbowItem)ModItems.BASIC_DOUBLE_CROSSBOW.get(), (VampirismCrossbowItem)ModItems.ENHANCED_CROSSBOW.get(), (VampirismCrossbowItem)ModItems.ENHANCED_DOUBLE_CROSSBOW.get()});
        this.addRepairItem(factory, recipes::add, crossbow -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}), (Item[])new TechCrossbowItem[]{(TechCrossbowItem)ModItems.BASIC_TECH_CROSSBOW.get(), (TechCrossbowItem)ModItems.ENHANCED_TECH_CROSSBOW.get()});
        return recipes;
    }

    private <T extends Item> void addRepairItem(@NotNull IVanillaRecipeFactory factory, Consumer<IJeiAnvilRecipe> consumer, Function<T, Ingredient> ingredientFunction, T ... items) {
        for (Object item : items) {
            ItemStack damageThreeQuarters = item.m_7968_();
            damageThreeQuarters.m_41721_(damageThreeQuarters.m_41776_() * 3 / 4);
            ItemStack damageHalf = item.m_7968_();
            damageHalf.m_41721_(damageHalf.m_41776_() / 2);
            IJeiAnvilRecipe repairWithSame = factory.createAnvilRecipe(List.of(damageThreeQuarters), List.of(damageThreeQuarters), List.of(damageHalf));
            consumer.accept(repairWithSame);
            Optional.ofNullable(ingredientFunction.apply(item)).map(s -> s.m_43908_()).filter(s -> ((ItemStack[])s).length > 0).map(s -> List.of(s)).ifPresent(repairMaterials -> {
                ItemStack damagedFully = item.m_7968_();
                damagedFully.m_41721_(damagedFully.m_41776_());
                IJeiAnvilRecipe repairWithMaterial = factory.createAnvilRecipe(List.of(damagedFully), repairMaterials, List.of(damageThreeQuarters));
                consumer.accept(repairWithMaterial);
            });
        }
    }

    @NotNull
    private List<CraftingRecipe> getApplicableOilRecipes() {
        return RegUtil.values(ModRegistries.OILS).stream().filter(IApplicableOil.class::isInstance).map(IApplicableOil.class::cast).flatMap(oil -> ForgeRegistries.ITEMS.getValues().stream().map(Item::m_7968_).filter(item -> !(item.m_41720_() instanceof IFactionExclusiveItem) || ((IFactionExclusiveItem)item.m_41720_()).getExclusiveFaction((ItemStack)item) == VReference.HUNTER_FACTION).filter(oil::canBeApplied).map(stack -> new ShapelessRecipe(new ResourceLocation("vampirism", (RegUtil.id(oil).toString() + RegUtil.id(stack.m_41720_()).toString()).replace(':', '_')), "", CraftingBookCategory.EQUIPMENT, OilUtils.setAppliedOil(stack.m_41777_(), oil), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{OilUtils.createOilItem(oil)})})))).collect(Collectors.toList());
    }

    @NotNull
    private List<CraftingRecipe> getCleanOilRecipes(RegistryAccess registryAccess) {
        return this.getApplicableOilRecipes().stream().map(recipe -> {
            ItemStack item = recipe.m_8043_(registryAccess);
            IApplicableOil oil = OilUtils.getAppliedOil(item).get();
            return new ShapelessRecipe(new ResourceLocation("vampirism", ("clean_" + RegUtil.id(oil).toString() + "_from_" + RegUtil.id(item.m_41720_()).toString()).replace(':', '_')), "", CraftingBookCategory.EQUIPMENT, OilUtils.removeAppliedOil(item.m_41777_()), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42516_}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{item})}));
        }).collect(Collectors.toList());
    }

    private static class OilNBT
    implements IIngredientSubtypeInterpreter<ItemStack> {
        public static final OilNBT INSTANCE = new OilNBT();

        private OilNBT() {
        }

        @NotNull
        public String apply(@NotNull ItemStack itemStack, UidContext context) {
            CompoundTag nbtTagCompound = itemStack.m_41783_();
            if (nbtTagCompound == null || nbtTagCompound.m_128456_()) {
                return "";
            }
            return RegUtil.id(OilUtils.getOil(itemStack)).toString();
        }
    }
}

