/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.util.Color;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IWeaponTableRecipe;
import de.teamlapen.vampirism.blocks.WeaponTableBlock;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.modcompat.jei.RecipeUtil;
import de.teamlapen.vampirism.modcompat.jei.VampirismJEIPlugin;
import de.teamlapen.vampirism.recipes.ShapelessWeaponTableRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.IShapedRecipe;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class WeaponTableRecipeCategory
implements IRecipeCategory<IWeaponTableRecipe> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("vampirism", "textures/gui/weapon_table_clean.png");
    private static final ItemStack lavaStack = new ItemStack((ItemLike)Items.f_42448_);
    @NotNull
    private final Component localizedName = Component.m_237115_((String)((WeaponTableBlock)((Object)ModBlocks.WEAPON_TABLE.get())).m_7705_());
    @NotNull
    private final IDrawable background;
    @NotNull
    private final IDrawable icon;
    @NotNull
    private final IDrawable bucket;

    WeaponTableRecipeCategory(@NotNull IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(BACKGROUND, 32, 14, 134, 77).addPadding(0, 33, 0, 0).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.WEAPON_TABLE.get()));
        this.bucket = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.f_42448_));
    }

    public void draw(@NotNull IWeaponTableRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics graphics, double mouseX, double mouseY) {
        ISkill<IHunterPlayer>[] requiredSkills;
        int x = 2;
        int y = 80;
        Minecraft minecraft = Minecraft.m_91087_();
        if (recipe.getRequiredLavaUnits() > 0) {
            this.bucket.draw(graphics, 83, 13);
            PoseStack pose = graphics.m_280168_();
            pose.m_85836_();
            RenderSystem.backupProjectionMatrix();
            RenderSystem.setProjectionMatrix((Matrix4f)pose.m_85850_().m_252922_(), (VertexSorting)VertexSorting.f_276633_);
            graphics.m_280480_(lavaStack, 83, 13);
            RenderSystem.restoreProjectionMatrix();
            pose.m_85849_();
        }
        if (recipe.getRequiredLevel() > 1) {
            MutableComponent level = Component.m_237110_((String)"gui.vampirism.hunter_weapon_table.level", (Object[])new Object[]{recipe.getRequiredLevel()});
            graphics.m_280614_(minecraft.f_91062_, (Component)level, x, y, Color.GRAY.getRGB(), false);
            Objects.requireNonNull(minecraft.f_91062_);
            y += 9 + 2;
        }
        if ((requiredSkills = recipe.getRequiredSkills()).length > 0) {
            MutableComponent skillText = Component.m_237110_((String)"gui.vampirism.skill_required", (Object[])new Object[]{" "});
            for (ISkill<IHunterPlayer> skill : recipe.getRequiredSkills()) {
                skillText.m_7220_(skill.getName()).m_130946_(" ");
            }
            y += UtilLib.renderMultiLine(minecraft.f_91062_, graphics, (Component)skillText, 132, x, y, Color.GRAY.getRGB());
        }
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    @NotNull
    public RecipeType<IWeaponTableRecipe> getRecipeType() {
        return VampirismJEIPlugin.WEAPON_TABLE;
    }

    @NotNull
    public Component getTitle() {
        return this.localizedName;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IWeaponTableRecipe recipe, IFocusGroup focuses) {
        int n;
        int height;
        if (recipe instanceof ShapelessWeaponTableRecipe) {
            builder.setShapeless();
        }
        List<List> inputs = recipe.m_7527_().stream().map(ingredient -> List.of(ingredient.m_43908_())).toList();
        List<List> list = recipe.m_7527_().stream().map(s -> List.of(s.m_43908_())).toList();
        IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 112, 32);
        output.addItemStack(RecipeUtil.getResultItem(recipe));
        ArrayList<IRecipeSlotBuilder> inputSlots = new ArrayList<IRecipeSlotBuilder>();
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 4; ++x) {
                IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, 2 + x * 19, 2 + y * 19);
                inputSlots.add(slot);
            }
        }
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe shaped = (IShapedRecipe)recipe;
            v0 = shaped.getRecipeHeight();
        } else {
            v0 = height = 4;
        }
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe shaped = (IShapedRecipe)recipe;
            n = shaped.getRecipeWidth();
        } else {
            n = 4;
        }
        int width = n;
        for (int i = 0; i < inputs.size(); ++i) {
            int index = WeaponTableRecipeCategory.getCraftingIndex(i, width, height);
            IRecipeSlotBuilder slot = (IRecipeSlotBuilder)inputSlots.get(index);
            List itemStacks = inputs.get(i);
            if (itemStacks == null) continue;
            slot.addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, itemStacks);
        }
    }

    private static int getCraftingIndex(int i, int width, int height) {
        int index;
        if (width == 1) {
            index = height == 4 ? i * 4 + 1 : (height == 3 ? i * 4 + 1 : (height == 2 ? i * 4 + 1 : 5));
        } else if (height == 1) {
            index = i + 4;
        } else if (width == 2) {
            index = i;
            if (i > 1) {
                index += 2;
                if (i > 3) {
                    index += 2;
                    if (i > 5) {
                        index += 2;
                    }
                }
            }
        } else if (height == 2) {
            index = i;
            if (width == 3 && i > 2) {
                ++index;
            }
        } else if (width == 3) {
            index = i;
            if (i > 2) {
                ++index;
                if (i > 5) {
                    ++index;
                    if (i > 8) {
                        ++index;
                    }
                }
            }
        } else {
            index = i;
        }
        return index;
    }
}

