/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.recipes;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.items.IFactionExclusiveItem;
import de.teamlapen.vampirism.api.items.IOilItem;
import de.teamlapen.vampirism.api.items.oil.IApplicableOil;
import de.teamlapen.vampirism.api.items.oil.IOil;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.util.OilUtils;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ApplicableOilRecipe
extends CustomRecipe {
    public ApplicableOilRecipe(@NotNull ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(@NotNull CraftingContainer inventory, @NotNull Level world) {
        IApplicableOil oil = null;
        ItemStack tool = null;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof IOilItem) {
                if (oil != null) {
                    return false;
                }
                IOil oil1 = ((IOilItem)stack.m_41720_()).getOil(stack);
                if (!(oil1 instanceof IApplicableOil)) continue;
                oil = (IApplicableOil)oil1;
                continue;
            }
            if (tool != null) {
                return false;
            }
            tool = stack;
        }
        return oil != null && tool != null && (!(tool.m_41720_() instanceof IFactionExclusiveItem) || ((IFactionExclusiveItem)tool.m_41720_()).getExclusiveFaction(tool) == VReference.HUNTER_FACTION) && oil.canBeApplied(tool);
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inventory, @NotNull RegistryAccess registryAccess) {
        ItemStack oilStack = ItemStack.f_41583_;
        ItemStack toolStack = ItemStack.f_41583_;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof IOilItem) {
                oilStack = stack;
                continue;
            }
            toolStack = stack;
        }
        ItemStack result = toolStack.m_41777_();
        if (oilStack.m_41619_() || toolStack.m_41619_()) {
            return result;
        }
        IOil oil = ((IOilItem)oilStack.m_41720_()).getOil(oilStack);
        if (oil instanceof IApplicableOil) {
            OilUtils.setAppliedOil(result, (IApplicableOil)oil);
        }
        return result;
    }

    public boolean m_8004_(int x, int y) {
        return x * y >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.APPLICABLE_OIL.get();
    }
}

