/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.recipes;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import de.teamlapen.vampirism.config.VampirismConfig;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import org.jetbrains.annotations.NotNull;

public class ConfigCondition
implements ICondition {
    private static final ResourceLocation ID = new ResourceLocation("vampirism", "config");
    @NotNull
    private final Function<ICondition.IContext, Boolean> tester;
    @NotNull
    private final String option;

    public ConfigCondition(@NotNull String option) {
        this.tester = this.getTester(option);
        this.option = option;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test(ICondition.IContext context) {
        return this.tester.apply(context);
    }

    @NotNull
    private Function<ICondition.IContext, Boolean> getTester(@NotNull String option) {
        return switch (option) {
            case "auto_convert" -> context -> (Boolean)VampirismConfig.COMMON.autoConvertGlassBottles.get();
            case "umbrella" -> context -> (Boolean)VampirismConfig.COMMON.umbrella.get();
            default -> throw new JsonSyntaxException("Unknown config option: " + option);
        };
    }

    public static class Serializer
    implements IConditionSerializer<ConfigCondition> {
        @NotNull
        public ResourceLocation getID() {
            return ID;
        }

        @NotNull
        public ConfigCondition read(@NotNull JsonObject json) {
            String option = json.get("option").getAsString();
            return new ConfigCondition(option);
        }

        public void write(@NotNull JsonObject json, @NotNull ConfigCondition value) {
            json.addProperty("option", value.option);
        }
    }
}

