/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.Collection;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;

public enum PotionEffectsProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;


    public static String getPotionDurationString(int duration) {
        if (duration >= Short.MAX_VALUE) {
            return "**:**";
        }
        int i = Mth.m_14143_((float)duration);
        return PotionEffectsProvider.ticksToElapsedTime(i);
    }

    public static String ticksToElapsedTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        if (!accessor.getServerData().m_128441_("Potions")) {
            return;
        }
        IElementHelper helper = IElementHelper.get();
        ITooltip box = helper.tooltip();
        ListTag list = accessor.getServerData().m_128437_("Potions", 10);
        Component[] lines = new Component[list.size()];
        for (int i = 0; i < lines.length; ++i) {
            CompoundTag compound = list.m_128728_(i);
            int duration = compound.m_128451_("Duration");
            MutableComponent name = Component.m_237115_((String)compound.m_128461_("Name"));
            String amplifierKey = "potion.potency." + compound.m_128451_("Amplifier");
            MutableComponent amplifier = I18n.m_118936_((String)amplifierKey) ? Component.m_237115_((String)amplifierKey) : Component.m_237113_((String)Integer.toString(compound.m_128451_("Amplifier")));
            MutableComponent s = Component.m_237110_((String)"jade.potion", (Object[])new Object[]{name, amplifier, PotionEffectsProvider.getPotionDurationString(duration)});
            IThemeHelper t = IThemeHelper.get();
            box.add((Component)(compound.m_128471_("Bad") ? t.danger(s) : t.success(s)));
        }
        tooltip.add(helper.box(box, BoxStyle.DEFAULT));
    }

    @Override
    public void appendServerData(CompoundTag tag, EntityAccessor accessor) {
        LivingEntity living = (LivingEntity)accessor.getEntity();
        Collection effects = living.m_21220_();
        if (effects.isEmpty()) {
            return;
        }
        ListTag list = new ListTag();
        for (MobEffectInstance effect : effects) {
            CompoundTag compound = new CompoundTag();
            compound.m_128359_("Name", effect.m_19576_());
            compound.m_128405_("Amplifier", effect.m_19564_());
            int duration = Math.min(Short.MAX_VALUE, effect.m_19557_());
            compound.m_128405_("Duration", duration);
            compound.m_128379_("Bad", effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL);
            list.add((Object)compound);
        }
        tag.m_128365_("Potions", (Tag)list);
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_POTION_EFFECTS;
    }
}

