/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api;

import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.ui.IElement;

public interface Accessor<T extends HitResult> {
    public Level getLevel();

    public Player getPlayer();

    @NotNull
    public CompoundTag getServerData();

    public T getHitResult();

    public boolean isServerConnected();

    public ItemStack getPickedResult();

    public boolean showDetails();

    public Object getTarget();

    public Class<? extends Accessor<?>> getAccessorType();

    public void toNetwork(FriendlyByteBuf var1);

    public static interface ClientHandler<T extends Accessor<?>> {
        public boolean shouldDisplay(T var1);

        public boolean shouldRequestData(T var1);

        public void requestData(T var1);

        public boolean verifyData(T var1);

        public IElement getIcon(T var1);

        public void gatherComponents(T var1, Function<IJadeProvider, ITooltip> var2);
    }
}

