/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.ui;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.ui.IElement;

public abstract class Element
implements IElement {
    protected IElement.Align align = IElement.Align.LEFT;
    protected Vec2 translation = Vec2.f_82462_;
    protected ResourceLocation tag;
    protected Vec2 size;
    private static final String DEFAULT_MESSAGE = "";
    protected String message = "";

    @Override
    public IElement size(Vec2 size) {
        this.size = size;
        return this;
    }

    @Override
    public Vec2 getCachedSize() {
        if (this.size == null) {
            this.size = this.getSize();
        }
        return this.size;
    }

    @Override
    public IElement align(IElement.Align align) {
        this.align = align;
        return this;
    }

    @Override
    public IElement.Align getAlignment() {
        return this.align;
    }

    @Override
    public IElement translate(Vec2 translation) {
        this.translation = translation;
        return this;
    }

    @Override
    public Vec2 getTranslation() {
        return this.translation;
    }

    @Override
    public IElement tag(ResourceLocation tag) {
        this.tag = tag;
        return this;
    }

    @Override
    public ResourceLocation getTag() {
        return this.tag;
    }

    @Override
    @Nullable
    public String getCachedMessage() {
        if (this.message == DEFAULT_MESSAGE) {
            this.message = this.getMessage();
        }
        return this.message;
    }

    @Override
    public IElement clearCachedMessage() {
        this.message = DEFAULT_MESSAGE;
        return this;
    }

    @Override
    public IElement message(@Nullable String message) {
        this.message = message;
        return this;
    }
}

