/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.view;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Locale;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.view.ViewGroup;

public class ItemView {
    public ItemStack item;
    @Nullable
    public String text;

    public ItemView(ItemStack item) {
        this(item, null);
    }

    public ItemView(ItemStack item, @Nullable String text) {
        this.item = item;
        this.text = text;
    }

    public static ViewGroup<ItemStack> fromContainer(Container container, int maxSize, int startIndex) {
        return ItemView.compacted(IntStream.range(startIndex, container.m_6643_()).limit(maxSize * 3).mapToObj(arg_0 -> ((Container)container).m_8020_(arg_0)), maxSize);
    }

    public static ViewGroup<ItemStack> compacted(Stream<ItemStack> stream, int maxSize) {
        ArrayList stacks = Lists.newArrayList();
        MutableInt start = new MutableInt();
        stream.filter(stack -> !stack.m_41619_()).filter(stack -> {
            if (stack.m_41782_() && stack.m_41783_().m_128441_("CustomModelData")) {
                for (String key : stack.m_41783_().m_128431_()) {
                    if (!key.toLowerCase(Locale.ENGLISH).endsWith("clear") || !stack.m_41783_().m_128471_(key)) continue;
                    return false;
                }
            }
            return true;
        }).forEach(stack -> {
            int size = stacks.size();
            if (size > maxSize) {
                return;
            }
            for (int i = 0; i < size; ++i) {
                int j = (i + start.intValue()) % size;
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)((ItemStack)stacks.get(j)))) continue;
                ((ItemStack)stacks.get(j)).m_41769_(stack.m_41613_());
                start.setValue(j);
                return;
            }
            stacks.add(stack.m_41777_());
        });
        if (stacks.size() > maxSize) {
            stacks.remove(maxSize);
        }
        return new ViewGroup<ItemStack>(stacks);
    }
}

