/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.io.File;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.addon.core.CorePlugin;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.gui.config.OptionButton;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.gui.config.value.OptionValue;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.CommonProxy;

public class WailaConfigScreen
extends BaseOptionsScreen {
    private OptionValue<Boolean> squareEntry;
    private OptionValue<Float> opacityEntry;

    public WailaConfigScreen(Screen parent) {
        super(parent, (Component)Component.m_237115_((String)"gui.jade.jade_settings"));
        this.saver = Jade.CONFIG::save;
        ImmutableMap.Builder keyMapBuilder = ImmutableMap.builder();
        for (KeyMapping keyMapping : Minecraft.m_91087_().f_91066_.f_92059_) {
            if (!JadeClient.openConfig.m_90858_().equals(keyMapping.m_90858_())) continue;
            keyMapBuilder.put((Object)keyMapping, (Object)ClientProxy.getBoundKeyOf(keyMapping));
        }
        ImmutableMap keyMap = keyMapBuilder.build();
        this.canceller = () -> {
            Jade.CONFIG.invalidate();
            keyMap.forEach(KeyMapping::m_90848_);
            Minecraft.m_91087_().f_91066_.m_92169_();
        };
    }

    public static OptionsList.Entry editBlocklist(OptionsList.Entry entry, String fileName, Runnable defaultCreator) {
        entry.getFirstWidget().m_93674_(79);
        MutableComponent tooltip = Component.m_237115_((String)"config.jade.edit_blocklist");
        entry.addWidget((AbstractWidget)Button.m_253074_((Component)Component.m_237113_((String)"\u2630"), b -> {
            File file = new File(CommonProxy.getConfigDirectory(), "jade/%s.json".formatted(fileName));
            if (!file.exists()) {
                defaultCreator.run();
            }
            Util.m_137581_().m_137644_(file);
        }).m_253046_(20, 20).m_257505_(Tooltip.m_257550_((Component)tooltip)).m_252778_($ -> tooltip).m_253136_(), 80);
        return entry;
    }

    @Override
    public OptionsList createOptions() {
        Objects.requireNonNull(this.f_96541_);
        OptionsList options = new OptionsList(this, this.f_96541_, this.f_96543_ - 120, this.f_96544_, 0, this.f_96544_ - 32, 26, Jade.CONFIG::save);
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        options.title("general");
        if (CommonProxy.isDevEnv()) {
            options.choices("debug_mode", general.isDebug(), general::setDebug);
        }
        options.choices("display_tooltip", general.shouldDisplayTooltip(), general::setDisplayTooltip);
        OptionValue<Comparable<Boolean>> entry = options.choices("display_entities", general.getDisplayEntities(), general::setDisplayEntities);
        WailaConfigScreen.editBlocklist(entry, "hide-entities", () -> CorePlugin.createBlockBlocklist().get());
        options.choices("display_bosses", general.getDisplayBosses(), general::setDisplayBosses).parent(entry);
        entry = options.choices("display_blocks", general.getDisplayBlocks(), general::setDisplayBlocks);
        WailaConfigScreen.editBlocklist(entry, "hide-blocks", () -> CorePlugin.createBlockBlocklist().get());
        options.choices("display_fluids", general.getDisplayFluids(), general::setDisplayFluids).parent(entry);
        options.choices("display_mode", general.getDisplayMode(), general::setDisplayMode, builder -> builder.m_232498_(mode -> {
            String key = "display_mode_" + mode.name().toLowerCase(Locale.ENGLISH) + "_desc";
            if (mode == IWailaConfig.DisplayMode.LITE && "fabric".equals(CommonProxy.getPlatformIdentifier())) {
                key = key + ".fabric";
            }
            return Tooltip.m_257550_((Component)OptionsList.Entry.makeTitle(key));
        }));
        OptionValue<Boolean> value = options.choices("item_mod_name", general.showItemModNameTooltip(), general::setItemModNameTooltip);
        if (!WailaConfig.ConfigGeneral.itemModNameTooltipDisabledByMods.isEmpty()) {
            value.setDisabled(true);
            value.appendDescription(I18n.m_118938_((String)"gui.jade.disabled_by_mods", (Object[])new Object[0]));
            WailaConfig.ConfigGeneral.itemModNameTooltipDisabledByMods.forEach(value::appendDescription);
            if (value.getFirstWidget() != null) {
                value.getFirstWidget().m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)value.getDescription())));
            }
        }
        options.choices("hide_from_debug", general.shouldHideFromDebug(), general::setHideFromDebug);
        options.choices("hide_from_tab_list", general.shouldHideFromTabList(), general::setHideFromTabList);
        options.choices("boss_bar_overlap", general.getBossBarOverlapMode(), general::setBossBarOverlapMode);
        options.slider("reach_distance", general.getReachDistance(), general::setReachDistance, 0.0f, 20.0f, f -> (float)Mth.m_14143_((float)(f * 2.0f)) / 2.0f);
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        options.title("overlay");
        options.choices("overlay_theme", overlay.getTheme().id, IThemeHelper.get().getThemes().stream().map($ -> $.id).toList(), id -> {
            overlay.applyTheme((ResourceLocation)id);
            Theme theme = overlay.getTheme();
            if (theme.squareBorder != null) {
                this.squareEntry.setValue(theme.squareBorder);
            }
            if (theme.opacity != 0.0f) {
                this.opacityEntry.setValue(Float.valueOf(theme.opacity));
            }
        }, id -> Component.m_237115_((String)Util.m_137492_((String)"jade.theme", (ResourceLocation)id)));
        this.squareEntry = options.choices("overlay_square", overlay.getSquare(), overlay::setSquare);
        this.opacityEntry = options.slider("overlay_alpha", overlay.getAlpha(), overlay::setAlpha);
        options.forcePreview.add(options.slider("overlay_scale", overlay.getOverlayScale(), overlay::setOverlayScale, 0.2f, 2.0f, FloatUnaryOperator.identity()));
        entry = options.slider("overlay_pos_x", overlay.getOverlayPosX(), overlay::setOverlayPosX);
        options.forcePreview.add(entry);
        options.forcePreview.add(options.slider("overlay_anchor_x", overlay.getAnchorX(), overlay::setAnchorX).parent(entry));
        entry = options.slider("overlay_pos_y", overlay.getOverlayPosY(), overlay::setOverlayPosY);
        options.forcePreview.add(entry);
        options.forcePreview.add(options.slider("overlay_anchor_y", overlay.getAnchorY(), overlay::setAnchorY).parent(entry));
        options.choices("display_item", overlay.getIconMode(), overlay::setIconMode);
        options.choices("animation", overlay.getAnimation(), overlay::setAnimation);
        options.title("key_binds");
        options.keybind(JadeClient.openConfig);
        options.keybind(JadeClient.showOverlay);
        options.keybind(JadeClient.toggleLiquid);
        if (ClientProxy.shouldRegisterRecipeViewerKeys()) {
            options.keybind(JadeClient.showRecipes);
            options.keybind(JadeClient.showUses);
        }
        options.keybind(JadeClient.narrate);
        options.keybind(JadeClient.showDetails);
        options.title("accessibility");
        options.choices("flip_main_hand", overlay.getFlipMainHand(), overlay::setFlipMainHand);
        options.choices("tts_mode", general.getTTSMode(), general::setTTSMode);
        options.title("danger_zone").m_130940_(ChatFormatting.RED);
        MutableComponent reset = Component.m_237115_((String)"controls.reset").m_130940_(ChatFormatting.RED);
        MutableComponent title = Component.m_237115_((String)OptionsList.Entry.makeKey("reset_settings")).m_130940_(ChatFormatting.RED);
        options.add(new OptionButton((Component)title, Button.m_253074_((Component)reset, arg_0 -> this.lambda$createOptions$12((Component)title, (Component)reset, arg_0)).m_253046_(100, 20).m_253136_()));
        return options;
    }

    private /* synthetic */ void lambda$createOptions$12(Component title, Component reset, Button w) {
        this.f_96541_.m_91152_((Screen)new ConfirmScreen(bl -> {
            if (bl) {
                for (KeyMapping keyMapping : this.f_96541_.f_91066_.f_92059_) {
                    if (!JadeClient.openConfig.m_90858_().equals(keyMapping.m_90858_())) continue;
                    keyMapping.m_90848_(keyMapping.m_90861_());
                }
                this.f_96541_.f_91066_.m_92169_();
                try {
                    int themesHash = Jade.CONFIG.get().getOverlay().themesHash;
                    Preconditions.checkState((boolean)Jade.CONFIG.getFile().delete());
                    Preconditions.checkState((boolean)PluginConfig.INSTANCE.getFile().delete());
                    Jade.CONFIG.invalidate();
                    Jade.CONFIG.get().getOverlay().themesHash = themesHash;
                    Jade.CONFIG.save();
                    PluginConfig.INSTANCE.reload();
                    this.m_232761_();
                }
                catch (Throwable e) {
                    Jade.LOGGER.catching(e);
                }
            }
            this.f_96541_.m_91152_((Screen)this);
            this.options.m_93410_(this.options.m_93518_());
        }, title, (Component)Component.m_237115_((String)OptionsList.Entry.makeKey("reset_settings.confirm")), reset, (Component)Component.m_237115_((String)"gui.cancel")));
    }
}

