/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config.value;

import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import java.text.DecimalFormat;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import snownee.jade.gui.config.value.OptionValue;

public class SliderOptionValue
extends OptionValue<Float> {
    private final Slider slider;
    private float min;
    private float max;
    private FloatUnaryOperator aligner;

    public SliderOptionValue(String optionName, float value, Consumer<Float> save, float min, float max, FloatUnaryOperator aligner) {
        super(optionName, save);
        this.value = Float.valueOf(value);
        this.min = min;
        this.max = max;
        this.aligner = aligner;
        this.slider = new Slider(this, 0, 0, 100, 20, this.getTitle());
        this.addWidget((AbstractWidget)this.slider, 0);
    }

    @Override
    public void setValue(Float value) {
        this.slider.setValue(value.floatValue());
    }

    public static class Slider
    extends AbstractSliderButton {
        private static DecimalFormat fmt = new DecimalFormat("##.##");
        private final SliderOptionValue parent;

        public Slider(SliderOptionValue parent, int x, int y, int width, int height, Component message) {
            super(x, y, width, height, message, Slider.fromScaled(((Float)parent.value).floatValue(), parent.min, parent.max));
            this.parent = parent;
            this.m_5697_();
        }

        public static double fromScaled(float f, float min, float max) {
            return Mth.m_14036_((float)((f - min) / (max - min)), (float)0.0f, (float)1.0f);
        }

        public float toScaled() {
            String s = fmt.format(this.parent.aligner.apply(this.parent.min + (this.parent.max - this.parent.min) * (float)this.f_93577_));
            return Float.parseFloat(s);
        }

        protected void m_5695_() {
            this.parent.value = Float.valueOf(this.toScaled());
            this.parent.save();
        }

        protected void m_5697_() {
            this.m_93666_((Component)Component.m_237113_((String)fmt.format(this.toScaled())));
        }

        private void setValue(float value) {
            this.f_93577_ = Slider.fromScaled(value, this.parent.min, this.parent.max);
            this.m_5697_();
            this.m_5695_();
        }
    }
}

