/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.ui.ElementHelper;
import snownee.jade.impl.ui.ItemStackElement;
import snownee.jade.overlay.RayTracing;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.WailaExceptionHandler;

public class BlockAccessorClientHandler
implements Accessor.ClientHandler<BlockAccessor> {
    @Override
    public boolean shouldDisplay(BlockAccessor accessor) {
        return IWailaConfig.get().getGeneral().getDisplayBlocks();
    }

    @Override
    public boolean shouldRequestData(BlockAccessor accessor) {
        if (accessor.getBlockEntity() == null) {
            return false;
        }
        return !WailaCommonRegistration.INSTANCE.getBlockNBTProviders(accessor.getBlockEntity()).isEmpty();
    }

    @Override
    public void requestData(BlockAccessor accessor) {
        ClientProxy.requestBlockData(accessor);
    }

    @Override
    public boolean verifyData(BlockAccessor accessor) {
        CompoundTag serverData = accessor.getServerData();
        int x = serverData.m_128451_("x");
        int y = serverData.m_128451_("y");
        int z = serverData.m_128451_("z");
        BlockPos hitPos = accessor.getPosition();
        return x == hitPos.m_123341_() && y == hitPos.m_123342_() && z == hitPos.m_123343_();
    }

    @Override
    public IElement getIcon(BlockAccessor accessor) {
        BlockState blockState = accessor.getBlockState();
        Block block = blockState.m_60734_();
        if (blockState.m_60795_()) {
            return null;
        }
        IElement icon = null;
        if (accessor.isFakeBlock()) {
            icon = ItemStackElement.of(accessor.getFakeBlock());
        } else {
            ItemStack pick = accessor.getPickedResult();
            if (!pick.m_41619_()) {
                icon = ItemStackElement.of(pick);
            }
        }
        if (RayTracing.isEmptyElement(icon) && block.m_5456_() != Items.f_41852_) {
            icon = ItemStackElement.of(new ItemStack((ItemLike)block));
        }
        if (RayTracing.isEmptyElement(icon) && block instanceof LiquidBlock) {
            icon = ClientProxy.elementFromLiquid((LiquidBlock)block);
        }
        for (IBlockComponentProvider provider : WailaClientRegistration.INSTANCE.getBlockIconProviders(block, PluginConfig.INSTANCE::get)) {
            try {
                IElement element = provider.getIcon(accessor, PluginConfig.INSTANCE, icon);
                if (RayTracing.isEmptyElement(element)) continue;
                icon = element;
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider, null);
            }
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gatherComponents(BlockAccessor accessor, Function<IJadeProvider, ITooltip> tooltipProvider) {
        List<IBlockComponentProvider> providers = WailaClientRegistration.INSTANCE.getBlockProviders(accessor.getBlock(), PluginConfig.INSTANCE::get);
        for (IBlockComponentProvider provider : providers) {
            ITooltip tooltip = tooltipProvider.apply(provider);
            try {
                ElementHelper.INSTANCE.setCurrentUid(provider.getUid());
                provider.appendTooltip(tooltip, accessor, PluginConfig.INSTANCE);
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, provider, tooltip);
            }
            finally {
                ElementHelper.INSTANCE.setCurrentUid(null);
            }
        }
    }
}

