/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.theme;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.util.Color;

public class ThemeSerializer
implements JsonDeserializer<Theme>,
JsonSerializer<Theme> {
    public JsonElement serialize(Theme src, Type typeOfSrc, JsonSerializationContext context) {
        int i;
        JsonArray array;
        JsonObject o = new JsonObject();
        o.addProperty("id", src.id.toString());
        if (src.backgroundTexture != null) {
            array = new JsonArray();
            array.add((JsonElement)new JsonPrimitive(src.backgroundTexture.toString()));
            for (int i2 : src.backgroundTextureUV) {
                array.add((Number)i2);
            }
            o.add("backgroundImage", (JsonElement)array);
        } else {
            if (src.backgroundColor != -1) {
                o.addProperty("backgroundColor", Color.rgb(src.backgroundColor).getHex());
            }
            array = new JsonArray();
            for (int i3 = 0; i3 < 4; ++i3) {
                array.add(Color.rgb(src.borderColor[i3]).getHex());
            }
            o.add("borderColor", (JsonElement)array);
        }
        o.addProperty("titleColor", Color.rgb(src.titleColor).getHex());
        o.addProperty("normalColor", Color.rgb(src.normalColor).getHex());
        o.addProperty("infoColor", Color.rgb(src.infoColor).getHex());
        o.addProperty("successColor", Color.rgb(src.successColor).getHex());
        o.addProperty("warningColor", Color.rgb(src.warningColor).getHex());
        o.addProperty("dangerColor", Color.rgb(src.dangerColor).getHex());
        o.addProperty("failureColor", Color.rgb(src.failureColor).getHex());
        o.addProperty("boxBorderColor", Color.rgb(src.boxBorderColor).getHex());
        o.addProperty("bottomProgressNormalColor", Color.rgb(src.bottomProgressNormalColor).getHex());
        o.addProperty("bottomProgressFailureColor", Color.rgb(src.bottomProgressFailureColor).getHex());
        if (!src.textShadow) {
            o.addProperty("textShadow", Boolean.valueOf(false));
        }
        array = new JsonArray();
        for (i = 0; i < 4; ++i) {
            array.add((Number)src.padding[i]);
        }
        o.add("padding", (JsonElement)array);
        if (src.squareBorder != null) {
            o.addProperty("squareBorder", src.squareBorder);
        }
        if (src.opacity != 0.0f) {
            o.addProperty("opacity", (Number)Float.valueOf(src.opacity));
        }
        if (src.bottomProgressOffset != null) {
            array = new JsonArray();
            for (i = 0; i < 4; ++i) {
                array.add((Number)src.bottomProgressOffset[i]);
            }
            o.add("bottomProgressOffset", (JsonElement)array);
        }
        if (src.lightColorScheme) {
            o.addProperty("lightColorScheme", Boolean.valueOf(true));
        }
        return o;
    }

    public Theme deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        int i;
        JsonArray array;
        JsonObject o = json.getAsJsonObject();
        Theme theme = new Theme();
        if (o.has("backgroundImage")) {
            array = o.getAsJsonArray("backgroundImage");
            Preconditions.checkArgument((array.size() == 9 ? 1 : 0) != 0, (Object)"backgroundImage must have 9 elements");
            theme.backgroundTexture = new ResourceLocation(array.get(0).getAsString());
            theme.backgroundTextureUV = new int[8];
            for (i = 0; i < 8; ++i) {
                theme.backgroundTextureUV[i] = array.get(i + 1).getAsInt();
            }
        } else {
            theme.backgroundColor = this.readColor(o.get("backgroundColor"), theme.backgroundColor);
            array = o.get("borderColor").getAsJsonArray();
            Preconditions.checkArgument((array.size() == 4 ? 1 : 0) != 0, (Object)"borderColor must have 4 elements");
            for (i = 0; i < 4; ++i) {
                theme.borderColor[i] = this.readColor(array.get(i), theme.borderColor[i]);
            }
        }
        theme.titleColor = this.readColor(o.get("titleColor"), theme.titleColor);
        theme.normalColor = this.readColor(o.get("normalColor"), theme.normalColor);
        theme.infoColor = this.readColor(o.get("infoColor"), theme.infoColor);
        theme.successColor = this.readColor(o.get("successColor"), theme.successColor);
        theme.warningColor = this.readColor(o.get("warningColor"), theme.warningColor);
        theme.dangerColor = this.readColor(o.get("dangerColor"), theme.dangerColor);
        theme.failureColor = this.readColor(o.get("failureColor"), theme.failureColor);
        theme.boxBorderColor = this.readColor(o.get("boxBorderColor"), theme.boxBorderColor);
        theme.bottomProgressNormalColor = this.readColor(o.get("bottomProgressNormalColor"), theme.bottomProgressNormalColor);
        theme.bottomProgressFailureColor = this.readColor(o.get("bottomProgressFailureColor"), theme.bottomProgressFailureColor);
        theme.textShadow = GsonHelper.m_13855_((JsonObject)o, (String)"textShadow", (boolean)true);
        if (o.has("padding")) {
            array = o.getAsJsonArray("padding");
            Preconditions.checkArgument((array.size() == 4 ? 1 : 0) != 0, (Object)"padding must have 4 elements");
            for (i = 0; i < 4; ++i) {
                theme.padding[i] = array.get(i).getAsInt();
            }
        }
        if (o.has("squareBorder")) {
            theme.squareBorder = o.get("squareBorder").getAsBoolean();
        }
        theme.opacity = GsonHelper.m_13820_((JsonObject)o, (String)"opacity", (float)0.0f);
        if (o.has("bottomProgressOffset")) {
            array = o.getAsJsonArray("bottomProgressOffset");
            Preconditions.checkArgument((array.size() == 4 ? 1 : 0) != 0, (Object)"bottomProgressOffset must have 4 elements");
            theme.bottomProgressOffset = new int[4];
            for (i = 0; i < 4; ++i) {
                theme.bottomProgressOffset[i] = array.get(i).getAsInt();
            }
        }
        theme.lightColorScheme = GsonHelper.m_13855_((JsonObject)o, (String)"lightColorScheme", (boolean)false);
        return theme;
    }

    private int readColor(JsonElement el, int fallback) {
        if (el == null || el.isJsonNull()) {
            return fallback;
        }
        JsonPrimitive e = el.getAsJsonPrimitive();
        if (e.isString()) {
            try {
                return Color.valueOf(e.getAsString()).toInt();
            }
            catch (Throwable e2) {
                return 0;
            }
        }
        return e.getAsInt();
    }
}

