/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.IntConsumer;
import java.util.function.ToIntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.mutable.MutableObject;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.callback.JadeBeforeRenderCallback;
import snownee.jade.api.callback.JadeRenderBackgroundCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.Theme;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.TooltipRenderer;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.ClientProxy;

public class OverlayRenderer {
    public static final MutableObject<Theme> theme = new MutableObject((Object)IWailaConfig.get().getOverlay().getTheme());
    public static float ticks;
    public static boolean shown;
    public static float alpha;
    private static TooltipRenderer fadeTooltip;
    private static Rect2i morphRect;

    public static boolean shouldShow() {
        if (WailaTickHandler.instance().tooltipRenderer == null) {
            return false;
        }
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        if (!general.shouldDisplayTooltip()) {
            return false;
        }
        if (general.getDisplayMode() == IWailaConfig.DisplayMode.HOLD_KEY && !JadeClient.showOverlay.m_90857_()) {
            return false;
        }
        IWailaConfig.BossBarOverlapMode mode = Jade.CONFIG.get().getGeneral().getBossBarOverlapMode();
        return mode != IWailaConfig.BossBarOverlapMode.HIDE_TOOLTIP || ClientProxy.getBossBarRect() == null;
    }

    public static boolean shouldShowImmediately(TooltipRenderer tooltipRenderer) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return false;
        }
        if (!ClientProxy.shouldShowWithOverlay(mc, mc.f_91080_)) {
            return false;
        }
        tooltipRenderer.recalculateRealRect();
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        Screen screen = mc.f_91080_;
        if (screen instanceof BaseOptionsScreen) {
            double y;
            BaseOptionsScreen optionsScreen = (BaseOptionsScreen)screen;
            if (!general.previewOverlay && !optionsScreen.forcePreviewOverlay()) {
                return false;
            }
            Rect2i position = tooltipRenderer.getRealRect();
            Window window = mc.m_91268_();
            double x = mc.f_91067_.m_91589_() * (double)window.m_85445_() / (double)window.m_85443_();
            if (position.m_110087_((int)x, (int)(y = mc.f_91067_.m_91594_() * (double)window.m_85446_() / (double)window.m_85444_()))) {
                return false;
            }
        }
        if (mc.f_91066_.f_92063_ && general.shouldHideFromDebug()) {
            return false;
        }
        if (mc.m_91265_() != null || mc.f_91066_.f_92062_) {
            return false;
        }
        return !mc.f_91065_.m_93088_().f_94524_ || !general.shouldHideFromTabList();
    }

    public static void renderOverlay478757(GuiGraphics guiGraphics) {
        shown = false;
        boolean show = OverlayRenderer.shouldShow();
        TooltipRenderer tooltipRenderer = WailaTickHandler.instance().tooltipRenderer;
        float delta = Minecraft.m_91087_().m_91297_();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        if (overlay.getAnimation()) {
            if (tooltipRenderer == null) {
                tooltipRenderer = fadeTooltip;
            } else {
                fadeTooltip = tooltipRenderer;
            }
            float speed = general.isDebug() ? 0.1f : 0.6f;
            alpha += (show ? speed : -speed) * delta;
            alpha = Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f);
        } else {
            float f = alpha = show ? 1.0f : 0.0f;
        }
        if (alpha < 0.1f || tooltipRenderer == null || !OverlayRenderer.shouldShowImmediately(tooltipRenderer)) {
            fadeTooltip = null;
            morphRect = null;
            return;
        }
        ticks += delta;
        Minecraft.m_91087_().m_91307_().m_6180_("Jade Overlay");
        OverlayRenderer.renderOverlay(tooltipRenderer, guiGraphics);
        Minecraft.m_91087_().m_91307_().m_7238_();
    }

    public static void renderOverlay(TooltipRenderer tooltip, GuiGraphics guiGraphics) {
        PoseStack matrixStack = guiGraphics.m_280168_();
        matrixStack.m_85836_();
        Rect2i position = Objects.requireNonNull(tooltip.getRealRect());
        if (morphRect == null) {
            morphRect = new Rect2i(position.m_110085_(), position.m_110086_(), position.m_110090_(), position.m_110091_());
        } else {
            OverlayRenderer.chase(position, Rect2i::m_110085_, arg_0 -> ((Rect2i)morphRect).m_173047_(arg_0));
            OverlayRenderer.chase(position, Rect2i::m_110086_, arg_0 -> ((Rect2i)morphRect).m_173054_(arg_0));
            OverlayRenderer.chase(position, Rect2i::m_110090_, arg_0 -> ((Rect2i)morphRect).m_173056_(arg_0));
            OverlayRenderer.chase(position, Rect2i::m_110091_, arg_0 -> ((Rect2i)morphRect).m_173058_(arg_0));
        }
        JadeBeforeRenderCallback.ColorSetting colorSetting = new JadeBeforeRenderCallback.ColorSetting();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        colorSetting.alpha = overlay.getAlpha();
        Theme themeBefore = overlay.getTheme();
        theme.setValue((Object)themeBefore);
        colorSetting.theme = theme;
        for (JadeBeforeRenderCallback callback2 : WailaClientRegistration.INSTANCE.beforeRenderCallback.callbacks()) {
            if (!callback2.beforeRender(tooltip.getTooltip(), morphRect, guiGraphics, ObjectDataCenter.get(), colorSetting)) continue;
            matrixStack.m_85849_();
            return;
        }
        if (themeBefore != theme.getValue()) {
            tooltip.setPaddingFromTheme((Theme)theme.getValue());
        }
        float z = Minecraft.m_91087_().f_91080_ == null ? 1.0f : 100.0f;
        matrixStack.m_252880_((float)morphRect.m_110085_(), (float)morphRect.m_110086_(), z);
        float scale = tooltip.getRealScale();
        if (scale != 1.0f) {
            matrixStack.m_85841_(scale, scale, 1.0f);
        }
        boolean doDefault = true;
        colorSetting.alpha *= alpha;
        for (JadeRenderBackgroundCallback callback3 : WailaClientRegistration.INSTANCE.renderBackgroundCallback.callbacks()) {
            if (!callback3.onRender(tooltip, morphRect, guiGraphics, ObjectDataCenter.get(), colorSetting)) continue;
            doDefault = false;
            break;
        }
        RenderSystem.enableBlend();
        if (doDefault && colorSetting.alpha > 0.0f) {
            OverlayRenderer.drawTooltipBox(guiGraphics, 0, 0, Mth.m_14167_((float)((float)morphRect.m_110090_() / scale)), Mth.m_14167_((float)((float)morphRect.m_110091_() / scale)), colorSetting.alpha, overlay.getSquare());
        }
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        tooltip.draw(guiGraphics);
        RenderSystem.disableBlend();
        WailaClientRegistration.INSTANCE.afterRenderCallback.call(callback -> callback.afterRender(tooltip.getTooltip(), morphRect, guiGraphics, ObjectDataCenter.get()));
        RenderSystem.enableDepthTest();
        matrixStack.m_85849_();
        if (Jade.CONFIG.get().getGeneral().shouldEnableTextToSpeech() && Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91073_.m_46467_() % 5L == 0L) {
            WailaTickHandler.narrate(tooltip.getTooltip(), true);
        }
        shown = true;
    }

    private static void chase(Rect2i pos, ToIntFunction<Rect2i> getter, IntConsumer setter) {
        if (Jade.CONFIG.get().getOverlay().getAnimation()) {
            int value = getter.applyAsInt(morphRect);
            int target = getter.applyAsInt(pos);
            float diff = target - value;
            if (diff == 0.0f) {
                return;
            }
            float delta = Minecraft.m_91087_().m_91297_() * 2.0f;
            if (delta < 1.0f) {
                diff *= delta;
            }
            if (Mth.m_14154_((float)diff) < 1.0f) {
                diff = diff > 0.0f ? 1.0f : -1.0f;
            }
            setter.accept((int)((float)value + diff));
        } else {
            setter.accept(getter.applyAsInt(pos));
        }
    }

    public static void drawTooltipBox(GuiGraphics guiGraphics, int x, int y, int w, int h, float alpha, boolean square) {
        Theme theme = (Theme)OverlayRenderer.theme.getValue();
        if (theme.backgroundTexture != null) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            guiGraphics.m_280195_(theme.backgroundTexture, x, y, w, h, theme.backgroundTextureUV[0], theme.backgroundTextureUV[1], theme.backgroundTextureUV[2], theme.backgroundTextureUV[3], theme.backgroundTextureUV[4], theme.backgroundTextureUV[5], theme.backgroundTextureUV[6], theme.backgroundTextureUV[7]);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            int bg;
            if (!square) {
                w -= 2;
                h -= 2;
            }
            if ((bg = theme.backgroundColor) != -1) {
                bg = IWailaConfig.IConfigOverlay.applyAlpha(bg, alpha);
                DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x + 1, y + 1, w - 2, h - 2, bg, bg);
                if (!square) {
                    DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y - 1, w, 1.0f, bg, bg);
                    DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y + h, w, 1.0f, bg, bg);
                    DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x - 1, y, 1.0f, h, bg, bg);
                    DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x + w, y, 1.0f, h, bg, bg);
                }
            }
            int[] borderColors = new int[4];
            for (int i = 0; i < 4; ++i) {
                borderColors[i] = IWailaConfig.IConfigOverlay.applyAlpha(theme.borderColor[i], alpha);
            }
            DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y + 1, 1.0f, h - 2, borderColors[0], borderColors[3]);
            DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x + w - 1, y + 1, 1.0f, h - 2, borderColors[1], borderColors[2]);
            DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y, w, 1.0f, borderColors[0], borderColors[1]);
            DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, y + h - 1, w, 1.0f, borderColors[3], borderColors[2]);
        }
    }
}

