/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.math.IntMath;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;

public class JadeForgeUtils {
    private JadeForgeUtils() {
    }

    public static ViewGroup<ItemStack> fromItemHandler(IItemHandler itemHandler, int maxSize, int startIndex) {
        return ItemView.compacted(IntStream.range(startIndex, itemHandler.getSlots()).limit(maxSize * 3).mapToObj(arg_0 -> ((IItemHandler)itemHandler).getStackInSlot(arg_0)), maxSize);
    }

    public static CompoundTag fromFluidStack(FluidStack fluidStack, long capacity) {
        CompoundTag tag = new CompoundTag();
        if (capacity <= 0L) {
            return tag;
        }
        tag.m_128359_("fluid", BuiltInRegistries.f_257020_.m_7981_((Object)fluidStack.getFluid()).toString());
        tag.m_128356_("amount", (long)fluidStack.getAmount());
        tag.m_128356_("capacity", capacity);
        if (fluidStack.getTag() != null) {
            tag.m_128365_("tag", (Tag)fluidStack.getTag());
        }
        return tag;
    }

    public static List<ViewGroup<CompoundTag>> fromFluidHandler(IFluidHandler fluidHandler) {
        ArrayList<CompoundTag> list = new ArrayList<CompoundTag>(fluidHandler.getTanks());
        int emptyCapacity = 0;
        for (int i = 0; i < fluidHandler.getTanks(); ++i) {
            int capacity = fluidHandler.getTankCapacity(i);
            if (capacity <= 0) continue;
            FluidStack fluidStack = fluidHandler.getFluidInTank(i);
            if (fluidStack.isEmpty()) {
                emptyCapacity = IntMath.saturatedAdd((int)emptyCapacity, (int)capacity);
                continue;
            }
            list.add(JadeForgeUtils.fromFluidStack(fluidStack, capacity));
        }
        if (list.isEmpty() && emptyCapacity > 0) {
            list.add(JadeForgeUtils.fromFluidStack(FluidStack.EMPTY, emptyCapacity));
        }
        if (!list.isEmpty()) {
            return List.of(new ViewGroup(list));
        }
        return List.of();
    }
}

