/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.ModConstants;
import com.jaquadro.minecraft.storagedrawers.client.gui.StorageGuiGraphics;
import com.jaquadro.minecraft.storagedrawers.inventory.ContainerDrawers;
import com.jaquadro.minecraft.storagedrawers.inventory.InventoryUpgrade;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotDrawer;
import com.jaquadro.minecraft.storagedrawers.inventory.SlotStorage;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class DrawerScreen
extends AbstractContainerScreen<ContainerDrawers> {
    private static final ResourceLocation guiTextures1 = ModConstants.loc("textures/gui/drawers_1.png");
    private static final ResourceLocation guiTextures2 = ModConstants.loc("textures/gui/drawers_2.png");
    private static final ResourceLocation guiTextures4 = ModConstants.loc("textures/gui/drawers_4.png");
    private static final ResourceLocation guiTexturesComp2 = ModConstants.loc("textures/gui/drawers_comp_2.png");
    private static final ResourceLocation guiTexturesComp3 = ModConstants.loc("textures/gui/drawers_comp.png");
    private static final int smDisabledX = 176;
    private static final int smDisabledY = 0;
    private static final int smMissingY = 16;
    private static StorageGuiGraphics storageGuiGraphics;
    private final ResourceLocation background;
    private final Inventory inventory;

    public DrawerScreen(ContainerDrawers container, Inventory playerInv, Component name, ResourceLocation bg) {
        super((AbstractContainerMenu)container, playerInv, name);
        this.f_97726_ = 176;
        this.f_97727_ = 199;
        this.background = bg;
        this.inventory = playerInv;
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    public void m_88315_(GuiGraphics graphics, int x, int y, float f) {
        if (storageGuiGraphics == null || storageGuiGraphics.baseGraphics() != graphics) {
            storageGuiGraphics = new StorageGuiGraphics(this.f_96541_, graphics);
        }
        ((ContainerDrawers)this.f_97732_).activeGuiGraphics = storageGuiGraphics;
        super.m_88315_((GuiGraphics)storageGuiGraphics, x, y, f);
        ((ContainerDrawers)this.f_97732_).activeGuiGraphics = null;
        DrawerScreen.storageGuiGraphics.overrideStack = ItemStack.f_41583_;
        this.m_280072_(graphics, x, y);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, 8, 6, 0x404040, false);
        graphics.m_280056_(this.f_96547_, I18n.m_118938_((String)"container.storagedrawers.upgrades", (Object[])new Object[0]), 8, 75, 0x404040, false);
        graphics.m_280056_(this.f_96547_, this.inventory.m_5446_().getString(), 8, this.f_97727_ - 96 + 2, 0x404040, false);
        String mult = Integer.toString(((ContainerDrawers)this.f_97732_).getStackCapacity());
        graphics.m_280056_(this.f_96547_, mult, 161 - mult.length() * 6, 42, 0x404040, false);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int guiX = (this.f_96543_ - this.f_97726_) / 2;
        int guiY = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(this.background, guiX, guiY, 0, 0, this.f_97726_, this.f_97727_);
        List<Slot> storageSlots = ((ContainerDrawers)this.f_97732_).getStorageSlots();
        for (Slot slot : storageSlots) {
            SlotDrawer sd;
            if (slot instanceof SlotDrawer && (sd = (SlotDrawer)slot).getDrawer().isMissing()) {
                graphics.m_280218_(this.background, guiX + slot.f_40220_, guiY + slot.f_40221_, 176, 16, 16, 16);
                continue;
            }
            graphics.m_280218_(this.background, guiX + slot.f_40220_, guiY + slot.f_40221_, 176, 0, 16, 16);
        }
        List<Slot> upgradeSlots = ((ContainerDrawers)this.f_97732_).getUpgradeSlots();
        for (Slot slot : upgradeSlots) {
            boolean locked = false;
            Container container = slot.f_40218_;
            if (container instanceof InventoryUpgrade) {
                InventoryUpgrade ucontainer = (InventoryUpgrade)container;
                locked = ucontainer.slotIsLocked(slot.m_150661_());
            }
            if (!locked) continue;
            graphics.m_280218_(this.background, guiX + slot.f_40220_, guiY + slot.f_40221_, 176, 0, 16, 16);
        }
    }

    protected boolean m_6774_(int x, int y, int width, int height, double originX, double originY) {
        List<Slot> storageSlots = ((ContainerDrawers)this.f_97732_).getStorageSlots();
        for (Slot slot : storageSlots) {
            if (!(slot instanceof SlotStorage) || slot.f_40220_ != x || slot.f_40221_ != y) continue;
            return false;
        }
        return super.m_6774_(x, y, width, height, originX, originY);
    }

    public static class Compacting3
    extends DrawerScreen {
        public Compacting3(ContainerDrawers container, Inventory playerInv, Component name) {
            super(container, playerInv, name, guiTexturesComp3);
        }
    }

    public static class Compacting2
    extends DrawerScreen {
        public Compacting2(ContainerDrawers container, Inventory playerInv, Component name) {
            super(container, playerInv, name, guiTexturesComp2);
        }
    }

    public static class Slot4
    extends DrawerScreen {
        public Slot4(ContainerDrawers container, Inventory playerInv, Component name) {
            super(container, playerInv, name, guiTextures4);
        }
    }

    public static class Slot2
    extends DrawerScreen {
        public Slot2(ContainerDrawers container, Inventory playerInv, Component name) {
            super(container, playerInv, name, guiTextures2);
        }
    }

    public static class Slot1
    extends DrawerScreen {
        public Slot1(ContainerDrawers container, Inventory playerInv, Component name) {
            super(container, playerInv, name, guiTextures1);
        }
    }
}

