/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.projectile.crystal;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.particle.AetherParticleTypes;
import com.aetherteam.aether.data.resources.registries.AetherDamageTypes;
import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.aether.entity.projectile.crystal.AbstractCrystal;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThunderCrystal
extends AbstractCrystal {
    private Entity target;

    public ThunderCrystal(EntityType<? extends ThunderCrystal> entityType, Level level) {
        super(entityType, level);
    }

    public ThunderCrystal(EntityType<? extends ThunderCrystal> entityType, Level level, Entity shooter, Entity target) {
        super(entityType, level);
        this.m_5602_(shooter);
        this.target = target;
        this.m_6034_(shooter.m_20185_(), shooter.m_20188_(), shooter.m_20189_());
    }

    protected void m_5790_(EntityHitResult result) {
        LivingEntity target;
        Entity entity = result.m_82443_();
        if (entity instanceof LivingEntity && (target = (LivingEntity)entity) != this.m_19749_()) {
            target.m_6469_(AetherDamageTypes.indirectEntityDamageSource(this.m_9236_(), AetherDamageTypes.THUNDER_CRYSTAL, (Entity)this, this.m_19749_()), 5.0f);
            this.knockback(0.1, this.m_20182_().m_82546_(target.m_20182_()));
            target.m_147240_(0.25, this.m_20185_() - target.m_20185_(), this.m_20189_() - target.m_20189_());
        }
    }

    @Override
    public void tickMovement() {
        Vec3 motion;
        if (!this.m_9236_().m_5776_()) {
            if (this.target == null || !this.target.m_6084_() || this.m_19749_() == null || !this.m_19749_().m_6084_()) {
                if (this.getImpactExplosionSoundEvent() != null) {
                    this.m_5496_(this.getImpactExplosionSoundEvent(), 1.0f, 1.0f);
                }
                this.m_146870_();
            } else if (this.ticksInAir > this.getLifeSpan()) {
                if (this.target != null && this.target.m_6084_()) {
                    EntityUtil.summonLightningFromProjectile(this);
                }
                if (this.getImpactExplosionSoundEvent() != null) {
                    this.m_5496_(this.getImpactExplosionSoundEvent(), 1.0f, 1.0f);
                }
            } else {
                motion = this.m_20184_().m_82490_(0.9);
                Vec3 targetMotion = new Vec3(this.target.m_20185_() - this.m_20185_(), this.target.m_20188_() - 0.1 - this.m_20186_(), this.target.m_20189_() - this.m_20189_()).m_82541_();
                this.m_20256_(motion.m_82549_(targetMotion.m_82490_(0.02)));
            }
        }
        this.m_20101_();
        motion = this.m_20184_();
        this.m_6034_(this.m_20185_() + motion.m_7096_(), this.m_20186_() + motion.m_7098_(), this.m_20189_() + motion.m_7094_());
    }

    public boolean m_6469_(DamageSource source, float pAmount) {
        Level level;
        if (!this.m_9236_().m_5776_() && source.m_7270_() != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 0.2, 0.2, 0.2, 0.0);
            this.knockback(0.15 + (double)(pAmount / 8.0f), this.m_20182_().m_82546_(source.m_7270_()));
        }
        this.ticksInAir = (int)((float)this.ticksInAir + pAmount * 10.0f);
        return true;
    }

    public void knockback(double strength, Vec3 target) {
        this.f_19812_ = true;
        Vec3 vec3 = this.m_20184_();
        Vec3 vec31 = target.m_82541_().m_82490_(strength);
        this.m_20334_(vec3.m_7096_() / 2.0 + vec31.m_7096_(), vec3.m_7098_() / 2.0 + vec31.m_7098_(), vec3.m_7094_() / 2.0 + vec31.m_7094_());
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }

    @Override
    protected ParticleOptions getExplosionParticle() {
        return (ParticleOptions)AetherParticleTypes.FROZEN.get();
    }

    @Override
    @Nullable
    protected SoundEvent getImpactExplosionSoundEvent() {
        return (SoundEvent)AetherSoundEvents.ENTITY_THUNDER_CRYSTAL_EXPLODE.get();
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.target != null) {
            tag.m_128405_("Target", this.target.m_19879_());
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("Target")) {
            this.target = this.m_9236_().m_6815_(tag.m_128451_("Target"));
        }
    }
}

