/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.serverbound;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.command.SunAltarWhitelist;
import com.aetherteam.nitrogen.network.BasePacket;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public record SunAltarUpdatePacket(long dayTime) implements BasePacket
{
    public void encode(FriendlyByteBuf buf) {
        buf.writeLong(this.dayTime());
    }

    public static SunAltarUpdatePacket decode(FriendlyByteBuf buf) {
        long dayTime = buf.readLong();
        return new SunAltarUpdatePacket(dayTime);
    }

    public void execute(@Nullable Player playerEntity) {
        Level level;
        if (playerEntity != null && (level = playerEntity.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (!((Boolean)AetherConfig.SERVER.sun_altar_whitelist.get()).booleanValue() || playerEntity.m_20310_(4) || SunAltarWhitelist.INSTANCE.isWhiteListed(playerEntity.m_36316_())) {
                long dayBase = level2.m_46468_() / 72000L;
                long dayTime = dayBase * 72000L + this.dayTime();
                level2.m_8615_(dayTime);
                level2.m_7654_().m_6846_().m_11270_((Packet)new ClientboundSetTimePacket(level2.m_46467_(), level2.m_46468_(), level2.m_46469_().m_46207_(GameRules.f_46140_)), level2.m_46472_());
            }
        }
    }
}

