/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.blocks;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Cached;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.control.code.Function;
import mcjty.rftoolsbase.api.control.code.ICompiledOpcode;
import mcjty.rftoolsbase.api.control.code.IOpcodeRunnable;
import mcjty.rftoolsbase.api.control.machines.IProcessor;
import mcjty.rftoolsbase.api.control.machines.IProgram;
import mcjty.rftoolsbase.api.control.parameters.BlockSide;
import mcjty.rftoolsbase.api.control.parameters.IParameter;
import mcjty.rftoolsbase.api.control.parameters.Inventory;
import mcjty.rftoolsbase.api.control.parameters.Parameter;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolsbase.api.control.parameters.Tuple;
import mcjty.rftoolsbase.api.machineinfo.CapabilityMachineInformation;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsbase.modules.crafting.items.CraftingCardItem;
import mcjty.rftoolsbase.modules.filter.items.FilterModuleItem;
import mcjty.rftoolscontrol.compat.RFToolsStuff;
import mcjty.rftoolscontrol.modules.craftingstation.blocks.CraftingStationTileEntity;
import mcjty.rftoolscontrol.modules.multitank.blocks.MultiTankTileEntity;
import mcjty.rftoolscontrol.modules.multitank.util.MultiTankFluidProperties;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorContainer;
import mcjty.rftoolscontrol.modules.processor.client.GuiProcessor;
import mcjty.rftoolscontrol.modules.processor.items.CPUCoreItem;
import mcjty.rftoolscontrol.modules.processor.items.GraphicsCardItem;
import mcjty.rftoolscontrol.modules.processor.items.NetworkCardItem;
import mcjty.rftoolscontrol.modules.processor.items.NetworkIdentifierItem;
import mcjty.rftoolscontrol.modules.processor.items.RAMChipItem;
import mcjty.rftoolscontrol.modules.processor.logic.LogicInventoryTools;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterSerializer;
import mcjty.rftoolscontrol.modules.processor.logic.ParameterTools;
import mcjty.rftoolscontrol.modules.processor.logic.TypeConverters;
import mcjty.rftoolscontrol.modules.processor.logic.compiled.CompiledCard;
import mcjty.rftoolscontrol.modules.processor.logic.compiled.CompiledEvent;
import mcjty.rftoolscontrol.modules.processor.logic.compiled.CompiledOpcode;
import mcjty.rftoolscontrol.modules.processor.logic.grid.ProgramCardInstance;
import mcjty.rftoolscontrol.modules.processor.logic.registry.InventoryUtil;
import mcjty.rftoolscontrol.modules.processor.logic.registry.Opcodes;
import mcjty.rftoolscontrol.modules.processor.logic.running.CpuCore;
import mcjty.rftoolscontrol.modules.processor.logic.running.ExceptionType;
import mcjty.rftoolscontrol.modules.processor.logic.running.ProgException;
import mcjty.rftoolscontrol.modules.processor.logic.running.RunningProgram;
import mcjty.rftoolscontrol.modules.processor.network.PacketGetFluids;
import mcjty.rftoolscontrol.modules.processor.util.CardInfo;
import mcjty.rftoolscontrol.modules.processor.util.Commands;
import mcjty.rftoolscontrol.modules.processor.util.QueuedEvent;
import mcjty.rftoolscontrol.modules.processor.util.WaitForItem;
import mcjty.rftoolscontrol.modules.processor.util.WatchInfo;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOp;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpBox;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpLine;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpText;
import mcjty.rftoolscontrol.modules.various.VariousModule;
import mcjty.rftoolscontrol.modules.various.blocks.NodeTileEntity;
import mcjty.rftoolscontrol.modules.various.blocks.WorkbenchTileEntity;
import mcjty.rftoolscontrol.modules.various.items.TokenItem;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ProcessorTileEntity
extends TickingTileEntity
implements IProcessor {
    public static final int CARD_SLOTS = 6;
    public static final int ITEM_SLOTS = 24;
    public static final int EXPANSION_SLOTS = 16;
    public static final int MAXVARS = 32;
    public static final int MAXFLUIDVARS = 24;
    private static final BiFunction<ParameterType, Object, ItemStack> CONVERTOR_ITEM = TypeConverters::convertToItem;
    private static final BiFunction<ParameterType, Object, FluidStack> CONVERTOR_FLUID = TypeConverters::convertToFluid;
    private static final BiFunction<ParameterType, Object, BlockSide> CONVERTOR_SIDE = TypeConverters::convertToSide;
    private static final BiFunction<ParameterType, Object, Inventory> CONVERTOR_INVENTORY = TypeConverters::convertToInventory;
    private static final BiFunction<ParameterType, Object, Tuple> CONVERTOR_TUPLE = TypeConverters::convertToTuple;
    private static final BiFunction<ParameterType, Object, List<Parameter>> CONVERTOR_VECTOR = TypeConverters::convertToVector;
    private static final BiFunction<ParameterType, Object, Integer> CONVERTOR_INTEGER = TypeConverters::convertToInteger;
    private static final BiFunction<ParameterType, Object, Long> CONVERTOR_LONG = TypeConverters::convertToLong;
    private static final BiFunction<ParameterType, Object, String> CONVERTOR_STRING = TypeConverters::convertToString;
    private static final BiFunction<ParameterType, Object, Boolean> CONVERTOR_BOOL = TypeConverters::convertToBool;
    private static final BiFunction<ParameterType, Object, Number> CONVERTOR_NUMBER = TypeConverters::convertToNumber;
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, ProcessorContainer.CONTAINER_FACTORY).itemValid((slot, stack) -> {
        if (this.isExpansionSlot((int)slot)) {
            return this.isValidExpansionItem(stack.m_41720_());
        }
        if (this.isCardSlot((int)slot)) {
            return stack.m_41720_() == VariousModule.PROGRAM_CARD.get();
        }
        return true;
    }).onUpdate((slot, stack) -> this.onUpdateCard((int)slot)).build();
    @Cap(type=CapType.ENERGY)
    private final GenericEnergyStorage energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)((Integer)Config.processorMaxenergy.get()).intValue(), (long)((Integer)Config.processorReceivepertick.get()).intValue());
    @Cap(type=CapType.CONTAINER)
    private final Lazy<MenuProvider> screenHandler = Lazy.of(() -> new DefaultContainerProvider("Processor").containerSupplier((windowId, player) -> ProcessorContainer.create(windowId, this.m_58899_(), (GenericTileEntity)this, player)).itemHandler(() -> this.items).energyHandler(() -> this.energyStorage).setupSync((GenericTileEntity)this));
    private final List<CpuCore> cpuCores = new ArrayList<CpuCore>();
    public static final int HUD_OFF = 0;
    public static final int HUD_LOG = 1;
    public static final int HUD_DB = 2;
    public static final int HUD_GFX = 3;
    @GuiValue
    private int showHud = 0;
    private boolean cardsDirty = true;
    private boolean coresDirty = true;
    private int maxVars = -1;
    private int hasNetworkCard = -1;
    private int storageCard = -2;
    private boolean hasGraphicsCard = false;
    private final Cached<List<Predicate<ItemStack>>> filterCaches = Cached.of(this::getFilterCaches);
    private final Map<String, GfxOp> gfxOps = new HashMap<String, GfxOp>();
    private List<String> orderedOps = null;
    private final List<GfxOp> clientGfxOps = new ArrayList<GfxOp>();
    @GuiValue
    private boolean exclusive = false;
    private String lastException = null;
    private long lastExceptionTime = 0L;
    private String channel = "";
    private final Map<String, BlockPos> networkNodes = new HashMap<String, BlockPos>();
    private final Set<BlockPos> craftingStations = new HashSet<BlockPos>();
    private int prevIn = 0;
    private final int[] powerOut = new int[]{0, 0, 0, 0, 0, 0};
    private int tickCount = 0;
    private final Parameter[] variables = new Parameter[32];
    private final WatchInfo[] watchInfos = new WatchInfo[32];
    private int fluidSlotsAvailable = -1;
    private final CardInfo[] cardInfo = new CardInfo[6];
    private Queue<QueuedEvent> eventQueue = new ArrayDeque<QueuedEvent>();
    private final List<WaitForItem> waitingForItems = new ArrayList<WaitForItem>();
    private final Queue<String> logMessages = new ArrayDeque<String>();
    public long clientTime = 0L;
    private List<String> clientLog = new ArrayList<String>();
    private List<String> clientDebugLog = new ArrayList<String>();
    private Set<Pair<Integer, Integer>> runningEvents = new HashSet<Pair<Integer, Integer>>();
    private final Set<String> locks = new HashSet<String>();
    private ResourceKey<Level> dummyType = null;
    public static final Key<Integer> PARAM_CARD = new Key("card", Type.INTEGER);
    public static final Key<Integer> PARAM_ITEMS = new Key("items", Type.INTEGER);
    public static final Key<Integer> PARAM_VARS = new Key("vars", Type.INTEGER);
    public static final Key<Integer> PARAM_FLUID = new Key("fluids", Type.INTEGER);
    public static final Key<String> PARAM_CMD = new Key("cmd", Type.STRING);
    public static final Key<Boolean> PARAM_EXCLUSIVE = new Key("exclusive", Type.BOOLEAN);
    public static final Key<Integer> PARAM_HUDMODE = new Key("hudmode", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_ALLOCATE = Command.create((String)"allocate", (te, player, params) -> {
        int card = (Integer)params.get(PARAM_CARD);
        int itemAlloc = (Integer)params.get(PARAM_ITEMS);
        int varAlloc = (Integer)params.get(PARAM_VARS);
        int fluidAlloc = (Integer)params.get(PARAM_FLUID);
        te.allocate(card, itemAlloc, varAlloc, fluidAlloc);
    });
    @ServerCommand
    public static final Command<?> CMD_EXECUTE = Command.create((String)"execute", (te, player, params) -> Commands.executeCommand(te, (String)params.get(PARAM_CMD)));
    @ServerCommand
    public static final Command<?> CMD_SETEXCLUSIVE = Command.create((String)"setExclusive", (te, player, params) -> te.setExclusive((Boolean)params.get(PARAM_EXCLUSIVE)));
    @ServerCommand
    public static final Command<?> CMD_SETHUDMODE = Command.create((String)"setHudMode", (te, player, params) -> te.setShowHud((Integer)params.get(PARAM_HUDMODE)));
    @ServerCommand(type=String.class)
    public static final ListCommand<?, ?> CMD_GETDEBUGLOG = ListCommand.create((String)"rftoolscontrol.processor.getDebugLog", (te, player, params) -> te.getDebugLog(), (te, player, params, list) -> {
        te.clientDebugLog = list;
    });
    @ServerCommand(type=String.class)
    public static final ListCommand<?, ?> CMD_GETLOG = ListCommand.create((String)"rftoolscontrol.processor.getLog", (te, player, params) -> te.getLog(), (te, player, params, list) -> {
        te.clientLog = list;
    });
    @ServerCommand(type=Parameter.class, serializer=ParameterSerializer.class)
    public static final ListCommand<?, ?> CMD_GETVARS = ListCommand.create((String)"rftoolscontrol.processor.getVars", (te, player, params) -> te.getVariables(), (te, player, params, list) -> GuiProcessor.storeVarsForClient(list));
    @ServerCommand(type=PacketGetFluids.FluidEntry.class, serializer=PacketGetFluids.FluidEntry.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETFLUIDS = ListCommand.create((String)"rftoolscontrol.processor.getFluids", (te, player, params) -> te.getFluids(), (te, player, params, list) -> GuiProcessor.storeFluidsForClient(list));

    public ProcessorTileEntity(BlockPos pos, BlockState state) {
        super(ProcessorModule.TYPE_PROCESSOR.get(), pos, state);
        int i;
        for (i = 0; i < this.cardInfo.length; ++i) {
            this.cardInfo[i] = new CardInfo();
        }
        for (i = 0; i < 32; ++i) {
            this.variables[i] = null;
            this.watchInfos[i] = null;
        }
        this.fluidSlotsAvailable = -1;
    }

    public ProcessorTileEntity(ResourceKey<Level> type, BlockPos pos) {
        this(pos, null);
        this.dummyType = type;
    }

    public boolean isDummy() {
        return this.dummyType != null;
    }

    public ResourceKey<Level> getDimension() {
        if (this.dummyType != null) {
            return this.dummyType;
        }
        return super.getDimension();
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
        this.m_6596_();
    }

    public Parameter getParameter(int idx) {
        return this.variables[idx];
    }

    public boolean isFluidSlotAvailable(int idx) {
        int sideIndex = idx / 4;
        return (this.getFluidSlotsAvailable() & 1 << sideIndex) != 0;
    }

    private BlockPos getAdjacentPosition(@Nonnull BlockSide side) {
        BlockPos p;
        if (side.getNodeName() != null && !side.getNodeName().isEmpty()) {
            p = this.networkNodes.get(side.getNodeName());
            if (p == null) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNODE);
            }
            BlockEntity te = this.f_58857_.m_7702_(p);
            if (!(te instanceof NodeTileEntity)) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNODE);
            }
        } else {
            p = this.f_58858_;
        }
        return p;
    }

    public int readRedstoneIn(@Nonnull BlockSide side) {
        Direction facing = side.getSide();
        BlockPos p = this.getAdjacentPosition(side);
        if (p == null) {
            return 0;
        }
        return this.f_58857_.m_277185_(p.m_121945_(facing), facing);
    }

    public void setPowerOut(@Nonnull BlockSide side, int amount) {
        Direction facing = side.getSide();
        BlockPos p = this.getAdjacentPosition(side);
        if (p == null) {
            return;
        }
        if (amount < 0) {
            amount = 0;
        } else if (amount > 15) {
            amount = 15;
        }
        if (p.equals((Object)this.f_58858_)) {
            this.powerOut[facing.ordinal()] = amount;
            this.m_6596_();
            this.f_58857_.m_46586_(this.f_58858_.m_121945_(facing), this.m_58900_().m_60734_(), this.f_58858_);
        } else {
            NodeTileEntity te = (NodeTileEntity)this.f_58857_.m_7702_(p);
            te.setPowerOut(facing, amount);
        }
    }

    public int getPowerOut(Direction side) {
        return this.powerOut[side.ordinal()];
    }

    public void tickServer() {
        this.process();
        this.prevIn = this.powerLevel;
    }

    private void process() {
        ++this.tickCount;
        this.m_6596_();
        this.updateCores();
        this.compileCards();
        this.processEventQueue();
        try {
            this.handleEvents();
        }
        catch (ProgException e) {
            this.exception(e.getExceptionType(), null);
        }
        this.run();
    }

    private void processEventQueue() {
        QueuedEvent queuedEvent = this.eventQueue.peek();
        if (queuedEvent != null) {
            CompiledEvent compiledEvent = queuedEvent.compiledEvent();
            if (compiledEvent.single() && this.runningEvents.contains(Pair.of((Object)queuedEvent.cardIndex(), (Object)compiledEvent.index()))) {
                return;
            }
            CpuCore core = this.findAvailableCore(queuedEvent.cardIndex());
            if (core != null) {
                this.eventQueue.remove();
                RunningProgram program = new RunningProgram(queuedEvent.cardIndex());
                program.startFromEvent(compiledEvent);
                program.setCraftTicket(queuedEvent.ticket());
                program.setLastValue((IParameter)queuedEvent.parameter());
                core.startProgram(program);
                if (compiledEvent.single()) {
                    this.runningEvents.add((Pair<Integer, Integer>)Pair.of((Object)queuedEvent.cardIndex(), (Object)compiledEvent.index()));
                }
            }
        }
    }

    public void getCraftableItems(List<ItemStack> stacks) {
        try {
            for (CardInfo info : this.cardInfo) {
                CompiledCard compiledCard = info.getCompiledCard();
                if (compiledCard == null) continue;
                for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_CRAFT)) {
                    int index = event.index();
                    CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                    ItemStack stack = this.evaluateItemParameter(compiledOpcode, null, 0);
                    Inventory inv = this.evaluateInventoryParameter(compiledOpcode, null, 1);
                    if (!stack.m_41619_() && inv != null) {
                        throw new ProgException(ExceptionType.EXCEPT_BADPARAMETERS);
                    }
                    if (stack.m_41619_() && inv == null) {
                        throw new ProgException(ExceptionType.EXCEPT_BADPARAMETERS);
                    }
                    if (!stack.m_41619_()) {
                        stacks.add(stack);
                        continue;
                    }
                    this.getItemHandlerAt(inv).ifPresent(handler -> {
                        for (int i = 0; i < handler.getSlots(); ++i) {
                            ItemStack result;
                            ItemStack s = handler.getStackInSlot(i);
                            if (s.m_41619_() || s.m_41720_() != RFToolsStuff.CRAFTING_CARD.get() || (result = CraftingCardItem.getResult((ItemStack)s)).m_41619_()) continue;
                            stacks.add(result);
                        }
                    });
                }
            }
        }
        catch (ProgException e) {
            this.exception(e.getExceptionType(), null);
        }
    }

    public void craftOk(IProgram program, @Nullable Integer slot) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        String ticket = program.getCraftTicket();
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        Integer realSlot = info.getRealSlot(slot);
        ItemStack craftedItem = ItemStack.f_41583_;
        if (realSlot != null) {
            craftedItem = this.items.getStackInSlot(realSlot.intValue());
        }
        for (BlockPos p : this.craftingStations) {
            BlockEntity te = this.f_58857_.m_7702_(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            craftedItem = craftingStation.craftOk(this, ticket, craftedItem);
        }
        if (realSlot != null) {
            this.items.setStackInSlot(realSlot.intValue(), craftedItem);
        }
    }

    public void craftFail(IProgram program) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        String ticket = program.getCraftTicket();
        for (BlockPos p : this.craftingStations) {
            BlockEntity te = this.f_58857_.m_7702_(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            craftingStation.craftFail(ticket);
        }
    }

    public boolean pushItemsWorkbench(IProgram program, @Nonnull BlockSide workbench, ItemStack item, int slot1, int slot2) {
        if (item.m_41619_()) {
            item = this.getCraftResult(program);
        }
        if (item.m_41619_()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        BlockEntity te = this.getTileEntityAt(workbench);
        if (!(te instanceof WorkbenchTileEntity)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTAWORKBENCH);
        }
        ItemStack finalItem = item;
        ItemStack card = this.getItemHandlerAt(te, Direction.EAST).map(handler -> this.findCraftingCard((IItemHandler)handler, finalItem)).orElse(ItemStack.f_41583_);
        if (card.m_41619_()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
        }
        if (!CraftingCardItem.fitsGrid((ItemStack)card)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTAGRID);
        }
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        GenericItemHandler itemHandler = this.items;
        return this.getItemHandlerAt(te, Direction.UP).map(arg_0 -> ProcessorTileEntity.lambda$pushItemsWorkbench$8(card, slot1, slot2, info, (IItemHandler)itemHandler, arg_0)).orElse(false);
    }

    public int pushItemsMulti(IProgram program, @Nullable Inventory inv, int slot1, int slot2, @Nullable Integer extSlot) {
        IItemHandler handler = this.getHandlerForInv(inv);
        IStorageScanner scanner = this.getScannerForInv(inv);
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int e = 0;
        if (extSlot != null) {
            e = extSlot;
        }
        int failed = 0;
        for (int slot = slot1; slot <= slot2; ++slot) {
            int realSlot = info.getRealSlot(slot);
            ItemStack stack = this.items.getStackInSlot(realSlot);
            if (!stack.m_41619_()) {
                ItemStack remaining = LogicInventoryTools.insertItem(handler, scanner, stack, extSlot == null ? null : Integer.valueOf(e));
                if (!remaining.m_41619_()) {
                    ++failed;
                }
                this.items.setStackInSlot(realSlot, remaining);
            }
            ++e;
        }
        return failed;
    }

    public int countCardIngredients(IProgram program, @Nullable Inventory inv, ItemStack card) {
        IItemHandler handler = this.getHandlerForInv(inv);
        IStorageScanner scanner = this.getScannerForInv(inv);
        List ingredients = CraftingCardItem.getIngredients((ItemStack)card);
        List<Ingredient> needed = this.combineIngredients(ingredients);
        return this.countPossibleCrafts(scanner, handler, needed);
    }

    public boolean checkIngredients(IProgram program, @Nonnull Inventory cardInv, ItemStack item, int slot1, int slot2) {
        if (item.m_41619_()) {
            item = this.getCraftResult(program);
        }
        if (item.m_41619_()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        ItemStack finalItem = item;
        ItemStack card = this.getItemHandlerAt(cardInv).map(cardHandler -> this.findCraftingCard((IItemHandler)cardHandler, finalItem)).orElse(ItemStack.f_41583_);
        if (card.m_41619_()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
        }
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int slot = slot1;
        List ingredients = CraftingCardItem.fitsGrid((ItemStack)card) && slot2 - slot1 >= 8 ? CraftingCardItem.getIngredientsGrid((ItemStack)card) : CraftingCardItem.getIngredients((ItemStack)card);
        boolean failed = false;
        for (Ingredient ingredient : ingredients) {
            int realSlot = info.getRealSlot(slot);
            ItemStack localStack = this.items.getStackInSlot(realSlot);
            if (ingredient != Ingredient.f_43901_) {
                if (!ingredient.test(localStack)) {
                    return false;
                }
                if (LogicInventoryTools.getCountFromIngredient(ingredient) != localStack.m_41613_()) {
                    return false;
                }
            } else if (!localStack.m_41619_()) {
                return false;
            }
            ++slot;
        }
        return true;
    }

    public int getIngredientsSmart(IProgram program, Inventory inv, @Nonnull Inventory cardInv, ItemStack inputStack, int slot1, int slot2, @Nonnull Inventory destInv) {
        IItemHandler handler = this.getHandlerForInv(inv);
        IStorageScanner scanner = this.getScannerForInv(inv);
        ItemStack item = inputStack;
        if (item.m_41619_()) {
            item = this.getCraftResult(program);
        }
        if (item.m_41619_()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        ItemStack finalItem = item;
        IItemHandler destHandler = this.getHandlerForInv(destInv);
        if (destHandler == null) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDINVENTORY);
        }
        ItemStack card = this.getItemHandlerAt(cardInv).map(cardHandler -> this.findCraftingCard((IItemHandler)cardHandler, finalItem)).orElse(ItemStack.f_41583_);
        if (card.m_41619_()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
        }
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        List ingredients = CraftingCardItem.fitsGrid((ItemStack)card) && slot2 - slot1 >= 8 ? CraftingCardItem.getIngredientsGrid((ItemStack)card) : CraftingCardItem.getIngredients((ItemStack)card);
        List<Ingredient> needed = this.combineIngredients(ingredients);
        int requested = this.checkAvailableItemsAndRequestMissing(destInv, scanner, handler, needed);
        if (requested != 0) {
            return requested;
        }
        int slot = slot1;
        for (Ingredient ingredient : ingredients) {
            ItemStack stack;
            int realSlot = info.getRealSlot(slot);
            if (ingredient != Ingredient.f_43901_ && !(stack = LogicInventoryTools.extractItem(handler, scanner, LogicInventoryTools.getCountFromIngredient(ingredient), true, ingredient, null)).m_41619_()) {
                this.items.insertItem(realSlot, stack, false);
            }
            ++slot;
        }
        return 0;
    }

    private int checkAvailableItemsAndRequestMissing(Inventory destInv, IStorageScanner scanner, IItemHandler handler, List<Ingredient> needed) {
        int requested = 0;
        for (Ingredient ingredient : needed) {
            int countFromIngredient;
            int cnt;
            if (ingredient == Ingredient.f_43901_ || (cnt = LogicInventoryTools.countItem(handler, scanner, ingredient, countFromIngredient = LogicInventoryTools.getCountFromIngredient(ingredient))) >= countFromIngredient) continue;
            ++requested;
            if (this.isRequested(ingredient) || this.requestCraft(ingredient, destInv)) continue;
            return -1;
        }
        return requested;
    }

    private int countPossibleCrafts(IStorageScanner scanner, IItemHandler handler, List<Ingredient> needed) {
        int maxPossible = Integer.MAX_VALUE;
        for (Ingredient ingredient : needed) {
            int cnt;
            int possible;
            if (ingredient == Ingredient.f_43901_ || (possible = (cnt = LogicInventoryTools.countItem(handler, scanner, ingredient, -1)) / LogicInventoryTools.getCountFromIngredient(ingredient)) >= maxPossible) continue;
            maxPossible = possible;
        }
        return maxPossible;
    }

    private List<Ingredient> combineIngredients(List<Ingredient> ingredients) {
        ArrayList<Ingredient> needed = new ArrayList<Ingredient>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient.m_43947_()) continue;
            boolean found = false;
            for (int i = 0; i < needed.size(); ++i) {
                Ingredient neededStack = (Ingredient)needed.get(i);
                if (!this.testIngredientEquality(ingredient, neededStack)) continue;
                needed.set(i, this.combine(ingredient, neededStack));
                found = true;
                break;
            }
            if (found) continue;
            needed.add(ingredient);
        }
        return needed;
    }

    private boolean testIngredientEquality(Ingredient i1, Ingredient i2) {
        ItemStack[] items2;
        ItemStack[] items1;
        if (i1.isSimple() && i2.isSimple() && (items1 = i1.m_43908_()).length == (items2 = i2.m_43908_()).length) {
            for (int i = 0; i < items1.length; ++i) {
                if (ItemHandlerHelper.canItemStacksStack((ItemStack)items1[i], (ItemStack)items2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Ingredient combine(Ingredient i1, Ingredient i2) {
        ItemStack[] items2;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack[] items1 = i1.m_43908_();
        if (items1.length == (items2 = i2.m_43908_()).length) {
            for (int i = 0; i < items1.length; ++i) {
                ItemStack copy = items1[i].m_41777_();
                copy.m_41769_(items2[i].m_41613_());
                list.add(copy);
            }
        }
        return Ingredient.m_43927_((ItemStack[])list.toArray(new ItemStack[list.size()]));
    }

    public int getIngredients(IProgram program, Inventory inv, Inventory cardInv, ItemStack inputStack, int slot1, int slot2) {
        IItemHandler handler = this.getHandlerForInv(inv);
        IStorageScanner scanner = this.getScannerForInv(inv);
        ItemStack item = inputStack;
        if (item.m_41619_()) {
            item = this.getCraftResult(program);
        }
        if (item.m_41619_()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        ItemStack finalItem = item;
        ItemStack card = this.getItemHandlerAt(cardInv).map(cardHandler -> this.findCraftingCard((IItemHandler)cardHandler, finalItem)).orElse(ItemStack.f_41583_);
        if (card.m_41619_()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
        }
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int slot = slot1;
        List ingredients = CraftingCardItem.fitsGrid((ItemStack)card) && slot2 - slot1 >= 8 ? CraftingCardItem.getIngredientsGrid((ItemStack)card) : CraftingCardItem.getIngredients((ItemStack)card);
        int failed = 0;
        for (Ingredient ingredient : ingredients) {
            int realSlot = info.getRealSlot(slot);
            if (ingredient != Ingredient.f_43901_) {
                ItemStack stack = LogicInventoryTools.extractItem(handler, scanner, LogicInventoryTools.getCountFromIngredient(ingredient), true, ingredient, null);
                if (!stack.m_41619_()) {
                    ItemStack remainder = this.items.insertItem(realSlot, stack, false);
                    if (!remainder.m_41619_()) {
                        LogicInventoryTools.insertItem(handler, scanner, remainder, null);
                    }
                } else {
                    ++failed;
                }
            }
            ++slot;
        }
        return failed;
    }

    public void craftWait(IProgram program, @Nonnull Inventory inv, ItemStack stack) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        if (stack.m_41619_() && (stack = this.getCraftResult(program)).m_41619_()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        WaitForItem waitForItem = new WaitForItem(program.getCraftTicket(), stack, inv);
        this.waitingForItems.add(waitForItem);
        this.m_6596_();
    }

    public void craftWaitTimed(IProgram program) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        WaitForItem waitForItem = new WaitForItem(program.getCraftTicket(), ItemStack.f_41583_, null);
        this.waitingForItems.add(waitForItem);
        this.m_6596_();
    }

    public boolean isRequested(Ingredient ingredient) {
        for (BlockPos p : this.craftingStations) {
            BlockEntity te = this.f_58857_.m_7702_(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            return craftingStation.isRequested(ingredient);
        }
        throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGSTATION);
    }

    public boolean requestCraft(@Nonnull Ingredient ingredient, @Nullable Inventory inventory) {
        for (BlockPos p : this.craftingStations) {
            BlockEntity te = this.f_58857_.m_7702_(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            return craftingStation.request(ingredient, inventory);
        }
        throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGSTATION);
    }

    public void setCraftTicket(IProgram program, String ticket) {
        ((RunningProgram)program).setCraftTicket(ticket);
    }

    public ItemStack getItemFromCard(IProgram program) {
        Parameter lastValue = (Parameter)program.getLastValue();
        if (lastValue == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGLASTVALUE);
        }
        ItemStack itemStack = TypeConverters.convertToItem((IParameter)lastValue);
        if (itemStack.m_41619_()) {
            throw new ProgException(ExceptionType.EXCEPT_NOTANITEM);
        }
        if (itemStack.m_41720_() instanceof CraftingCardItem) {
            return CraftingCardItem.getResult((ItemStack)itemStack);
        }
        if (itemStack.m_41720_() instanceof TokenItem && itemStack.m_41782_()) {
            CompoundTag tag = itemStack.m_41783_().m_128469_("parameter");
            if (tag.m_128456_()) {
                return ItemStack.f_41583_;
            }
            Parameter parameter = ParameterTools.readFromNBT(tag);
            if (parameter == null || !parameter.isSet()) {
                return ItemStack.f_41583_;
            }
            return TypeConverters.convertToItem((IParameter)parameter);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getCraftResult(IProgram program) {
        if (!program.hasCraftTicket()) {
            return ItemStack.f_41583_;
        }
        for (BlockPos p : this.craftingStations) {
            CraftingStationTileEntity craftingStation;
            ItemStack stack;
            BlockEntity te = this.f_58857_.m_7702_(p);
            if (!(te instanceof CraftingStationTileEntity) || (stack = (craftingStation = (CraftingStationTileEntity)te).getCraftResult(program.getCraftTicket())).m_41619_()) continue;
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack findCraftingCard(IProgram program, Inventory inventory, ItemStack stack) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        IItemHandler handler = this.getHandlerForInv(inventory);
        if (handler == null) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDINVENTORY);
        }
        return this.findCraftingCard(handler, stack);
    }

    private ItemStack findCraftingCard(IItemHandler handler, ItemStack craftResult) {
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack result;
            ItemStack s = handler.getStackInSlot(j);
            if (s.m_41619_() || s.m_41720_() != RFToolsStuff.CRAFTING_CARD.get() || (result = CraftingCardItem.getResult((ItemStack)s)).m_41619_() || !LogicInventoryTools.areItemsEqual(result, craftResult, true, true)) continue;
            return s;
        }
        return ItemStack.f_41583_;
    }

    public void fireCraftEvent(String ticket, ItemStack stackToCraft) {
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_CRAFT)) {
                ItemStack craftingCard;
                int index = event.index();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                ItemStack stack = this.evaluateItemParameter(compiledOpcode, null, 0);
                Inventory inv = this.evaluateInventoryParameter(compiledOpcode, null, 1);
                if (!stack.m_41619_()) {
                    if (!ItemStack.m_41656_((ItemStack)stack, (ItemStack)stackToCraft)) continue;
                    this.runOrQueueEvent(i, event, ticket, null);
                    return;
                }
                if (inv == null || (craftingCard = this.getItemHandlerAt(inv).map(handler -> this.findCraftingCard((IItemHandler)handler, stackToCraft)).orElse(ItemStack.f_41583_)).m_41619_()) continue;
                this.runOrQueueEvent(i, event, ticket, null);
                return;
            }
        }
    }

    private void handleEvents() {
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            this.handleEventsRedstoneOn(i, compiledCard);
            this.handleEventsRedstoneOff(i, compiledCard);
            this.handleEventsTimer(i, compiledCard);
            this.handleEventsCraftResume(i, compiledCard);
        }
    }

    private void handleEventsCraftResume(int cardIndex, CompiledCard compiledCard) {
        for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_CRAFTRESUME)) {
            int index = event.index();
            CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
            int ticks = this.evaluateIntParameter(compiledOpcode, null, 0);
            if (ticks <= 0 || this.tickCount % ticks != 0 || this.waitingForItems.isEmpty()) continue;
            WaitForItem found = null;
            int foundIdx = -1;
            for (int i = 0; i < this.waitingForItems.size(); ++i) {
                WaitForItem wfi = this.waitingForItems.get(i);
                if (wfi.inventory() == null || wfi.itemStack().m_41619_()) {
                    foundIdx = i;
                    found = wfi;
                    break;
                }
                int cnt = this.getItemHandlerAt(wfi.inventory()).map(handler -> this.countItemInHandler(wfi.itemStack(), (IItemHandler)handler)).orElse(0);
                if (cnt < wfi.itemStack().m_41613_()) continue;
                foundIdx = i;
                found = wfi;
                break;
            }
            if (found == null) continue;
            this.waitingForItems.remove(foundIdx);
            this.runOrQueueEvent(cardIndex, event, found.ticket(), null);
        }
    }

    private void handleEventsTimer(int i, CompiledCard compiledCard) {
        for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_TIMER)) {
            int index = event.index();
            CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
            int ticks = this.evaluateIntParameter(compiledOpcode, null, 0);
            if (ticks <= 0 || this.tickCount % ticks != 0) continue;
            this.runOrDropEvent(i, event, null, null);
        }
    }

    private void handleEventsRedstoneOff(int i, CompiledCard compiledCard) {
        int redstoneOffMask = this.prevIn & ~this.powerLevel;
        if (redstoneOffMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_OFF)) {
                Direction facing;
                int index = event.index();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = this.evaluateSideParameter(compiledOpcode, null, 0);
                if (side != null && side.hasNodeName()) continue;
                Direction direction = facing = side == null ? null : side.getSide();
                if (facing != null && (redstoneOffMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null, null);
            }
        }
    }

    private void handleEventsRedstoneOn(int i, CompiledCard compiledCard) {
        int redstoneOnMask = this.powerLevel & ~this.prevIn;
        if (redstoneOnMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_ON)) {
                Direction facing;
                int index = event.index();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = this.evaluateSideParameter(compiledOpcode, null, 0);
                if (side != null && side.hasNodeName()) continue;
                Direction direction = facing = side == null ? null : side.getSide();
                if (facing != null && (redstoneOnMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null, null);
            }
        }
    }

    private void handleEventsRedstoneOff(int i, CompiledCard compiledCard, String node, int prevMask, int newMask) {
        int redstoneOffMask = prevMask & ~newMask;
        if (redstoneOffMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_OFF)) {
                Direction facing;
                int index = event.index();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = this.evaluateSideParameter(compiledOpcode, null, 0);
                if (side == null || !node.equals(side.getNodeName()) || (facing = side.getSide()) != null && (redstoneOffMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null, null);
            }
        }
    }

    private void handleEventsRedstoneOn(int i, CompiledCard compiledCard, String node, int prevMask, int newMask) {
        int redstoneOnMask = newMask & ~prevMask;
        if (redstoneOnMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_ON)) {
                Direction facing;
                int index = event.index();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = this.evaluateSideParameter(compiledOpcode, null, 0);
                if (side == null || !node.equals(side.getNodeName()) || (facing = side.getSide()) != null && (redstoneOnMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null, null);
            }
        }
    }

    public void clearRunningEvent(int cardIndex, int eventIndex) {
        this.runningEvents.remove(Pair.of((Object)cardIndex, (Object)eventIndex));
    }

    private void runOrDropEvent(int cardIndex, CompiledEvent event, @Nullable String ticket, @Nullable Parameter parameter) {
        if (event.single() && this.runningEvents.contains(Pair.of((Object)cardIndex, (Object)event.index()))) {
            return;
        }
        CpuCore core = this.findAvailableCore(cardIndex);
        if (core == null) {
            for (QueuedEvent q : this.eventQueue) {
                if (q.cardIndex() != cardIndex || !q.compiledEvent().equals(event)) continue;
                return;
            }
            this.queueEvent(cardIndex, event, ticket, parameter);
        } else {
            RunningProgram program = new RunningProgram(cardIndex);
            program.startFromEvent(event);
            program.setCraftTicket(ticket);
            program.setLastValue((IParameter)parameter);
            core.startProgram(program);
            if (event.single()) {
                this.runningEvents.add((Pair<Integer, Integer>)Pair.of((Object)cardIndex, (Object)event.index()));
            }
        }
    }

    private void runOrQueueEvent(int cardIndex, CompiledEvent event, @Nullable String ticket, @Nullable Parameter parameter) {
        if (event.single() && this.runningEvents.contains(Pair.of((Object)cardIndex, (Object)event.index()))) {
            this.queueEvent(cardIndex, event, ticket, parameter);
            return;
        }
        CpuCore core = this.findAvailableCore(cardIndex);
        if (core == null) {
            this.queueEvent(cardIndex, event, ticket, parameter);
        } else {
            RunningProgram program = new RunningProgram(cardIndex);
            program.startFromEvent(event);
            program.setCraftTicket(ticket);
            program.setLastValue((IParameter)parameter);
            core.startProgram(program);
            if (event.single()) {
                this.runningEvents.add((Pair<Integer, Integer>)Pair.of((Object)cardIndex, (Object)event.index()));
            }
        }
    }

    private void queueEvent(int cardIndex, CompiledEvent event, @Nullable String ticket, @Nullable Parameter parameter) {
        if (this.eventQueue.size() >= (Integer)Config.maxEventQueueSize.get()) {
            throw new ProgException(ExceptionType.EXCEPT_TOOMANYEVENTS);
        }
        this.eventQueue.add(new QueuedEvent(cardIndex, event, ticket, parameter));
    }

    public int signal(String signal) {
        int cnt = 0;
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_SIGNAL)) {
                int index = event.index();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                String sig = this.evaluateStringParameter(compiledOpcode, null, 0);
                if (!signal.equals(sig)) continue;
                this.runOrQueueEvent(i, event, null, null);
                ++cnt;
            }
        }
        return cnt;
    }

    public int signal(Tuple location) {
        int cnt = 0;
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_GFX_SELECT)) {
                int index = event.index();
                this.runOrQueueEvent(i, event, null, Parameter.builder().type(ParameterType.PAR_TUPLE).value(ParameterValue.constant((Object)location)).build());
                ++cnt;
            }
        }
        return cnt;
    }

    public void receiveMessage(String name, @Nullable Parameter value) {
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_MESSAGE)) {
                int index = event.index();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                String messageName = this.evaluateStringParameter(compiledOpcode, null, 0);
                if (!name.equals(messageName)) continue;
                this.runOrQueueEvent(i, event, null, value);
            }
        }
    }

    private String getStatus(int c) {
        String db;
        CpuCore core = this.cpuCores.get(c);
        String string = db = core.isDebug() ? "[DB] " : "";
        if (core.hasProgram()) {
            RunningProgram program = core.getProgram();
            if (program.getDelay() > 0) {
                return db + "<delayed: " + program.getDelay() + ">";
            }
            if (program.getLock() != null) {
                return db + "<locked: " + program.getLock() + ">";
            }
            return db + "<busy>";
        }
        return db + "<idle>";
    }

    public void listStatus() {
        int n = 0;
        for (CpuCore core : this.getCpuCores()) {
            this.log("Core: " + n + " -> " + this.getStatus(n));
            ++n;
        }
        this.log("Event queue: " + this.eventQueue.size());
        this.log("Waiting items: " + this.waitingForItems.size());
        this.log("Locks: " + this.locks.size());
        if (this.lastException != null) {
            long dt = System.currentTimeMillis() - this.lastExceptionTime;
            this.log("Last: " + ChatFormatting.RED + this.lastException);
            if (dt > 3600000L) {
                this.log("(" + dt / 1000L + "hours ago)");
            } else if (dt > 60000L) {
                this.log("(" + dt / 60000L + "min ago)");
            } else if (dt > 1000L) {
                this.log("(" + dt / 1000L + "sec ago)");
            } else {
                this.log("(" + dt + "ms ago)");
            }
        }
    }

    public int stopPrograms() {
        int n = 0;
        for (CpuCore core : this.getCpuCores()) {
            if (!core.hasProgram()) continue;
            ++n;
            core.stopProgram();
        }
        this.locks.clear();
        this.runningEvents.clear();
        return n;
    }

    public void reset() {
        this.waitingForItems.clear();
        this.eventQueue.clear();
        this.stopPrograms();
        for (Direction facing : Direction.values()) {
            this.powerOut[facing.ordinal()] = 0;
        }
        for (BlockPos np : this.networkNodes.values()) {
            BlockEntity te = this.f_58857_.m_7702_(np);
            if (!(te instanceof NodeTileEntity)) continue;
            NodeTileEntity tileEntity = (NodeTileEntity)te;
            for (Direction facing : Direction.values()) {
                tileEntity.setPowerOut(facing, 0);
            }
        }
        this.gfxOps.clear();
        this.orderedOps.clear();
        for (CpuCore core : this.cpuCores) {
            core.setDebug(false);
        }
        this.m_6596_();
    }

    public IOpcodeRunnable.OpcodeResult placeLock(String name) {
        if (this.testLock(name)) {
            return IOpcodeRunnable.OpcodeResult.HOLD;
        }
        this.locks.add(name);
        return IOpcodeRunnable.OpcodeResult.POSITIVE;
    }

    public void releaseLock(String name) {
        this.locks.remove(name);
    }

    public boolean testLock(String name) {
        return this.locks.contains(name);
    }

    public void clearLog() {
        this.logMessages.clear();
        this.lastException = null;
        this.m_6596_();
    }

    public void exception(ExceptionType exception, @Nullable RunningProgram program) {
        String message;
        if (exception != ExceptionType.EXCEPT_TOOMANYEVENTS) {
            for (int i = 0; i < this.cardInfo.length; ++i) {
                CardInfo info = this.cardInfo[i];
                CompiledCard compiledCard = info.getCompiledCard();
                if (compiledCard == null) continue;
                for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_EXCEPTION)) {
                    int index = event.index();
                    CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                    String code = this.evaluateStringParameter(compiledOpcode, null, 0);
                    if (!exception.getCode().equals(code)) continue;
                    this.runOrQueueEvent(i, event, program == null ? null : program.getCraftTicket(), null);
                    return;
                }
            }
        }
        if (program != null) {
            CompiledCard card = this.getCompiledCard(program.getCardIndex());
            if (card == null) {
                message = ChatFormatting.RED + "INTERNAL: " + exception.getDescription();
            } else {
                CompiledOpcode opcode = program.getCurrentOpcode(this);
                int gridX = opcode.getGridX();
                int gridY = opcode.getGridY();
                message = ChatFormatting.RED + "[" + gridX + "," + gridY + "] " + exception.getDescription() + " (" + program.getCardIndex() + ")";
            }
        } else {
            message = ChatFormatting.RED + exception.getDescription();
        }
        this.lastException = message;
        this.lastExceptionTime = System.currentTimeMillis();
        this.log(message);
    }

    public void log(String message) {
        if (message == null) {
            return;
        }
        this.logMessages.add(message);
        while (this.logMessages.size() > (Integer)Config.processorMaxloglines.get()) {
            this.logMessages.remove();
        }
    }

    private List<String> getDebugLog() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < Math.min(5, this.cpuCores.size()); ++i) {
            result.add(ChatFormatting.BLUE + "Core " + i + " " + ChatFormatting.WHITE + this.getStatus(i));
        }
        this.showWithWarn("Event queue: ", this.eventQueue.size(), 20, result);
        this.showWithWarn("Waiting items: ", this.waitingForItems.size(), 20, result);
        this.showWithWarn("Locks: ", this.locks.size(), 10, result);
        if (this.lastException != null) {
            long dt = System.currentTimeMillis() - this.lastExceptionTime;
            result.add(ChatFormatting.RED + this.lastException);
            if (dt > 3600000L) {
                result.add("(" + dt / 1000L + "hours ago)");
            } else if (dt > 60000L) {
                result.add("(" + dt / 60000L + "min ago)");
            } else if (dt > 1000L) {
                result.add("(" + dt / 1000L + "sec ago)");
            } else {
                result.add("(" + dt + "ms ago)");
            }
        }
        return result;
    }

    private void showWithWarn(String label, int size, int max, List<String> result) {
        if (size >= max) {
            result.add(label + ChatFormatting.RED + size);
        } else {
            result.add(label + ChatFormatting.GREEN + size);
        }
    }

    private List<String> getLog() {
        return this.logMessages.stream().collect(Collectors.toList());
    }

    public List<String> getClientLog() {
        return this.clientLog;
    }

    public List<String> getClientDebugLog() {
        return this.clientDebugLog;
    }

    public List<String> getLastMessages(int n) {
        ArrayList<String> rc = new ArrayList<String>();
        int i = 0;
        for (String s : this.logMessages) {
            if (i >= this.logMessages.size() - n) {
                rc.add(s);
            }
            ++i;
        }
        return rc;
    }

    public int getFluidSlotsAvailable() {
        if (this.fluidSlotsAvailable == -1) {
            this.updateFluidSlotsAvailability();
        }
        return this.fluidSlotsAvailable;
    }

    public Parameter[] getVariableArray() {
        return this.variables;
    }

    public List<Parameter> getVariables() {
        ArrayList<Parameter> pars = new ArrayList<Parameter>();
        Collections.addAll(pars, this.variables);
        return pars;
    }

    public WatchInfo[] getWatchInfos() {
        return this.watchInfos;
    }

    public void setWatch(int varIndex, boolean br) {
        this.watchInfos[varIndex] = new WatchInfo(br);
        this.markDirtyQuick();
    }

    public void clearWatch(int varIndex) {
        this.watchInfos[varIndex] = null;
        this.markDirtyQuick();
    }

    public List<PacketGetFluids.FluidEntry> getFluids() {
        ArrayList<PacketGetFluids.FluidEntry> pars = new ArrayList<PacketGetFluids.FluidEntry>();
        for (int i = 0; i < 24; ++i) {
            if (this.isFluidSlotAvailable(i)) {
                Direction side = Direction.values()[i / 4];
                BlockEntity te = this.f_58857_.m_7702_(this.m_58899_().m_121945_(side));
                if (te instanceof MultiTankTileEntity) {
                    MultiTankTileEntity mtank = (MultiTankTileEntity)te;
                    MultiTankFluidProperties[] propertyList = mtank.getProperties();
                    MultiTankFluidProperties properties = propertyList[i % 4];
                    FluidStack fluidStack = properties == null ? null : properties.getContents();
                    pars.add(new PacketGetFluids.FluidEntry(fluidStack, true));
                    continue;
                }
                pars.add(new PacketGetFluids.FluidEntry(null, true));
                continue;
            }
            pars.add(new PacketGetFluids.FluidEntry(null, false));
        }
        return pars;
    }

    public List<CpuCore> getCpuCores() {
        return this.cpuCores;
    }

    private CpuCore findAvailableCore(int cardIndex) {
        if (this.exclusive) {
            CpuCore core;
            if (cardIndex < this.cpuCores.size() && !(core = this.cpuCores.get(cardIndex)).hasProgram()) {
                return core;
            }
        } else {
            for (CpuCore core : this.cpuCores) {
                if (core.hasProgram()) continue;
                return core;
            }
        }
        return null;
    }

    private void run() {
        long rf = this.energyStorage.getEnergy();
        for (CpuCore core : this.cpuCores) {
            int rft;
            if (!core.hasProgram() || (long)(rft = ((Integer)Config.coreRFPerTick[core.getTier()].get()).intValue()) >= rf) continue;
            core.run(this);
            this.energyStorage.consumeEnergy((long)rft);
            rf -= (long)rft;
        }
    }

    private void updateCores() {
        if (this.coresDirty) {
            this.coresDirty = false;
            this.cpuCores.clear();
            for (int i = 0; i < 16; ++i) {
                ItemStack expansionStack = this.items.getStackInSlot(i);
                if (expansionStack.m_41619_() || !(expansionStack.m_41720_() instanceof CPUCoreItem)) continue;
                CPUCoreItem coreItem = (CPUCoreItem)expansionStack.m_41720_();
                CpuCore core = new CpuCore();
                core.setTier(coreItem.getTier());
                this.cpuCores.add(core);
            }
        }
    }

    private void compileCards() {
        if (this.cardsDirty) {
            this.cardsDirty = false;
            for (int i = 16; i < 22; ++i) {
                int cardIndex;
                ItemStack cardStack = this.items.getStackInSlot(i);
                if (cardStack.m_41619_() || this.cardInfo[cardIndex = i - 16].getCompiledCard() != null) continue;
                CompiledCard compiled = CompiledCard.compile(ProgramCardInstance.parseInstance(cardStack));
                this.cardInfo[cardIndex].setCompiledCard(compiled);
            }
        }
    }

    public String getMachineInfo(Inventory side, int idx) {
        BlockEntity te = this.getTileEntityAt((BlockSide)side);
        return (String)te.getCapability(CapabilityMachineInformation.MACHINE_INFORMATION_CAPABILITY).map(h -> {
            if (idx < 0 || idx >= h.getTagCount()) {
                throw new ProgException(ExceptionType.EXCEPT_INVALIDMACHINE_INDEX);
            }
            return h.getData(idx, 0L);
        }).orElseThrow(() -> new ProgException(ExceptionType.EXCEPT_INVALIDMACHINE));
    }

    public int getEnergy(Inventory side) {
        BlockEntity te = this.getTileEntityAt((BlockSide)side);
        if (te == null) {
            throw new ProgException(ExceptionType.EXCEPT_NORF);
        }
        return (Integer)te.getCapability(ForgeCapabilities.ENERGY, side.getIntSide()).map(IEnergyStorage::getEnergyStored).orElseThrow(() -> new ProgException(ExceptionType.EXCEPT_NORF));
    }

    public int getMaxEnergy(Inventory side) {
        BlockEntity te = this.getTileEntityAt((BlockSide)side);
        if (te == null) {
            throw new ProgException(ExceptionType.EXCEPT_NORF);
        }
        return (Integer)te.getCapability(ForgeCapabilities.ENERGY, side.getIntSide()).map(IEnergyStorage::getMaxEnergyStored).orElseThrow(() -> new ProgException(ExceptionType.EXCEPT_NORF));
    }

    public long getEnergyLong(Inventory side) {
        BlockEntity te = this.getTileEntityAt((BlockSide)side);
        EnergyTools.EnergyLevel level = EnergyTools.getEnergyLevelMulti((BlockEntity)te, null);
        if (level.maxEnergy() >= 0L) {
            throw new ProgException(ExceptionType.EXCEPT_NORF);
        }
        return level.energy();
    }

    public long getMaxEnergyLong(Inventory side) {
        BlockEntity te = this.getTileEntityAt((BlockSide)side);
        EnergyTools.EnergyLevel level = EnergyTools.getEnergyLevelMulti((BlockEntity)te, null);
        if (level.maxEnergy() >= 0L) {
            throw new ProgException(ExceptionType.EXCEPT_NORF);
        }
        return level.maxEnergy();
    }

    public int getLiquid(@Nonnull Inventory side) {
        return this.getFluidHandlerAt(side).map(handler -> {
            FluidStack contents;
            if (handler.getTanks() > 0 && !(contents = handler.getFluidInTank(0)).isEmpty()) {
                return contents.getAmount();
            }
            return 0;
        }).orElse(0);
    }

    public int getMaxLiquid(@Nonnull Inventory side) {
        return this.getFluidHandlerAt(side).map(handler -> {
            if (handler.getTanks() > 0) {
                return handler.getTankCapacity(0);
            }
            return 0;
        }).orElse(0);
    }

    private IStorageScanner getScannerForInv(@Nullable Inventory inv) {
        if (inv == null) {
            return this.getStorageScanner();
        }
        return null;
    }

    @Nullable
    private IItemHandler getHandlerForInv(@Nullable Inventory inv) {
        if (inv == null) {
            return null;
        }
        return (IItemHandler)this.getItemHandlerAt(inv).orElse(null);
    }

    public boolean compareNBTTag(@Nonnull ItemStack v1, @Nonnull ItemStack v2, @Nonnull String tag) {
        Tag tag2;
        if (!v1.m_41782_() || !v2.m_41782_()) {
            return v1.m_41782_() == v2.m_41782_();
        }
        Tag tag1 = v1.m_41783_().m_128423_(tag);
        if (tag1 == (tag2 = v2.m_41783_().m_128423_(tag))) {
            return true;
        }
        if (tag1 != null) {
            return tag1.equals(tag2);
        }
        return false;
    }

    private MultiTankFluidProperties getFluidPropertiesFromMultiTank(Direction side, int idx) {
        BlockEntity te = this.f_58857_.m_7702_(this.m_58899_().m_121945_(side));
        if (te instanceof MultiTankTileEntity) {
            MultiTankTileEntity mtank = (MultiTankTileEntity)te;
            return mtank.getProperties()[idx];
        }
        return null;
    }

    @Nonnull
    public FluidStack examineLiquid(@Nonnull Inventory inv, @Nullable Integer slot) {
        if (slot == null) {
            slot = 0;
        }
        Integer finalSlot = slot;
        return this.getFluidHandlerAt(inv).map(handler -> {
            if (finalSlot < handler.getTanks()) {
                return handler.getFluidInTank(finalSlot.intValue());
            }
            return FluidStack.EMPTY;
        }).orElse(FluidStack.EMPTY);
    }

    @Nullable
    public FluidStack examineLiquidInternal(IProgram program, int virtualSlot) {
        int idx;
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealFluidSlot(virtualSlot);
        Direction side = Direction.values()[realSlot / 4];
        MultiTankFluidProperties properties = this.getFluidPropertiesFromMultiTank(side, idx = realSlot % 4);
        if (properties == null) {
            return null;
        }
        return properties.getContents();
    }

    public int pushLiquid(IProgram program, @Nonnull Inventory inv, int amount, int virtualSlot) {
        return this.getFluidHandlerAt(inv).map(handler -> {
            int idx;
            CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
            int realSlot = info.getRealFluidSlot(virtualSlot);
            Direction side = Direction.values()[realSlot / 4];
            MultiTankFluidProperties properties = this.getFluidPropertiesFromMultiTank(side, idx = realSlot % 4);
            if (properties == null) {
                return 0;
            }
            if (!properties.hasContents()) {
                return 0;
            }
            int newAmount = Math.min(amount, properties.getContentsInternal().getAmount());
            FluidStack topush = properties.getContents();
            topush.setAmount(newAmount);
            int filled = handler.fill(topush, IFluidHandler.FluidAction.EXECUTE);
            properties.drain(filled);
            return filled;
        }).orElse(0);
    }

    public int fetchLiquid(IProgram program, @Nonnull Inventory inv, int amount, @Nullable FluidStack fluidStack, int virtualSlot) {
        return this.getFluidHandlerAt(inv).map(handler -> {
            int newAmount;
            int idx;
            CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
            int realSlot = info.getRealFluidSlot(virtualSlot);
            Direction side = Direction.values()[realSlot / 4];
            MultiTankFluidProperties properties = this.getFluidPropertiesFromMultiTank(side, idx = realSlot % 4);
            if (properties == null) {
                return 0;
            }
            int internalAmount = 0;
            if (properties.hasContents()) {
                if (fluidStack != null && !fluidStack.isFluidEqual(properties.getContentsInternal())) {
                    return 0;
                }
                internalAmount = properties.getContentsInternal().getAmount();
            }
            if (internalAmount + (newAmount = amount) > 10000) {
                newAmount = 10000 - internalAmount;
            }
            if (newAmount <= 0) {
                return 0;
            }
            if (fluidStack == null) {
                FluidStack drained = handler.drain(newAmount, IFluidHandler.FluidAction.SIMULATE);
                if (!drained.isEmpty()) {
                    if (!properties.hasContents() || properties.getContentsInternal().isFluidEqual(drained)) {
                        drained = handler.drain(newAmount, IFluidHandler.FluidAction.EXECUTE);
                        properties.fill(drained);
                        return drained.getAmount();
                    }
                    return 0;
                }
            } else {
                FluidStack todrain = fluidStack.copy();
                todrain.setAmount(newAmount);
                FluidStack drained = handler.drain(todrain, IFluidHandler.FluidAction.EXECUTE);
                if (!drained.isEmpty()) {
                    int drainedAmount = drained.getAmount();
                    if (properties.hasContents()) {
                        drained.setAmount(drained.getAmount() + properties.getContentsInternal().getAmount());
                    }
                    properties.set(drained);
                    return drainedAmount;
                }
            }
            return 0;
        }).orElse(0);
    }

    public int fetchItemsFilter(IProgram program, Inventory inv, Integer amount, int virtualSlot, int filterIndex) {
        if (amount != null && amount == 0) {
            throw new ProgException(ExceptionType.EXCEPT_BADPARAMETERS);
        }
        Predicate<ItemStack> cache = this.getFilterCache(filterIndex);
        if (cache == null) {
            throw new ProgException(ExceptionType.EXCEPT_UNKNOWN_FILTER);
        }
        IItemHandler handler = this.getHandlerForInv(inv);
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealSlot(virtualSlot);
        ItemStack stack = LogicInventoryTools.tryExtractItem(handler, amount, cache);
        if (stack.m_41619_()) {
            return 0;
        }
        GenericItemHandler capability = this.items;
        if (!capability.insertItem(realSlot, stack, true).m_41619_()) {
            return 0;
        }
        stack = LogicInventoryTools.extractItem(handler, amount, cache);
        capability.insertItem(realSlot, stack, false);
        return stack.m_41613_();
    }

    public int fetchItems(IProgram program, Inventory inv, Integer slot, Ingredient itemMatcher, boolean routable, @Nullable Integer amount, int virtualSlot) {
        if (amount != null && amount == 0) {
            throw new ProgException(ExceptionType.EXCEPT_BADPARAMETERS);
        }
        IItemHandler handler = this.getHandlerForInv(inv);
        IStorageScanner scanner = this.getScannerForInv(inv);
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealSlot(virtualSlot);
        ItemStack stack = LogicInventoryTools.tryExtractItem(handler, scanner, amount, routable, itemMatcher, slot);
        if (stack.m_41619_()) {
            return 0;
        }
        GenericItemHandler capability = this.items;
        if (!capability.insertItem(realSlot, stack, true).m_41619_()) {
            return 0;
        }
        stack = LogicInventoryTools.extractItem(handler, scanner, amount, routable, itemMatcher, slot);
        capability.insertItem(realSlot, stack, false);
        return stack.m_41613_();
    }

    @Nullable
    public ItemStack getItemInternal(IProgram program, int virtualSlot) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealSlot(virtualSlot);
        return this.items.getStackInSlot(realSlot);
    }

    public int pushItems(IProgram program, Inventory inv, Integer slot, @Nullable Integer amount, int virtualSlot) {
        IItemHandler handler = this.getHandlerForInv(inv);
        IStorageScanner scanner = this.getScannerForInv(inv);
        GenericItemHandler itemHandler = this.items;
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealSlot(virtualSlot);
        ItemStack extracted = itemHandler.extractItem(realSlot, amount == null ? 64 : amount, false);
        if (extracted.m_41619_()) {
            return 0;
        }
        ItemStack remaining = LogicInventoryTools.insertItem(handler, scanner, extracted, slot);
        if (!remaining.m_41619_()) {
            itemHandler.insertItem(realSlot, remaining, false);
            return extracted.m_41613_() - remaining.m_41613_();
        }
        return extracted.m_41613_();
    }

    public void sendMessage(IProgram program, int idSlot, String messageName, @Nullable Integer variableSlot) {
        BlockPos dest;
        if (!this.hasNetworkCard()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGNETWORKCARD);
        }
        if (this.hasNetworkCard != 1) {
            throw new ProgException(ExceptionType.EXCEPT_NEEDSADVANCEDNETWORK);
        }
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realIdSlot = info.getRealSlot(idSlot);
        Integer realVariable = info.getRealVar(variableSlot);
        ItemStack idCard = this.items.getStackInSlot(realIdSlot);
        if (idCard.m_41619_() || !(idCard.m_41720_() instanceof NetworkIdentifierItem)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTANIDENTIFIER);
        }
        CompoundTag tagCompound = idCard.m_41783_();
        if (tagCompound == null || !tagCompound.m_128441_("monitorx")) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDDESTINATION);
        }
        String monitordim = tagCompound.m_128461_("monitordim");
        int monitorx = tagCompound.m_128451_("monitorx");
        int monitory = tagCompound.m_128451_("monitory");
        int monitorz = tagCompound.m_128451_("monitorz");
        ServerLevel world = LevelTools.getLevel((ResourceKey)LevelTools.getId((String)monitordim));
        if (!LevelTools.isLoaded((Level)world, (BlockPos)(dest = new BlockPos(monitorx, monitory, monitorz)))) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDDESTINATION);
        }
        BlockEntity te = world.m_7702_(dest);
        if (!(te instanceof ProcessorTileEntity)) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDDESTINATION);
        }
        ProcessorTileEntity destTE = (ProcessorTileEntity)te;
        destTE.receiveMessage(messageName, realVariable == null ? null : this.getVariableArray()[realVariable]);
    }

    private void setOp(String id, GfxOp op) {
        if (!this.hasGraphicsCard()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGGRAPHICSCARD);
        }
        if (!this.gfxOps.containsKey(id)) {
            if (this.gfxOps.size() >= (Integer)Config.maxGraphicsOpcodes.get()) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNETWORKCARD);
            }
            this.orderedOps = null;
        }
        this.gfxOps.put(id, op);
        this.m_6596_();
    }

    private void sortOps() {
        this.orderedOps = new ArrayList<String>(this.gfxOps.keySet());
        this.orderedOps.sort(String::compareTo);
    }

    public void gfxDrawBox(IProgram program, String id, int x, int y, int w, int h, int color) {
        this.setOp(id, new GfxOpBox(x, y, w, h, color));
    }

    public void gfxDrawLine(IProgram program, String id, int x1, int y1, int x2, int y2, int color) {
        this.setOp(id, new GfxOpLine(x1, y1, x2, y2, color));
    }

    public void gfxDrawText(IProgram program, String id, int x, int y, String text, int color) {
        this.setOp(id, new GfxOpText(x, y, text, color));
    }

    public void gfxDrawBox(IProgram program, String id, @Nonnull Tuple loc, @Nonnull Tuple size, int color) {
        this.setOp(id, new GfxOpBox(loc.getX(), loc.getY(), size.getX(), size.getY(), color));
    }

    public void gfxDrawLine(IProgram program, String id, @Nonnull Tuple pos1, @Nonnull Tuple pos2, int color) {
        this.setOp(id, new GfxOpLine(pos1.getX(), pos1.getY(), pos2.getX(), pos2.getY(), color));
    }

    public void gfxDrawText(IProgram program, String id, @Nonnull Tuple pos, String text, int color) {
        this.setOp(id, new GfxOpText(pos.getX(), pos.getY(), text, color));
    }

    public void gfxClear(IProgram program, @Nullable String id) {
        if (id == null || id.isEmpty()) {
            this.gfxOps.clear();
            this.orderedOps = null;
        } else {
            this.gfxOps.remove(id);
            this.orderedOps = null;
        }
        this.m_6596_();
    }

    public Map<String, GfxOp> getGfxOps() {
        return this.gfxOps;
    }

    public List<String> getOrderedOps() {
        if (this.orderedOps == null) {
            this.sortOps();
        }
        return this.orderedOps;
    }

    public void setClientOrderedGfx(Map<String, GfxOp> gfxOps, List<String> orderedOps) {
        this.clientGfxOps.clear();
        for (String key : orderedOps) {
            this.clientGfxOps.add(gfxOps.get(key));
        }
    }

    public List<GfxOp> getClientGfxOps() {
        return this.clientGfxOps;
    }

    public boolean testWithFilter(ItemStack item, int idx) {
        Predicate<ItemStack> filterCache = this.getFilterCache(idx);
        if (filterCache == null) {
            throw new ProgException(ExceptionType.EXCEPT_UNKNOWN_FILTER);
        }
        return filterCache.test(item);
    }

    private List<Predicate<ItemStack>> getFilterCaches() {
        ArrayList<Predicate<ItemStack>> caches = new ArrayList<Predicate<ItemStack>>();
        for (int i = 0; i < 16; ++i) {
            ItemStack stack = this.items.getStackInSlot(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof FilterModuleItem)) continue;
            caches.add(FilterModuleItem.getCache((ItemStack)stack));
        }
        return caches;
    }

    @Nullable
    private Predicate<ItemStack> getFilterCache(int index) {
        if (index < ((List)this.filterCaches.get()).size()) {
            return (Predicate)((List)this.filterCaches.get()).get(index);
        }
        return null;
    }

    public int getMaxvars() {
        if (this.maxVars == -1) {
            this.maxVars = 0;
            this.hasNetworkCard = -1;
            this.hasGraphicsCard = false;
            this.storageCard = -1;
            Item storageCardItem = (Item)RFToolsStuff.STORAGE_CONTROL_MODULE.get();
            for (int i = 0; i < 16; ++i) {
                ItemStack stack = this.items.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                if (stack.m_41720_() instanceof NetworkCardItem) {
                    this.hasNetworkCard = ((NetworkCardItem)stack.m_41720_()).getTier();
                    continue;
                }
                if (stack.m_41720_() instanceof RAMChipItem) {
                    this.maxVars += 8;
                    continue;
                }
                if (stack.m_41720_() instanceof GraphicsCardItem) {
                    this.hasGraphicsCard = true;
                    continue;
                }
                if (stack.m_41720_() != storageCardItem) continue;
                this.storageCard = i;
            }
            if (this.maxVars >= 32) {
                this.maxVars = 32;
            }
            this.updateFluidSlotsAvailability();
        }
        return this.maxVars;
    }

    public void markFluidSlotsDirty() {
        this.fluidSlotsAvailable = -1;
    }

    private void updateFluidSlotsAvailability() {
        this.fluidSlotsAvailable = 0;
        for (Direction facing : Direction.values()) {
            BlockEntity te = this.f_58857_.m_7702_(this.m_58899_().m_121945_(facing));
            if (!(te instanceof MultiTankTileEntity)) continue;
            this.fluidSlotsAvailable |= 1 << facing.ordinal();
        }
        this.fixCardInfoForSlotAvailability();
        this.m_6596_();
    }

    private void fixCardInfoForSlotAvailability() {
        for (CardInfo info : this.cardInfo) {
            int alloc = info.getFluidAllocation();
            for (int i = 0; i < 24; ++i) {
                if ((this.fluidSlotsAvailable & 1 << i / 4) != 0) continue;
                alloc &= ~(1 << i);
            }
            info.setFluidAllocation(alloc);
        }
    }

    public boolean hasGraphicsCard() {
        if (this.maxVars == -1) {
            this.getMaxvars();
        }
        return this.hasGraphicsCard;
    }

    public boolean hasNetworkCard() {
        if (this.maxVars == -1) {
            this.getMaxvars();
        }
        return this.hasNetworkCard != -1;
    }

    public int getStorageCard() {
        if (this.storageCard == -2) {
            this.getMaxvars();
        }
        return this.storageCard;
    }

    public String getChannelName() {
        return this.channel;
    }

    public int getNodeCount() {
        return this.networkNodes.size();
    }

    public void stopOrResume(IProgram program) {
        ((RunningProgram)program).popLoopStack(this);
    }

    public boolean testGreater(IProgram program, int var) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realVar = this.getRealVarSafe(var, info);
        Parameter lastValue = (Parameter)program.getLastValue();
        Parameter varValue = this.variables[realVar];
        if (lastValue == null) {
            return varValue == null;
        }
        if (varValue == null) {
            return false;
        }
        if (lastValue.getParameterType() != varValue.getParameterType()) {
            return false;
        }
        return ParameterTools.compare((IParameter)lastValue, (IParameter)varValue) > 0;
    }

    public boolean testEquality(IProgram program, int var) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realVar = this.getRealVarSafe(var, info);
        Parameter lastValue = (Parameter)program.getLastValue();
        Parameter varValue = this.variables[realVar];
        if (lastValue == null) {
            return varValue == null;
        }
        if (varValue == null) {
            return false;
        }
        if (lastValue.getParameterType() != varValue.getParameterType()) {
            return false;
        }
        Object v1 = lastValue.getParameterValue().getValue();
        Object v2 = varValue.getParameterValue().getValue();
        if (v1 == null) {
            return v2 == null;
        }
        if (v2 == null) {
            return false;
        }
        if (varValue.getParameterType() == ParameterType.PAR_ITEM) {
            return ItemStack.m_41656_((ItemStack)((ItemStack)v1), (ItemStack)((ItemStack)v2));
        }
        if (varValue.getParameterType() == ParameterType.PAR_FLUID) {
            return ((FluidStack)v1).isFluidEqual((FluidStack)v2);
        }
        if (varValue.getParameterType() == ParameterType.PAR_VECTOR) {
            return ParameterTools.compare((IParameter)lastValue, (IParameter)varValue) == 0;
        }
        return v1.equals(v2);
    }

    private int getRealVarSafe(int var, CardInfo info) {
        int realVar = info.getRealVar(var);
        if (realVar == -1) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGVARIABLE);
        }
        if (realVar >= this.getMaxvars()) {
            throw new ProgException(ExceptionType.EXCEPT_NOTENOUGHVARIABLES);
        }
        return realVar;
    }

    public void handleCall(IProgram program, String signal) {
        RunningProgram p = (RunningProgram)program;
        CardInfo info = this.cardInfo[p.getCardIndex()];
        CompiledCard compiledCard = info.getCompiledCard();
        if (compiledCard != null) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_SIGNAL)) {
                int index = event.index();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                String sig = this.evaluateStringParameter(compiledOpcode, null, 0);
                if (!signal.equals(sig)) continue;
                p.pushCall(p.getCurrentOpcode(this).getPrimaryIndex());
                p.setCurrent(event.index());
                return;
            }
        }
        throw new ProgException(ExceptionType.EXCEPT_MISSINGSIGNAL);
    }

    public IOpcodeRunnable.OpcodeResult handleLoop(IProgram program, int varIdx, int end) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realVar = this.getRealVarSafe(varIdx, info);
        Parameter parameter = this.getVariableArray()[realVar];
        int i = TypeConverters.convertToInt((IParameter)parameter);
        if (i > end) {
            return IOpcodeRunnable.OpcodeResult.NEGATIVE;
        }
        ((RunningProgram)program).pushLoopStack(realVar);
        return IOpcodeRunnable.OpcodeResult.POSITIVE;
    }

    public void setValueInToken(IProgram program, int slot) {
        Parameter lastValue;
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealSlot(slot);
        ItemStack stack = this.items.getStackInSlot(realSlot);
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TokenItem)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTATOKEN);
        }
        if (!stack.m_41782_()) {
            stack.m_41751_(new CompoundTag());
        }
        if ((lastValue = (Parameter)program.getLastValue()) == null) {
            stack.m_41783_().m_128473_("parameter");
        } else {
            CompoundTag tag = ParameterTools.writeToNBT(lastValue);
            stack.m_41783_().m_128365_("parameter", (Tag)tag);
        }
    }

    @Nullable
    public Parameter getParameterFromToken(IProgram program, int slot) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realSlot = info.getRealSlot(slot);
        ItemStack stack = this.items.getStackInSlot(realSlot);
        if (stack.m_41619_() || !(stack.m_41720_() instanceof TokenItem)) {
            throw new ProgException(ExceptionType.EXCEPT_NOTATOKEN);
        }
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag tag = stack.m_41783_().m_128469_("parameter");
        if (tag.m_128456_()) {
            return null;
        }
        return ParameterTools.readFromNBT(tag);
    }

    public void setVariable(IProgram program, int var) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realVar = this.getRealVarSafe(var, info);
        this.setVariableInternal(program, realVar, (Parameter)program.getLastValue());
    }

    public void setVariableInternal(IProgram program, int realVar, Parameter value) {
        Parameter oldValue;
        if (this.watchInfos[realVar] != null && this.isWatchTriggered(oldValue = this.variables[realVar], value)) {
            this.log(ChatFormatting.BLUE + "W" + realVar + ": " + TypeConverters.convertToString((IParameter)value));
            if (this.watchInfos[realVar].isBreakOnChange()) {
                CpuCore core = ((RunningProgram)program).getCore();
                core.setDebug(true);
            }
        }
        this.variables[realVar] = value;
    }

    private boolean isWatchTriggered(Parameter old, Parameter value) {
        if (old == value) {
            return false;
        }
        if (old == null) {
            return true;
        }
        if (value == null) {
            return true;
        }
        return ParameterTools.compare((IParameter)value, (IParameter)old) != 0;
    }

    public IParameter getVariable(IProgram program, int var) {
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realVar = this.getRealVarSafe(var, info);
        return this.variables[realVar];
    }

    @Nullable
    public <T> T evaluateGenericParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex, BiFunction<ParameterType, Object, T> convertor) {
        List parameters = compiledOpcode.getParameters();
        if (parIndex >= parameters.size()) {
            return null;
        }
        IParameter parameter = (IParameter)parameters.get(parIndex);
        ParameterValue value = parameter.getParameterValue();
        if (value.isConstant()) {
            return convertor.apply(parameter.getParameterType(), value.getValue());
        }
        if (value.isFunction()) {
            Function function = value.getFunction();
            Object v = function.getFunctionRunnable().run((IProcessor)this, program);
            return convertor.apply(function.getReturnType(), v);
        }
        CardInfo info = this.cardInfo[((RunningProgram)program).getCardIndex()];
        int realVar = this.getRealVarSafe(value.getVariableIndex(), info);
        Parameter par = this.variables[realVar];
        if (par == null || par.getParameterValue() == null) {
            return null;
        }
        return convertor.apply(par.getParameterType(), par.getParameterValue().getValue());
    }

    @Nonnull
    public <T> T evaluateGenericParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex, BiFunction<ParameterType, Object, T> convertor) {
        T rc = this.evaluateGenericParameter(compiledOpcode, program, parIndex, convertor);
        if (rc == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGPARAMETER);
        }
        return rc;
    }

    @Nonnull
    public <T> T evaluateParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return (T)this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, (type, value) -> value);
    }

    @Nullable
    public <T> T evaluateParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return (T)this.evaluateGenericParameter(compiledOpcode, program, parIndex, (type, value) -> value);
    }

    @Nullable
    public Tuple evaluateTupleParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_TUPLE);
    }

    @Nonnull
    public Tuple evaluateTupleParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_TUPLE);
    }

    @Nullable
    public List<IParameter> evaluateVectorParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        List<Parameter> parameters = this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_VECTOR);
        if (parameters == null) {
            return null;
        }
        return parameters.stream().map(p -> p).collect(Collectors.toList());
    }

    @Nonnull
    public List<IParameter> evaluateVectorParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        List<Parameter> parameters = this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_VECTOR);
        return parameters.stream().map(p -> p).collect(Collectors.toList());
    }

    @Nullable
    public ItemStack evaluateItemParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        ItemStack stack = this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_ITEM);
        if (stack == null) {
            return ItemStack.f_41583_;
        }
        return stack;
    }

    @Nonnull
    public ItemStack evaluateItemParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        ItemStack stack = this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_ITEM);
        if (stack.m_41619_()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGPARAMETER);
        }
        return stack;
    }

    @Nullable
    public FluidStack evaluateFluidParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_FLUID);
    }

    @Nonnull
    public FluidStack evaluateFluidParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_FLUID);
    }

    @Nullable
    public BlockSide evaluateSideParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_SIDE);
    }

    @Nonnull
    public BlockSide evaluateSideParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_SIDE);
    }

    @Nullable
    public Inventory evaluateInventoryParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_INVENTORY);
    }

    @Nonnull
    public Inventory evaluateInventoryParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_INVENTORY);
    }

    public int evaluateIntParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        Integer value = this.evaluateIntegerParameter(compiledOpcode, program, parIndex);
        if (value == null) {
            return 0;
        }
        return value;
    }

    public long evaluateLngParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        Long value = this.evaluateLongParameter(compiledOpcode, program, parIndex);
        if (value == null) {
            return 0L;
        }
        return value;
    }

    @Nullable
    public Integer evaluateIntegerParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_INTEGER);
    }

    @Nullable
    public Long evaluateLongParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_LONG);
    }

    @Nullable
    public Number evaluateNumberParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_NUMBER);
    }

    @Nullable
    public String evaluateStringParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_STRING);
    }

    @Nonnull
    public String evaluateStringParameterNonNull(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        return this.evaluateGenericParameterNonNull(compiledOpcode, program, parIndex, CONVERTOR_STRING);
    }

    public boolean evaluateBoolParameter(ICompiledOpcode compiledOpcode, IProgram program, int parIndex) {
        Boolean rc = this.evaluateGenericParameter(compiledOpcode, program, parIndex, CONVERTOR_BOOL);
        if (rc == null) {
            return false;
        }
        return rc;
    }

    public int countItemStorage(ItemStack stack, boolean routable) {
        IStorageScanner scanner = this.getStorageScanner();
        return scanner.countItems(stack, routable);
    }

    private IStorageScanner getStorageScanner() {
        int card = this.getStorageCard();
        if (card == -1) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGECARD);
        }
        ItemStack storageStack = this.items.getStackInSlot(card);
        if (!storageStack.m_41782_()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGECARD);
        }
        CompoundTag tagCompound = storageStack.m_41783_();
        BlockPos c = new BlockPos(tagCompound.m_128451_("monitorx"), tagCompound.m_128451_("monitory"), tagCompound.m_128451_("monitorz"));
        String dim = tagCompound.m_128461_("monitordim");
        ServerLevel world = LevelTools.getLevel((ResourceKey)LevelTools.getId((String)dim));
        if (world == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)c)) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        BlockEntity te = world.m_7702_(c);
        if (te == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        if (!(te instanceof IStorageScanner)) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        return (IStorageScanner)te;
    }

    public int countSlots(Inventory inv, IProgram program) {
        return this.getItemHandlerAt(inv).map(IItemHandler::getSlots).orElse(0);
    }

    public int countItem(Inventory inv, Integer slot, ItemStack itemMatcher, boolean routable, IProgram program) {
        if (inv == null) {
            return this.countItemStorage(itemMatcher, routable);
        }
        return this.getItemHandlerAt(inv).map(handler -> {
            if (slot != null) {
                ItemStack stackInSlot = handler.getStackInSlot(slot.intValue());
                if (stackInSlot.m_41619_()) {
                    return 0;
                }
                if (!itemMatcher.m_41619_() && !ItemStack.m_41656_((ItemStack)stackInSlot, (ItemStack)itemMatcher)) {
                    return 0;
                }
                return stackInSlot.m_41613_();
            }
            if (!itemMatcher.m_41619_()) {
                return this.countItemInHandler(itemMatcher, (IItemHandler)handler);
            }
            int cnt = 0;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                cnt += stack.m_41613_();
            }
            return cnt;
        }).orElse(0);
    }

    private int countItemInHandler(ItemStack itemMatcher, IItemHandler handler) {
        int cnt = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_() || !ItemStack.m_41656_((ItemStack)stack, (ItemStack)itemMatcher)) continue;
            cnt += stack.m_41613_();
        }
        return cnt;
    }

    @Nullable
    public BlockEntity getTileEntityAt(@Nullable BlockSide inv) {
        BlockPos np = this.getPositionAt(inv);
        if (np == null) {
            return null;
        }
        return this.f_58857_.m_7702_(np);
    }

    @Nullable
    public BlockPos getPositionAt(@Nullable BlockSide inv) {
        if (inv == null) {
            return null;
        }
        BlockPos p = this.f_58858_;
        if (inv.hasNodeName()) {
            if (!this.hasNetworkCard()) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNETWORKCARD);
            }
            p = this.networkNodes.get(inv.getNodeName());
            if (p == null) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNODE);
            }
        }
        if (inv.getSide() == null) {
            return p;
        }
        return p.m_121945_(inv.getSide());
    }

    @Nonnull
    public LazyOptional<IFluidHandler> getFluidHandlerAt(@Nonnull Inventory inv) {
        BlockEntity te = this.getTileEntityAt((BlockSide)inv);
        if (te == null) {
            throw new ProgException(ExceptionType.EXCEPT_NOLIQUID);
        }
        LazyOptional capability = te.getCapability(ForgeCapabilities.FLUID_HANDLER, inv.getIntSide());
        if (!capability.isPresent()) {
            throw new ProgException(ExceptionType.EXCEPT_NOLIQUID);
        }
        return capability;
    }

    @Nonnull
    public LazyOptional<IItemHandler> getItemHandlerAt(@Nonnull Inventory inv) {
        Direction intSide = inv.getIntSide();
        BlockEntity te = this.getTileEntityAt((BlockSide)inv);
        if (te == null) {
            return LazyOptional.empty();
        }
        return this.getItemHandlerAt(te, intSide);
    }

    private LazyOptional<IItemHandler> getItemHandlerAt(@Nonnull BlockEntity te, Direction intSide) {
        LazyOptional capability = te.getCapability(ForgeCapabilities.ITEM_HANDLER, intSide);
        if (!capability.isPresent()) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDINVENTORY);
        }
        return capability;
    }

    private boolean isExpansionSlot(int index) {
        return index >= 0 && index < 16;
    }

    private boolean isCardSlot(int index) {
        return index >= 16 && index < 22;
    }

    private void removeCard(int index) {
        this.cardInfo[index].setCompiledCard(null);
        this.stopPrograms(index);
        ArrayDeque<QueuedEvent> newQueue = new ArrayDeque<QueuedEvent>();
        for (QueuedEvent event : this.eventQueue) {
            if (event.cardIndex() == index) continue;
            newQueue.add(event);
        }
        this.eventQueue = newQueue;
    }

    private void stopPrograms(int cardIndex) {
        for (CpuCore core : this.cpuCores) {
            if (!core.hasProgram() || core.getProgram().getCardIndex() != cardIndex) continue;
            core.stopProgram();
        }
        HashSet<Pair<Integer, Integer>> newRunningEvents = new HashSet<Pair<Integer, Integer>>();
        for (Pair<Integer, Integer> pair : this.runningEvents) {
            if ((Integer)pair.getLeft() == cardIndex) continue;
            newRunningEvents.add(pair);
        }
        this.runningEvents = newRunningEvents;
    }

    private void clearExpansions() {
        this.coresDirty = true;
        this.maxVars = -1;
        this.storageCard = -2;
        this.hasNetworkCard = -1;
        this.filterCaches.clear();
    }

    public int getShowHud() {
        return this.showHud;
    }

    public void setShowHud(int showHud) {
        this.showHud = showHud;
        this.markDirtyClient();
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound) {
        CompoundTag info = tagCompound.m_128469_("Info");
        if (info != null) {
            this.exclusive = info.m_128471_("exclusive");
            this.showHud = info.m_128445_("hud");
            this.readCardInfo(info);
        }
    }

    public void saveClientDataToNBT(CompoundTag tagCompound) {
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128379_("exclusive", this.exclusive);
        info.m_128344_("hud", (byte)this.showHud);
        this.writeCardInfo(info);
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.prevIn = tagCompound.m_128451_("prevIn");
        for (int i = 0; i < 6; ++i) {
            this.powerOut[i] = tagCompound.m_128445_("p" + i);
        }
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128405_("prevIn", this.prevIn);
        for (int i = 0; i < 6; ++i) {
            tagCompound.m_128344_("p" + i, (byte)this.powerOut[i]);
        }
    }

    protected void loadInfo(CompoundTag tagCompound) {
        super.loadInfo(tagCompound);
        CompoundTag info = tagCompound.m_128469_("Info");
        this.tickCount = info.m_128451_("tickCount");
        this.channel = info.m_128461_("channel");
        this.exclusive = info.m_128471_("exclusive");
        this.showHud = info.m_128445_("hud");
        if (info.m_128441_("lastExc")) {
            this.lastException = info.m_128461_("lastExc");
            this.lastExceptionTime = info.m_128454_("lastExcT");
        } else {
            this.lastException = null;
            this.lastExceptionTime = 0L;
        }
        this.readCardInfo(info);
        this.readCores(info);
        this.readEventQueue(info);
        this.readLog(info);
        this.readVariables(info);
        this.readNetworkNodes(info);
        this.readCraftingStations(info);
        this.readWaitingForItems(info);
        this.readLocks(info);
        this.readRunningEvents(info);
        this.readGraphicsOperations(info);
    }

    private void readGraphicsOperations(CompoundTag tagCompound) {
        this.gfxOps.clear();
        CompoundTag opTag = tagCompound.m_128469_("gfxop");
        for (String key : opTag.m_128431_()) {
            this.gfxOps.put(key, GfxOp.readFromNBT(opTag.m_128469_(key)));
        }
        this.sortOps();
    }

    private void readRunningEvents(CompoundTag tagCompound) {
        this.runningEvents.clear();
        ListTag evList = tagCompound.m_128437_("singev", 10);
        for (int i = 0; i < evList.size(); ++i) {
            CompoundTag tag = evList.m_128728_(i);
            int cardIndex = tag.m_128451_("card");
            int eventIndex = tag.m_128451_("event");
            this.runningEvents.add((Pair<Integer, Integer>)Pair.of((Object)cardIndex, (Object)eventIndex));
        }
    }

    private void readLocks(CompoundTag tagCompound) {
        this.locks.clear();
        ListTag lockList = tagCompound.m_128437_("locks", 8);
        for (int i = 0; i < lockList.size(); ++i) {
            String name = lockList.m_128778_(i);
            this.locks.add(name);
        }
    }

    private void readWaitingForItems(CompoundTag tagCompound) {
        this.waitingForItems.clear();
        ListTag waitingList = tagCompound.m_128437_("waiting", 10);
        for (int i = 0; i < waitingList.size(); ++i) {
            CompoundTag tag = waitingList.m_128728_(i);
            String ticket = tag.m_128461_("ticket");
            ItemStack stack = tag.m_128441_("item") ? ItemStack.m_41712_((CompoundTag)tag.m_128469_("item")) : ItemStack.f_41583_;
            Inventory inventory = tag.m_128441_("inv") ? InventoryUtil.readFromNBT(tag.m_128469_("inv")) : null;
            WaitForItem waitForItem = new WaitForItem(ticket, stack, inventory);
            this.waitingForItems.add(waitForItem);
        }
    }

    private void readCraftingStations(CompoundTag tagCompound) {
        this.craftingStations.clear();
        ListTag stationList = tagCompound.m_128437_("stations", 10);
        for (int i = 0; i < stationList.size(); ++i) {
            CompoundTag tag = stationList.m_128728_(i);
            BlockPos nodePos = new BlockPos(tag.m_128451_("nodex"), tag.m_128451_("nodey"), tag.m_128451_("nodez"));
            this.craftingStations.add(nodePos);
        }
    }

    private void readNetworkNodes(CompoundTag tagCompound) {
        this.networkNodes.clear();
        ListTag networkList = tagCompound.m_128437_("nodes", 10);
        for (int i = 0; i < networkList.size(); ++i) {
            CompoundTag tag = networkList.m_128728_(i);
            String name = tag.m_128461_("name");
            BlockPos nodePos = new BlockPos(tag.m_128451_("nodex"), tag.m_128451_("nodey"), tag.m_128451_("nodez"));
            this.networkNodes.put(name, nodePos);
        }
    }

    private void readVariables(CompoundTag tagCompound) {
        for (int i = 0; i < 32; ++i) {
            this.variables[i] = null;
            this.watchInfos[i] = null;
        }
        ListTag varList = tagCompound.m_128437_("vars", 10);
        for (int i = 0; i < varList.size(); ++i) {
            WatchInfo info;
            CompoundTag var = varList.m_128728_(i);
            int index = var.m_128451_("varidx");
            this.variables[index] = ParameterTools.readFromNBT(var);
            if (!var.m_128441_("watch")) continue;
            this.watchInfos[index] = info = new WatchInfo(var.m_128471_("watch"));
        }
    }

    private void readLog(CompoundTag tagCompound) {
        this.logMessages.clear();
        ListTag logList = tagCompound.m_128437_("log", 8);
        for (int i = 0; i < logList.size(); ++i) {
            this.logMessages.add(logList.m_128778_(i));
        }
    }

    private void readCores(CompoundTag tagCompound) {
        ListTag coreList = tagCompound.m_128437_("cores", 10);
        this.cpuCores.clear();
        this.coresDirty = false;
        for (int i = 0; i < coreList.size(); ++i) {
            CpuCore core = new CpuCore();
            core.readFromNBT(coreList.m_128728_(i));
            this.cpuCores.add(core);
        }
        if (this.cpuCores.isEmpty()) {
            this.coresDirty = true;
        }
    }

    private void readEventQueue(CompoundTag tagCompound) {
        this.eventQueue.clear();
        ListTag eventQueueList = tagCompound.m_128437_("events", 10);
        for (int i = 0; i < eventQueueList.size(); ++i) {
            CompoundTag tag = eventQueueList.m_128728_(i);
            int card = tag.m_128451_("card");
            int index = tag.m_128451_("index");
            boolean single = tag.m_128471_("single");
            String ticket = tag.m_128441_("ticket") ? tag.m_128461_("ticket") : null;
            Parameter parameter = null;
            if (tag.m_128441_("parameter")) {
                parameter = ParameterTools.readFromNBT(tag.m_128469_("parameter"));
            }
            this.eventQueue.add(new QueuedEvent(card, new CompiledEvent(index, single), ticket, parameter));
        }
    }

    private void readCardInfo(CompoundTag tagCompound) {
        ListTag cardInfoList = tagCompound.m_128437_("cardInfo", 10);
        for (int i = 0; i < cardInfoList.size(); ++i) {
            this.cardInfo[i] = CardInfo.readFromNBT(cardInfoList.m_128728_(i));
        }
    }

    protected void saveInfo(CompoundTag tagCompound) {
        super.saveInfo(tagCompound);
        CompoundTag info = this.getOrCreateInfo(tagCompound);
        info.m_128405_("tickCount", this.tickCount);
        info.m_128359_("channel", this.channel == null ? "" : this.channel);
        info.m_128379_("exclusive", this.exclusive);
        info.m_128344_("hud", (byte)this.showHud);
        if (this.lastException != null) {
            info.m_128359_("lastExc", this.lastException);
            info.m_128356_("lastExcT", this.lastExceptionTime);
        }
        this.writeCardInfo(info);
        this.writeCores(info);
        this.writeEventQueue(info);
        this.writeLog(info);
        this.writeVariables(info);
        this.writeNetworkNodes(info);
        this.writeCraftingStations(info);
        this.writeWaitingForItems(info);
        this.writeLocks(info);
        this.writeRunningEvents(info);
        this.writeGraphicsOperation(info);
    }

    private void writeGraphicsOperation(CompoundTag tagCompound) {
        CompoundTag opTag = new CompoundTag();
        for (Map.Entry<String, GfxOp> entry : this.gfxOps.entrySet()) {
            opTag.m_128365_(entry.getKey(), (Tag)entry.getValue().writeToNBT());
        }
        tagCompound.m_128365_("gfxop", (Tag)opTag);
    }

    private void writeRunningEvents(CompoundTag tagCompound) {
        ListTag evList = new ListTag();
        for (Pair<Integer, Integer> pair : this.runningEvents) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("card", ((Integer)pair.getLeft()).intValue());
            tag.m_128405_("event", ((Integer)pair.getRight()).intValue());
            evList.add((Object)tag);
        }
        tagCompound.m_128365_("singev", (Tag)evList);
    }

    private void writeLocks(CompoundTag tagCompound) {
        ListTag lockList = new ListTag();
        for (String name : this.locks) {
            lockList.add((Object)StringTag.m_129297_((String)name));
        }
        tagCompound.m_128365_("locks", (Tag)lockList);
    }

    private void writeWaitingForItems(CompoundTag tagCompound) {
        ListTag waitingList = new ListTag();
        for (WaitForItem waitingForItem : this.waitingForItems) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("ticket", waitingForItem.ticket());
            if (waitingForItem.inventory() != null) {
                tag.m_128365_("inv", (Tag)InventoryUtil.writeToNBT(waitingForItem.inventory()));
            }
            if (!waitingForItem.itemStack().m_41619_()) {
                tag.m_128365_("item", (Tag)waitingForItem.itemStack().serializeNBT());
            }
            waitingList.add((Object)tag);
        }
        tagCompound.m_128365_("waiting", (Tag)waitingList);
    }

    private void writeCraftingStations(CompoundTag tagCompound) {
        ListTag stationList = new ListTag();
        for (BlockPos pos : this.craftingStations) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("nodex", pos.m_123341_());
            tag.m_128405_("nodey", pos.m_123342_());
            tag.m_128405_("nodez", pos.m_123343_());
            stationList.add((Object)tag);
        }
        tagCompound.m_128365_("stations", (Tag)stationList);
    }

    private void writeNetworkNodes(CompoundTag tagCompound) {
        ListTag networkList = new ListTag();
        for (Map.Entry<String, BlockPos> entry : this.networkNodes.entrySet()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("name", entry.getKey());
            tag.m_128405_("nodex", entry.getValue().m_123341_());
            tag.m_128405_("nodey", entry.getValue().m_123342_());
            tag.m_128405_("nodez", entry.getValue().m_123343_());
            networkList.add((Object)tag);
        }
        tagCompound.m_128365_("nodes", (Tag)networkList);
    }

    private void writeVariables(CompoundTag tagCompound) {
        ListTag varList = new ListTag();
        for (int i = 0; i < 32; ++i) {
            if (this.variables[i] == null) continue;
            CompoundTag var = ParameterTools.writeToNBT(this.variables[i]);
            var.m_128405_("varidx", i);
            if (this.watchInfos[i] != null) {
                var.m_128379_("watch", this.watchInfos[i].isBreakOnChange());
            }
            varList.add((Object)var);
        }
        tagCompound.m_128365_("vars", (Tag)varList);
    }

    private void writeLog(CompoundTag tagCompound) {
        ListTag logList = new ListTag();
        for (String message : this.logMessages) {
            logList.add((Object)StringTag.m_129297_((String)message));
        }
        tagCompound.m_128365_("log", (Tag)logList);
    }

    private void writeCores(CompoundTag tagCompound) {
        ListTag coreList = new ListTag();
        for (CpuCore core : this.cpuCores) {
            coreList.add((Object)core.writeToNBT());
        }
        tagCompound.m_128365_("cores", (Tag)coreList);
    }

    private void writeEventQueue(CompoundTag tagCompound) {
        ListTag eventQueueList = new ListTag();
        for (QueuedEvent queuedEvent : this.eventQueue) {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("card", queuedEvent.cardIndex());
            tag.m_128405_("index", queuedEvent.compiledEvent().index());
            tag.m_128379_("single", queuedEvent.compiledEvent().single());
            if (queuedEvent.ticket() != null) {
                tag.m_128359_("ticket", queuedEvent.ticket());
            }
            if (queuedEvent.parameter() != null) {
                CompoundTag parTag = ParameterTools.writeToNBT(queuedEvent.parameter());
                tag.m_128365_("parameter", (Tag)parTag);
            }
            eventQueueList.add((Object)tag);
        }
        tagCompound.m_128365_("events", (Tag)eventQueueList);
    }

    private void writeCardInfo(CompoundTag tagCompound) {
        ListTag cardInfoList = new ListTag();
        for (CardInfo info : this.cardInfo) {
            cardInfoList.add((Object)info.writeToNBT());
        }
        tagCompound.m_128365_("cardInfo", (Tag)cardInfoList);
    }

    public boolean isFluidAllocated(int cardIndex, int fluidIndex) {
        if (cardIndex == -1) {
            for (CardInfo info : this.cardInfo) {
                int fluidAlloc = info.getFluidAllocation();
                if ((fluidAlloc >> fluidIndex & 1) == 0) continue;
                return true;
            }
            return false;
        }
        CardInfo info = this.getCardInfo(cardIndex);
        int fluidA = info.getFluidAllocation();
        return (fluidA >> fluidIndex & 1) != 0;
    }

    public boolean isVarAllocated(int cardIndex, int varIndex) {
        if (cardIndex == -1) {
            for (CardInfo info : this.cardInfo) {
                int varAlloc = info.getVarAllocation();
                if ((varAlloc >> varIndex & 1) == 0) continue;
                return true;
            }
            return false;
        }
        CardInfo info = this.getCardInfo(cardIndex);
        int varAlloc = info.getVarAllocation();
        return (varAlloc >> varIndex & 1) != 0;
    }

    public boolean isItemAllocated(int cardIndex, int itemIndex) {
        if (cardIndex == -1) {
            for (CardInfo info : this.cardInfo) {
                int itemAlloc = info.getItemAllocation();
                if ((itemAlloc >> itemIndex & 1) == 0) continue;
                return true;
            }
            return false;
        }
        CardInfo info = this.getCardInfo(cardIndex);
        int itemAlloc = info.getItemAllocation();
        return (itemAlloc >> itemIndex & 1) != 0;
    }

    public CardInfo getCardInfo(int index) {
        return this.cardInfo[index];
    }

    public CompiledCard getCompiledCard(int index) {
        CardInfo info = this.getCardInfo(index);
        CompiledCard card = info.getCompiledCard();
        ItemStack cardStack = this.items.getStackInSlot(index + 16);
        if (card == null && !cardStack.m_41619_()) {
            card = CompiledCard.compile(ProgramCardInstance.parseInstance(cardStack));
            this.cardInfo[index].setCompiledCard(card);
        }
        return card;
    }

    private void allocate(int card, int itemAlloc, int varAlloc, int fluidAlloc) {
        this.cardInfo[card].setItemAllocation(itemAlloc);
        this.cardInfo[card].setVarAllocation(varAlloc);
        this.cardInfo[card].setFluidAllocation(fluidAlloc);
        this.m_6596_();
    }

    public void showNetworkInfo() {
        this.log("Channel: " + this.channel);
        this.log("Nodes: " + this.networkNodes.size());
    }

    public void listNodes() {
        if (this.networkNodes.isEmpty() && this.craftingStations.isEmpty()) {
            this.log("No nodes or crafting stations!");
        } else {
            for (Map.Entry<String, BlockPos> entry : this.networkNodes.entrySet()) {
                this.log(ChatFormatting.GREEN + "Node " + ChatFormatting.YELLOW + entry.getKey() + ChatFormatting.GREEN + " at " + ChatFormatting.YELLOW + BlockPosTools.toString((BlockPos)entry.getValue()));
            }
            for (BlockPos station : this.craftingStations) {
                this.log(ChatFormatting.GREEN + "Crafting station at " + ChatFormatting.YELLOW + BlockPosTools.toString((BlockPos)station));
            }
        }
    }

    public void setupNetwork(String name) {
        this.channel = name;
        this.m_6596_();
    }

    public void redstoneNodeChange(int previousMask, int newMask, String node) {
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            this.handleEventsRedstoneOn(i, compiledCard, node, previousMask, newMask);
            this.handleEventsRedstoneOff(i, compiledCard, node, previousMask, newMask);
        }
    }

    public void scanNodes() {
        if (!this.hasNetworkCard()) {
            this.log(ChatFormatting.RED + "No network card!");
            return;
        }
        if (this.channel == null || this.channel.isEmpty()) {
            this.log(ChatFormatting.RED + "Setup a channel first!");
            return;
        }
        this.networkNodes.clear();
        this.craftingStations.clear();
        int range = this.hasNetworkCard == 0 ? 8 : 16;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos n = new BlockPos(this.f_58858_.m_123341_() + x, this.f_58858_.m_123342_() + y, this.f_58858_.m_123343_() + z);
                    BlockEntity te = this.f_58857_.m_7702_(n);
                    if (te instanceof NodeTileEntity) {
                        NodeTileEntity node = (NodeTileEntity)te;
                        if (!this.channel.equals(node.getChannelName())) continue;
                        if (node.getNodeName() == null || node.getNodeName().isEmpty()) {
                            this.log("Node is missing a name!");
                            continue;
                        }
                        this.networkNodes.put(node.getNodeName(), n);
                        node.setProcessor(this.m_58899_());
                        continue;
                    }
                    if (!(te instanceof CraftingStationTileEntity)) continue;
                    CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
                    craftingStation.registerProcessor(this.f_58858_);
                    this.craftingStations.add(n);
                }
            }
        }
        this.log("Found " + this.networkNodes.size() + " node(s)");
        this.log("Found " + this.craftingStations.size() + " crafting station(s)");
        this.m_6596_();
    }

    private boolean isValidExpansionItem(Item item) {
        Item storageCardItem = (Item)RFToolsStuff.STORAGE_CONTROL_MODULE.get();
        return item == ProcessorModule.GRAPHICS_CARD.get() || item == ProcessorModule.NETWORK_CARD.get() || item == ProcessorModule.ADVANCED_NETWORK_CARD.get() || item == ProcessorModule.CPU_CORE_500.get() || item == ProcessorModule.CPU_CORE_1000.get() || item == ProcessorModule.CPU_CORE_2000.get() || item == ProcessorModule.RAM_CHIP.get() || item == storageCardItem || item instanceof FilterModuleItem;
    }

    private void onUpdateCard(int index) {
        if (this.isCardSlot(index)) {
            this.removeCard(index - 16);
            this.cardsDirty = true;
        } else if (this.isExpansionSlot(index)) {
            this.clearExpansions();
        }
    }

    public AABB getRenderBoundingBox() {
        int xCoord = this.m_58899_().m_123341_();
        int yCoord = this.m_58899_().m_123342_();
        int zCoord = this.m_58899_().m_123343_();
        return new AABB((double)xCoord, (double)yCoord, (double)zCoord, (double)(xCoord + 1), (double)(yCoord + 21), (double)(zCoord + 1));
    }

    private static /* synthetic */ Boolean lambda$pushItemsWorkbench$8(ItemStack card, int slot1, int slot2, CardInfo info, IItemHandler itemHandler, IItemHandler gridHandler) {
        List ingredients = CraftingCardItem.getIngredientsGrid((ItemStack)card);
        boolean success = true;
        for (int i = 0; i < 9; ++i) {
            ItemStack stackInWorkbench = gridHandler.getStackInSlot(i);
            Ingredient stackInIngredient = (Ingredient)ingredients.get(i);
            if (!stackInWorkbench.m_41619_() && stackInIngredient == Ingredient.f_43901_) {
                success = false;
                continue;
            }
            if (stackInWorkbench.m_41619_() && stackInIngredient != Ingredient.f_43901_) {
                boolean found = false;
                for (int slot = slot1; slot <= slot2; ++slot) {
                    int realSlot = info.getRealSlot(slot);
                    ItemStack localStack = itemHandler.getStackInSlot(realSlot);
                    if (!stackInIngredient.test(localStack)) continue;
                    localStack = itemHandler.extractItem(realSlot, LogicInventoryTools.getCountFromIngredient(stackInIngredient), false);
                    gridHandler.insertItem(i, localStack, false);
                    found = true;
                    break;
                }
                if (found) continue;
                success = false;
                continue;
            }
            if (stackInWorkbench.m_41619_() || stackInIngredient == Ingredient.f_43901_) continue;
            if (!stackInIngredient.test(stackInWorkbench)) {
                success = false;
                continue;
            }
            if (LogicInventoryTools.getCountFromIngredient(stackInIngredient) <= stackInWorkbench.m_41613_()) continue;
            success = false;
        }
        return success;
    }
}

