/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.control.parameters.BlockSide;
import mcjty.rftoolsbase.api.control.parameters.Inventory;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.StringUtils;

public class LogicInventoryTools {
    public static int countItem(@Nullable IItemHandler itemHandler, @Nullable IStorageScanner scanner, Ingredient itemMatcher, int maxToCount) {
        if (itemHandler != null) {
            int cnt = 0;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (!itemMatcher.test(stack) || maxToCount == -1 || (cnt += stack.m_41613_()) < maxToCount) continue;
                return maxToCount;
            }
            return cnt;
        }
        if (scanner != null) {
            int cnt = scanner.countItems((Predicate)itemMatcher, true, null);
            if (maxToCount != -1 && cnt >= maxToCount) {
                return maxToCount;
            }
            return cnt;
        }
        return 0;
    }

    public static boolean areItemsEqual(ItemStack item1, ItemStack item2, boolean damage, boolean nbt) {
        if (item1.m_41720_() != item2.m_41720_()) {
            return false;
        }
        if (damage && item1.m_41773_() != item2.m_41773_()) {
            return false;
        }
        return !nbt || ItemStack.m_150942_((ItemStack)item1, (ItemStack)item2);
    }

    private static boolean isItemEqual(ItemStack thisItem, ItemStack other) {
        if (other.m_41619_()) {
            return false;
        }
        return ItemStack.m_41656_((ItemStack)thisItem, (ItemStack)other);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ItemStack extractItem(@Nullable IItemHandler itemHandler, @Nullable IStorageScanner scanner, @Nullable Integer amount, boolean routable, @Nonnull Ingredient itemMatcher, @Nullable Integer slot) {
        block14: {
            block13: {
                int n;
                block11: {
                    int n2;
                    block12: {
                        if (itemHandler == null) break block11;
                        if (slot != null) break block12;
                        if (itemMatcher == Ingredient.f_43901_) break block13;
                        break block14;
                    }
                    if (itemMatcher == Ingredient.f_43901_) {
                        int n3;
                        int n4 = slot;
                        if (amount == null) {
                            n3 = 64;
                            return itemHandler.extractItem(n4, n3, false);
                        }
                        n3 = amount;
                        return itemHandler.extractItem(n4, n3, false);
                    }
                    if (!itemMatcher.test(itemHandler.getStackInSlot(slot.intValue()))) {
                        return ItemStack.f_41583_;
                    }
                    int n5 = slot;
                    if (amount == null) {
                        n2 = LogicInventoryTools.getMaxStackSizeFromIngredient(itemMatcher);
                        return itemHandler.extractItem(n5, n2, false);
                    }
                    n2 = amount;
                    return itemHandler.extractItem(n5, n2, false);
                }
                if (scanner == null) return ItemStack.f_41583_;
                if (amount == null) {
                    n = LogicInventoryTools.getMaxStackSizeFromIngredient(itemMatcher);
                    return scanner.requestItem((Predicate)itemMatcher, false, n, routable);
                }
                n = amount;
                return scanner.requestItem((Predicate)itemMatcher, false, n, routable);
            }
            int i = 0;
            while (i < itemHandler.getSlots()) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (!(stack.m_41619_() || amount != null && amount > stack.m_41613_())) {
                    int n;
                    if (amount == null) {
                        n = 64;
                        return itemHandler.extractItem(i, n, false);
                    }
                    n = amount;
                    return itemHandler.extractItem(i, n, false);
                }
                ++i;
            }
            return ItemStack.f_41583_;
        }
        int i = 0;
        while (i < itemHandler.getSlots()) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (itemMatcher.test(stack)) {
                int n;
                if (amount == null) {
                    n = LogicInventoryTools.getMaxStackSizeFromIngredient(itemMatcher);
                    return itemHandler.extractItem(i, n, false);
                }
                n = amount;
                return itemHandler.extractItem(i, n, false);
            }
            ++i;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack extractItem(@Nullable IItemHandler itemHandler, int amount, @Nonnull Predicate<ItemStack> itemMatcher) {
        if (itemHandler != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (!itemMatcher.test(stack)) continue;
                return itemHandler.extractItem(i, amount, false);
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack tryExtractItem(@Nullable IItemHandler itemHandler, int amount, Predicate<ItemStack> itemMatcher) {
        if (itemHandler != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.m_41619_() || !itemMatcher.test(stack)) continue;
                return itemHandler.extractItem(i, amount, true);
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack tryExtractItem(@Nullable IItemHandler itemHandler, @Nullable IStorageScanner scanner, @Nullable Integer amount, boolean routable, Ingredient itemMatcher, @Nullable Integer slot) {
        if (itemHandler != null) {
            if (slot == null) {
                if (itemMatcher == Ingredient.f_43901_) {
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        ItemStack stack = itemHandler.getStackInSlot(i);
                        if (stack.m_41619_() || amount != null && amount > stack.m_41613_()) continue;
                        return itemHandler.extractItem(i, amount == null ? 64 : amount, true);
                    }
                } else {
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        ItemStack stack = itemHandler.getStackInSlot(i);
                        if (stack.m_41619_() || !itemMatcher.test(stack)) continue;
                        return itemHandler.extractItem(i, amount == null ? LogicInventoryTools.getMaxStackSizeFromIngredient(itemMatcher) : amount, true);
                    }
                }
            } else {
                if (itemMatcher == Ingredient.f_43901_) {
                    return itemHandler.extractItem(slot.intValue(), amount == null ? 64 : amount, true);
                }
                if (!itemMatcher.test(itemHandler.getStackInSlot(slot.intValue()))) {
                    return ItemStack.f_41583_;
                }
                return itemHandler.extractItem(slot.intValue(), amount == null ? LogicInventoryTools.getMaxStackSizeFromIngredient(itemMatcher) : amount, true);
            }
        }
        if (scanner != null) {
            return scanner.getItem((Predicate)itemMatcher, routable);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack insertItem(@Nullable IItemHandler itemHandler, @Nullable IStorageScanner scanner, @Nonnull ItemStack item, @Nullable Integer slot) {
        if (itemHandler != null) {
            if (slot == null) {
                return ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)item, (boolean)false);
            }
            return itemHandler.insertItem(slot.intValue(), item, false);
        }
        if (scanner != null) {
            int cnt = scanner.insertItem(item);
            if (cnt > 0) {
                ItemStack copy = item.m_41777_();
                copy.m_41764_(cnt);
                return copy;
            }
            return ItemStack.f_41583_;
        }
        return item;
    }

    public static String inventoryToString(Inventory inv) {
        Object s = StringUtils.left((String)inv.getSide().m_7912_().toUpperCase(), (int)1);
        if (inv.getIntSide() == null) {
            s = (String)s + "/*";
        } else {
            String is = StringUtils.left((String)inv.getIntSide().m_7912_().toUpperCase(), (int)1);
            s = (String)s + "/" + is;
        }
        if (inv.getNodeName() == null) {
            return s;
        }
        return inv.getNodeName() + " " + (String)s;
    }

    @Nullable
    public static Inventory inventoryFromString(String s) {
        if (s == null) {
            return null;
        }
        int indexOf = s.lastIndexOf(47);
        if (indexOf == -1) {
            return null;
        }
        if (s.length() <= indexOf + 1) {
            return null;
        }
        Direction side = LogicInventoryTools.getSideFromChar(s.charAt(indexOf - 1));
        if (side == null) {
            return null;
        }
        Direction intSide = LogicInventoryTools.getSideFromChar(s.charAt(indexOf + 1));
        int indexSpace = s.lastIndexOf(32);
        if (indexSpace <= 0) {
            return new Inventory(null, side, intSide);
        }
        return new Inventory(s.substring(0, indexSpace), side, intSide);
    }

    public static Direction getSideFromChar(char is) {
        return switch (is) {
            case '*' -> null;
            case 'D' -> Direction.DOWN;
            case 'U' -> Direction.UP;
            case 'W' -> Direction.WEST;
            case 'E' -> Direction.EAST;
            case 'S' -> Direction.SOUTH;
            case 'N' -> Direction.NORTH;
            default -> null;
        };
    }

    public static String blockSideToString(BlockSide bc) {
        String s = bc.getSide() == null ? "*" : StringUtils.left((String)bc.getSide().m_7912_().toUpperCase(), (int)1);
        if (bc.getNodeName() == null) {
            return s;
        }
        return bc.getNodeName() + " " + s;
    }

    @Nullable
    public static BlockSide blockSideFromString(String s) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return null;
        }
        Direction side = LogicInventoryTools.getSideFromChar(s.charAt(s.length() - 1));
        int indexOf = s.lastIndexOf(32);
        if (indexOf <= 0) {
            return new BlockSide(null, side);
        }
        return new BlockSide(s.substring(0, indexOf), side);
    }

    public static int getCountFromIngredient(Ingredient ingredient) {
        ItemStack[] stacks = ingredient.m_43908_();
        if (stacks.length > 0) {
            return stacks[0].m_41613_();
        }
        return 1;
    }

    public static int getMaxStackSizeFromIngredient(Ingredient ingredient) {
        ItemStack[] stacks = ingredient.m_43908_();
        if (stacks.length > 0) {
            return stacks[0].m_41741_();
        }
        return 1;
    }
}

