/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.editors;

import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.rftoolsbase.api.control.parameters.BlockSide;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.modules.processor.logic.editors.ParameterEditorCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import org.apache.commons.lang3.StringUtils;

public class SideEditor
extends AbstractParameterEditor {
    private TextField nameLabel;
    private ChoiceLabel label;

    private static Direction parseFacingSafe(String t) {
        if ("*".equals(t)) {
            return null;
        }
        return Direction.m_122402_((String)StringUtils.lowerCase((String)t));
    }

    @Override
    public void initialFocusInternal(Window window) {
        window.setTextFocus((Widget)this.nameLabel);
    }

    @Override
    public int getHeight() {
        return 35;
    }

    @Override
    public void build(Minecraft mc, Screen gui, Panel panel, ParameterEditorCallback callback) {
        Panel constantPanel = Widgets.vertical();
        this.nameLabel = (TextField)((TextField)new TextField().event(text -> callback.valueChanged(this.readValue())).addTextEnterEvent(newText -> this.closeWindow()).desiredWidth(50)).desiredHeight(14);
        constantPanel.children(new Widget[]{this.createLabeledPanel(mc, gui, "Node name:", (Widget<?>)this.nameLabel, "Optional name of a node in the network")});
        this.label = (ChoiceLabel)new ChoiceLabel().choices(new String[]{"*", "Down", "Up", "North", "South", "West", "East"}).event(newChoice -> callback.valueChanged(this.readValue())).desiredWidth(60);
        constantPanel.children(new Widget[]{this.createLabeledPanel(mc, gui, "Side:", (Widget<?>)this.label, "Side relative to processor or node", "for the desired block")});
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_SIDE);
    }

    @Override
    protected ParameterValue readConstantValue() {
        BlockSide side = new BlockSide(this.nameLabel.getText(), SideEditor.parseFacingSafe(this.label.getCurrentChoice()));
        return ParameterValue.constant((Object)side);
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.nameLabel.text("");
            this.label.choice("*");
        } else {
            BlockSide side = (BlockSide)value.getValue();
            this.nameLabel.text(side.getNodeNameSafe());
            String choice = StringUtils.capitalize((String)side.toString());
            this.label.choice(choice);
        }
    }
}

