/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.crafting;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.p3pp3rf1y.sophisticatedcore.crafting.ItemEnabledCondition;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;

public class ShapeBasedRecipeBuilder {
    private static final RecipeCategory RECIPE_CATEGORY = RecipeCategory.MISC;
    private final Item itemResult;
    private final List<ICondition> conditions = new ArrayList<ICondition>();
    private final List<String> pattern = new ArrayList<String>();
    private final Map<Character, Ingredient> keyIngredients = Maps.newLinkedHashMap();
    private final RecipeSerializer<?> serializer;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    @Nullable
    private final CompoundTag nbt;

    public ShapeBasedRecipeBuilder(ItemLike itemResult, @Nullable CompoundTag nbt, RecipeSerializer<?> serializer) {
        this.itemResult = itemResult.m_5456_();
        this.serializer = serializer;
        this.nbt = nbt;
    }

    public static ShapeBasedRecipeBuilder shaped(ItemLike itemResult) {
        return ShapeBasedRecipeBuilder.shaped(itemResult, RecipeSerializer.f_44076_);
    }

    public static ShapeBasedRecipeBuilder shaped(ItemLike itemResult, RecipeSerializer<?> serializer) {
        return ShapeBasedRecipeBuilder.shaped(itemResult, null, serializer);
    }

    public static ShapeBasedRecipeBuilder shaped(ItemLike itemResult, @Nullable CompoundTag nbt, RecipeSerializer<?> serializer) {
        return new ShapeBasedRecipeBuilder(itemResult, nbt, serializer);
    }

    public static ShapeBasedRecipeBuilder shaped(ItemStack stack) {
        return ShapeBasedRecipeBuilder.shaped((ItemLike)stack.m_41720_(), stack.m_41783_(), RecipeSerializer.f_44076_);
    }

    public ShapeBasedRecipeBuilder define(Character symbol, TagKey<Item> tagIn) {
        return this.define(symbol, Ingredient.m_204132_(tagIn));
    }

    public ShapeBasedRecipeBuilder define(Character symbol, ItemLike itemIn) {
        return this.define(symbol, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemIn}));
    }

    public ShapeBasedRecipeBuilder define(Character symbol, Ingredient ingredientIn) {
        if (this.keyIngredients.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
        }
        if (symbol.charValue() == ' ') {
            throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
        }
        this.keyIngredients.put(symbol, ingredientIn);
        return this;
    }

    public ShapeBasedRecipeBuilder pattern(String patternIn) {
        if (!this.pattern.isEmpty() && patternIn.length() != this.pattern.get(0).length()) {
            throw new IllegalArgumentException("Pattern must be the same width on every line!");
        }
        this.pattern.add(patternIn);
        return this;
    }

    public ShapeBasedRecipeBuilder unlockedBy(String name, CriterionTriggerInstance criterion) {
        this.advancementBuilder.m_138386_(name, criterion);
        return this;
    }

    public void save(Consumer<FinishedRecipe> consumerIn) {
        this.save(consumerIn, RegistryHelper.getItemKey(this.itemResult));
    }

    public void save(Consumer<FinishedRecipe> consumerIn, ResourceLocation id) {
        this.ensureValid(id);
        this.advancementBuilder.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)id)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)id)).m_138360_(RequirementsStrategy.f_15979_);
        consumerIn.accept(new Result(id, this.conditions, this.itemResult, this.nbt, this.pattern, this.keyIngredients, this.advancementBuilder, new ResourceLocation(id.m_135827_(), "recipes/" + RECIPE_CATEGORY.m_247710_() + "/" + id.m_135815_()), this.serializer));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.pattern.isEmpty()) {
            throw new IllegalStateException("No pattern is defined for shaped recipe " + id + "!");
        }
        HashSet set = Sets.newHashSet(this.keyIngredients.keySet());
        set.remove(Character.valueOf(' '));
        for (String s : this.pattern) {
            for (int i = 0; i < s.length(); ++i) {
                char c0 = s.charAt(i);
                if (!this.keyIngredients.containsKey(Character.valueOf(c0)) && c0 != ' ') {
                    throw new IllegalStateException("Pattern in recipe " + id + " uses undefined symbol '" + c0 + "'");
                }
                set.remove(Character.valueOf(c0));
            }
        }
        if (!set.isEmpty()) {
            throw new IllegalStateException("Ingredients are defined but not used in pattern for recipe " + id);
        }
        if (this.pattern.size() == 1 && this.pattern.get(0).length() == 1) {
            throw new IllegalStateException("Shaped recipe " + id + " only takes in a single item - should it be a shapeless recipe instead?");
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final List<ICondition> conditions;
        private final Item itemResult;
        @Nullable
        private final CompoundTag nbt;
        private final List<String> pattern;
        private final Map<Character, Ingredient> key;
        private final ResourceLocation advancementId;
        private final RecipeSerializer<?> serializer;
        private final Advancement.Builder advancementBuilder;

        public Result(ResourceLocation id, List<ICondition> conditions, Item itemResult, @Nullable CompoundTag nbt, List<String> pattern, Map<Character, Ingredient> keyIngredients, Advancement.Builder advancementBuilder, ResourceLocation advancementId, RecipeSerializer<?> serializer) {
            this.id = id;
            this.conditions = conditions;
            this.itemResult = itemResult;
            this.nbt = nbt;
            this.pattern = pattern;
            this.key = keyIngredients;
            this.advancementId = advancementId;
            this.serializer = serializer;
            this.advancementBuilder = advancementBuilder;
            conditions.add(new ItemEnabledCondition(itemResult));
        }

        public void m_7917_(JsonObject json) {
            JsonArray conditionsArray = new JsonArray();
            this.conditions.forEach(c -> conditionsArray.add((JsonElement)CraftingHelper.serialize((ICondition)c)));
            json.add("conditions", (JsonElement)conditionsArray);
            JsonArray jsonarray = new JsonArray();
            for (String string : this.pattern) {
                jsonarray.add(string);
            }
            json.add("pattern", (JsonElement)jsonarray);
            JsonObject jsonobject = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.key.entrySet()) {
                jsonobject.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            json.add("key", (JsonElement)jsonobject);
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", RegistryHelper.getItemKey(this.itemResult).toString());
            if (this.nbt != null) {
                jsonObject.addProperty("nbt", this.nbt.toString());
            }
            json.add("result", (JsonElement)jsonObject);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancementBuilder.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

