/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.core.adapter.recipe.RecipeBuilderMC;
import org.zeith.hammerlib.core.adapter.recipe.RecipeShape;
import org.zeith.hammerlib.core.recipes.HLShapedRecipe;
import org.zeith.hammerlib.core.recipes.replacers.IRemainingItemReplacer;
import org.zeith.hammerlib.core.recipes.replacers.RemainingReplacerRegistrar;
import org.zeith.hammerlib.util.mcf.itf.IRecipeRegistrationEvent;

public class ShapedRecipeBuilder
extends RecipeBuilderMC<ShapedRecipeBuilder> {
    protected final Map<Character, Ingredient> dictionary = new HashMap<Character, Ingredient>();
    protected final List<ResourceLocation> replacers = new ArrayList<ResourceLocation>();
    protected RecipeShape shape;
    protected CraftingBookCategory category = CraftingBookCategory.MISC;

    public ShapedRecipeBuilder(IRecipeRegistrationEvent<Recipe<?>> event) {
        super(event);
    }

    public ShapedRecipeBuilder replacers(IRemainingItemReplacer ... replacers) {
        Stream.of(replacers).map(RemainingReplacerRegistrar::key).filter(Objects::nonNull).forEach(this.replacers::add);
        return this;
    }

    public ShapedRecipeBuilder category(CraftingBookCategory cat) {
        this.category = cat;
        return this;
    }

    public ShapedRecipeBuilder shape(int width, int height, String ... shapeKeys) {
        this.shape = new RecipeShape(width, height, shapeKeys);
        return this;
    }

    public ShapedRecipeBuilder shape(String ... shapeKeys) {
        this.shape = new RecipeShape(shapeKeys);
        return this;
    }

    public ShapedRecipeBuilder map(char c, Object ingredient) {
        this.dictionary.put(Character.valueOf(c), RecipeHelper.fromComponent(ingredient));
        return this;
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.shape == null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " does not have a defined shape!");
        }
        if (this.dictionary.isEmpty()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " does not have any defined ingredients!");
        }
    }

    @Override
    public void register() {
        this.validate();
        if (!this.event.enableRecipe(RecipeType.f_44107_, this.getIdentifier())) {
            return;
        }
        ResourceLocation id = this.getIdentifier();
        HLShapedRecipe rec = new HLShapedRecipe(id, this.group, this.category, this.shape.width, this.shape.height, this.shape.createIngredientMap(this.dictionary), this.result);
        rec.addReplacers(this.replacers);
        this.event.register(id, rec);
    }
}

