/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.api.recipes.RecipeBuilderExtension;
import org.zeith.hammerlib.core.adapter.recipe.BlastingRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.CampfireRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.ShapedRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.ShapelessRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.SmeltingRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.SmokingRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.StoneCutterRecipeBuilder;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.mcf.RecipeRegistrationContext;
import org.zeith.hammerlib.util.mcf.itf.IRecipeRegistrationEvent;

public class RegisterRecipesEvent
extends Event
implements IRecipeRegistrationEvent<Recipe<?>>,
IModBusEvent {
    private final List<Recipe<?>> recipes = Lists.newArrayList();
    private final Set<ResourceLocation> removeRecipes = Sets.newHashSet();
    private final Predicate<ResourceLocation> idInUse;
    protected String contextModId;
    private final Map<String, RecipeRegistrationContext> contextMap = Maps.newHashMap();
    private final Map<Class<?>, RecipeBuilderExtension> extensions;

    public RegisterRecipesEvent(Predicate<ResourceLocation> idInUse) {
        this.idInUse = idInUse;
        this.extensions = RecipeBuilderExtension.attach(this);
    }

    public void setContextModId(String contextModId) {
        this.contextModId = contextModId;
    }

    @Nullable
    public <T extends RecipeBuilderExtension> T extension(Class<T> type) {
        return (T)((RecipeBuilderExtension)Cast.cast(this.extensions.get(type), type));
    }

    public void add(Recipe<?> recipe) {
        if (recipe == null || !this.enableRecipe(recipe)) {
            return;
        }
        this.recipes.add(recipe);
    }

    public boolean register(Recipe<?> recipe) {
        if (recipe != null && this.enableRecipe(recipe.m_6671_(), recipe.m_6423_())) {
            this.recipes.add(recipe);
            return true;
        }
        return false;
    }

    public Set<ResourceLocation> removedRecipes() {
        return Collections.unmodifiableSet(this.removeRecipes);
    }

    public RegisterRecipesEvent removeRecipe(ResourceLocation id) {
        this.removeRecipes.add(id);
        return this;
    }

    public StoneCutterRecipeBuilder stoneCutting() {
        return new StoneCutterRecipeBuilder(this);
    }

    public SmokingRecipeBuilder smoking() {
        return new SmokingRecipeBuilder(this);
    }

    public BlastingRecipeBuilder blasting() {
        return new BlastingRecipeBuilder(this);
    }

    public CampfireRecipeBuilder campfire() {
        return new CampfireRecipeBuilder(this);
    }

    public SmeltingRecipeBuilder smelting() {
        return new SmeltingRecipeBuilder(this);
    }

    public ShapedRecipeBuilder shaped() {
        return new ShapedRecipeBuilder(this);
    }

    public ShapelessRecipeBuilder shapeless() {
        return new ShapelessRecipeBuilder(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRecipeIdTaken(ResourceLocation id) {
        if (this.idInUse.test(id)) return true;
        if (!this.recipes.stream().map(Recipe::m_6423_).anyMatch(arg_0 -> ((ResourceLocation)id).equals(arg_0))) return false;
        return true;
    }

    protected ResourceLocation transformRecipeIdToContext(ResourceLocation loc) {
        if (this.contextModId == null) {
            return loc;
        }
        if (loc.m_135827_().equals(this.contextModId)) {
            return loc;
        }
        return new ResourceLocation(this.contextModId, loc.m_135827_() + "/" + loc.m_135815_());
    }

    @Override
    public ResourceLocation nextId(Item item) {
        ResourceLocation tf;
        if (item == null || item == Items.f_41852_) {
            return null;
        }
        ResourceLocation rl = this.transformRecipeIdToContext(ForgeRegistries.ITEMS.getKey((Object)item));
        if (!this.isRecipeIdTaken(rl)) {
            return rl;
        }
        int lastIdx = 1;
        while (this.isRecipeIdTaken(tf = this.transformRecipeIdToContext(rl = new ResourceLocation(rl.m_135827_(), rl.m_135815_() + "_" + lastIdx++)))) {
        }
        return tf;
    }

    @Override
    public void register(ResourceLocation id, Recipe<?> entry) {
        this.add(entry);
    }

    public Stream<Recipe<?>> getRecipes() {
        return this.recipes.stream();
    }

    @Override
    public boolean enableRecipe(RecipeType<?> type, ResourceLocation recipeId) {
        return this.getContext(recipeId.m_135827_()).enableRecipe(type, recipeId);
    }

    public boolean enableRecipe(Recipe<?> recipe) {
        return this.enableRecipe(recipe.m_6671_(), recipe.m_6423_());
    }

    public RecipeRegistrationContext getContext(String modid) {
        return this.contextMap.computeIfAbsent(modid, RecipeRegistrationContext::load);
    }

    @ApiStatus.Internal
    public void cleanup() {
        for (RecipeRegistrationContext value : this.contextMap.values()) {
            value.save();
        }
        this.contextMap.clear();
    }
}

