/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.java;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;

public class Cast {
    static final Map<Class, Constructor> emptyCtors = new HashMap<Class, Constructor>();

    public static BooleanSupplier constantB(boolean value) {
        return () -> value;
    }

    public static DoubleSupplier constantD(double value) {
        return () -> value;
    }

    public static IntSupplier constantI(int value) {
        return () -> value;
    }

    public static LongSupplier constantL(long value) {
        return () -> value;
    }

    public static <T> Supplier<T> constant(T value) {
        return () -> value;
    }

    public static <T> T get2(Supplier<Supplier<T>> suppl) {
        return suppl.get().get();
    }

    public static <T> Supplier<T> supply(Object thing, Class<T> type) {
        Object result = Cast.cast(thing, type);
        return () -> result;
    }

    @Nonnull
    public static <T> Optional<T> optionally(Object thing, Class<T> type) {
        return type.isInstance(thing) ? Optional.of(type.cast(thing)) : Optional.empty();
    }

    public static <IN, T> Function<IN, T> convertTo(Class<T> type) {
        return obj -> Cast.cast(obj, type);
    }

    public static <T> Optional<T> firstInstanceof(Class<T> type, Object ... input) {
        for (Object i : input) {
            if (i == null || !type.isAssignableFrom(i.getClass())) continue;
            return Optional.of(type.cast(i));
        }
        return Optional.empty();
    }

    public static <T> T or(T ... input) {
        for (T i : input) {
            if (i == null) continue;
            return i;
        }
        return null;
    }

    @Nullable
    public static <T> T cast(Object thing, Class<T> type) {
        if (thing == null || type == null) {
            return null;
        }
        if (type.isAssignableFrom(thing.getClass())) {
            return type.cast(thing);
        }
        return null;
    }

    @Contract(value="null -> null; _ -> _")
    public static <T> T cast(Object thing) {
        return (T)thing;
    }

    public static <T> Supplier<T> newInstanceSupplier(Class<T> type) {
        return () -> Cast.newInstance(type);
    }

    public static <T> T newInstance(Class<T> type) {
        try {
            Constructor<T> gen = emptyCtors.get(type);
            if (gen == null) {
                gen = type.getDeclaredConstructor(new Class[0]);
                gen.setAccessible(true);
                emptyCtors.put(type, gen);
            }
            return gen.newInstance(new Object[0]);
        }
        catch (Throwable err) {
            return null;
        }
    }

    public static <T> T newInstanceWithRE(Class<T> type) throws RuntimeException {
        try {
            Constructor<T> gen = emptyCtors.get(type);
            if (gen == null) {
                gen = type.getDeclaredConstructor(new Class[0]);
                gen.setAccessible(true);
                emptyCtors.put(type, gen);
            }
            return gen.newInstance(new Object[0]);
        }
        catch (Throwable err) {
            throw new RuntimeException(err);
        }
    }
}

