/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllCreativeModeTabs;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.content.decoration.palettes.AllPaletteStoneTypes;
import com.simibubi.create.content.fluids.VirtualFluid;
import com.simibubi.create.content.fluids.potion.PotionFluid;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class AllFluids {
    private static final CreateRegistrate REGISTRATE = Create.registrate();
    public static final FluidEntry<PotionFluid> POTION;
    public static final FluidEntry<VirtualFluid> TEA;
    public static final FluidEntry<ForgeFlowingFluid.Flowing> HONEY;
    public static final FluidEntry<ForgeFlowingFluid.Flowing> CHOCOLATE;
    private static final DispenseItemBehavior DEFAULT;
    private static final DispenseItemBehavior DISPENSE_FLUID;

    public static void register() {
    }

    public static void registerFluidInteractions() {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)HONEY.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return ((Block)AllPaletteStoneTypes.LIMESTONE.getBaseBlock().get()).m_49966_();
        }));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ForgeMod.LAVA_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation(((ForgeFlowingFluid.Flowing)CHOCOLATE.get()).getFluidType(), fluidState -> {
            if (fluidState.m_76170_()) {
                return Blocks.f_50080_.m_49966_();
            }
            return ((Block)AllPaletteStoneTypes.SCORIA.getBaseBlock().get()).m_49966_();
        }));
    }

    @Nullable
    public static BlockState getLavaInteraction(FluidState fluidState) {
        Fluid fluid = fluidState.m_76152_();
        if (fluid.m_6212_((Fluid)HONEY.get())) {
            return ((Block)AllPaletteStoneTypes.LIMESTONE.getBaseBlock().get()).m_49966_();
        }
        if (fluid.m_6212_((Fluid)CHOCOLATE.get())) {
            return ((Block)AllPaletteStoneTypes.SCORIA.getBaseBlock().get()).m_49966_();
        }
        return null;
    }

    private static void registerFluidDispenseBehavior(BucketItem bucket) {
        DispenserBlock.m_52672_((ItemLike)bucket, (DispenseItemBehavior)DISPENSE_FLUID);
    }

    static {
        REGISTRATE.setCreativeTab(AllCreativeModeTabs.BASE_CREATIVE_TAB);
        POTION = REGISTRATE.virtualFluid("potion", PotionFluid.PotionFluidType::new, PotionFluid::createSource, PotionFluid::createFlowing).lang("Potion").register();
        TEA = REGISTRATE.virtualFluid("tea").lang("Builder's Tea").tag(new TagKey[]{AllTags.AllFluidTags.TEA.tag}).register();
        HONEY = ((FluidBuilder)((ItemBuilder)((FluidBuilder)REGISTRATE.standardFluid("honey", SolidRenderedPlaceableFluidType.create(15380015, () -> Float.valueOf(0.125f * AllConfigs.client().honeyTransparencyMultiplier.getF()))).lang("Honey").properties(b -> b.viscosity(2000).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).tag(new TagKey[]{AllTags.AllFluidTags.HONEY.tag}).source(ForgeFlowingFluid.Source::new).block().properties(p -> p.m_284180_(MapColor.f_283843_)).build()).bucket().onRegister(AllFluids::registerFluidDispenseBehavior)).tag(new TagKey[]{AllTags.AllItemTags.HONEY_BUCKETS.tag}).build()).register();
        CHOCOLATE = ((FluidBuilder)((ItemBuilder)((FluidBuilder)REGISTRATE.standardFluid("chocolate", SolidRenderedPlaceableFluidType.create(0x622020, () -> Float.valueOf(0.03125f * AllConfigs.client().chocolateTransparencyMultiplier.getF()))).lang("Chocolate").tag(new TagKey[]{AllTags.AllFluidTags.CHOCOLATE.tag}).properties(b -> b.viscosity(1500).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).source(ForgeFlowingFluid.Source::new).block().properties(p -> p.m_284180_(MapColor.f_283774_)).build()).bucket().onRegister(AllFluids::registerFluidDispenseBehavior)).build()).register();
        DEFAULT = new DefaultDispenseItemBehavior();
        DISPENSE_FLUID = new DefaultDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource pSource, ItemStack pStack) {
                DispensibleContainerItem dispensibleContainerItem = (DispensibleContainerItem)pStack.m_41720_();
                BlockPos pos = pSource.m_7961_().m_121945_((Direction)pSource.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                ServerLevel level = pSource.m_7727_();
                if (dispensibleContainerItem.emptyContents(null, (Level)level, pos, null, pStack)) {
                    return new ItemStack((ItemLike)Items.f_42446_);
                }
                return DEFAULT.m_6115_(pSource, pStack);
            }
        };
    }

    private static class SolidRenderedPlaceableFluidType
    extends TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidType fluidType = new SolidRenderedPlaceableFluidType(p, s, f);
                fluidType.fogColor = new Color(fogColor, false).asVectorF();
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        private SolidRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        @Override
        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        @Override
        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }

        @Override
        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        @Override
        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }

    public static abstract class TintedFluidType
    extends FluidType {
        protected static final int NO_TINT = -1;
        private ResourceLocation stillTexture;
        private ResourceLocation flowingTexture;

        public TintedFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties);
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return stillTexture;
                }

                public ResourceLocation getFlowingTexture() {
                    return flowingTexture;
                }

                public int getTintColor(FluidStack stack) {
                    return this.getTintColor(stack);
                }

                public int getTintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                    return this.getTintColor(state, getter, pos);
                }

                @NotNull
                public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                    Vector3f customFogColor = this.getCustomFogColor();
                    return customFogColor == null ? fluidFogColor : customFogColor;
                }

                public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                    float modifier = this.getFogDistanceModifier();
                    float baseWaterFog = 96.0f;
                    if (modifier != 1.0f) {
                        RenderSystem.setShaderFogShape((FogShape)FogShape.CYLINDER);
                        RenderSystem.setShaderFogStart((float)-8.0f);
                        RenderSystem.setShaderFogEnd((float)(baseWaterFog * modifier));
                    }
                }
            });
        }

        protected abstract int getTintColor(FluidStack var1);

        protected abstract int getTintColor(FluidState var1, BlockAndTintGetter var2, BlockPos var3);

        protected Vector3f getCustomFogColor() {
            return null;
        }

        protected float getFogDistanceModifier() {
            return 1.0f;
        }
    }
}

