/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.gravelminer;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.gravelminer.GravelMiner;
import net.blay09.mods.gravelminer.GravelMinerConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class BlockBreakHandler {
    public static void blockBroken(BreakBlockEvent event) {
        int startY;
        Player player = event.getPlayer();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        if (Balm.getHooks().isFakePlayer(player) || !GravelMiner.isEnabledFor(player)) {
            return;
        }
        if (!GravelMinerConfig.getActive().common.triggerOnGravel && GravelMiner.isGravelBlock(state)) {
            return;
        }
        int maxCount = 256;
        for (int y = startY = pos.m_123342_() + 1; y <= startY + 256; ++y) {
            BlockPos posAbove = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
            BlockState stateAbove = level.m_8055_(posAbove);
            if (!GravelMiner.isGravelBlock(stateAbove)) {
                return;
            }
            BlockBreakHandler.playBreakBlockEffects(level, posAbove, stateAbove);
            if (BlockBreakHandler.breakBlock(player, level, posAbove, stateAbove)) continue;
            return;
        }
    }

    private static void playBreakBlockEffects(Level level, BlockPos pos, BlockState state) {
        int blockBreakEvent = 2001;
        level.m_5898_(null, 2001, pos, Block.m_49956_((BlockState)state));
    }

    private static boolean breakBlock(Player player, Level level, BlockPos pos, BlockState state) {
        FluidState fluidState = level.m_6425_(pos);
        state.m_60734_().m_5707_(level, pos, state, player);
        boolean removedByPlayer = level.m_7731_(pos, fluidState.m_76188_(), level.f_46443_ ? 11 : 3);
        if (!removedByPlayer) {
            return false;
        }
        if (!player.m_150110_().f_35937_) {
            state.m_60734_().m_6786_((LevelAccessor)level, pos, state);
            if (GravelMinerConfig.getActive().common.rollFlintChance || state.m_60734_() != Blocks.f_49994_) {
                state.m_60734_().m_6240_(level, player, pos, state, level.m_7702_(pos), ItemStack.f_41583_);
            } else {
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Blocks.f_49994_, 1));
            }
        }
        return true;
    }
}

