/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.gravelminer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.gravelminer.BlockBreakHandler;
import net.blay09.mods.gravelminer.GravelMinerClientSetting;
import net.blay09.mods.gravelminer.GravelMinerConfig;
import net.blay09.mods.gravelminer.network.HelloMessage;
import net.blay09.mods.gravelminer.network.ModNetworking;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;

public class GravelMiner {
    public static final String MOD_ID = "gravelminer";
    private static final Set<UUID> hasClientSide = new HashSet<UUID>();
    private static final Map<UUID, GravelMinerClientSetting> clientSettings = new HashMap<UUID, GravelMinerClientSetting>();
    public static boolean isServerInstalled;

    public static void initialize() {
        GravelMinerConfig.initialize();
        ModNetworking.initialize(Balm.getNetworking());
        Balm.getEvents().onEvent(PlayerLoginEvent.class, event -> Balm.getNetworking().sendTo((Player)event.getPlayer(), (Object)new HelloMessage()));
        Balm.getEvents().onEvent(BreakBlockEvent.class, BlockBreakHandler::blockBroken, EventPriority.Lowest);
    }

    public static boolean isAvailableFor(Player player) {
        return !GravelMinerConfig.getActive().common.isOptIn || hasClientSide.contains(player.m_20148_());
    }

    public static boolean isEnabledFor(Player player) {
        return GravelMiner.isAvailableFor(player) && clientSettings.getOrDefault(player.m_20148_(), GravelMinerClientSetting.DISABLED).isEnabled(player);
    }

    public static void setHasClientSide(Player player) {
        hasClientSide.add(player.m_20148_());
        GravelMiner.setClientSetting(player, GravelMinerClientSetting.ENABLED);
    }

    public static void setClientSetting(Player player, GravelMinerClientSetting setting) {
        clientSettings.put(player.m_20148_(), setting);
    }

    public static boolean isGravelBlock(BlockState state) {
        ResourceLocation registryName = state != null ? BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()) : null;
        return registryName != null && GravelMinerConfig.getActive().common.gravelBlocks.contains(registryName.toString());
    }
}

