/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.client.screen.control;

import com.google.common.base.Strings;
import it.zerono.mods.zerocore.base.BaseHelper;
import it.zerono.mods.zerocore.base.client.screen.BaseScreenToolTipsBuilder;
import it.zerono.mods.zerocore.base.client.screen.control.AbstractVerticalIconSingleValueGaugeBar;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.GaugeBar;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.FluidStackData;
import it.zerono.mods.zerocore.lib.text.TextHelper;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.fluids.FluidStack;

public class FluidBar
extends AbstractVerticalIconSingleValueGaugeBar {
    public FluidBar(ModContainerScreen<? extends ModContainer> gui, String name, int maxValue, FluidStackData bindableStack, NonNullSupplier<ISprite> iconSprite) {
        super(gui, name, maxValue, bindableStack.amount(), Sprite.EMPTY_SUPPLIER, iconSprite);
        bindableStack.bind(this::setFluidSprite);
    }

    public FluidBar(ModContainerScreen<? extends ModContainer> gui, String name, int maxValue, FluidStackData bindableStack, NonNullSupplier<ISprite> iconSprite, String titleTooltipLine, @Nullable String optionalTooltipLine) {
        this(gui, name, maxValue, bindableStack, iconSprite);
        BaseScreenToolTipsBuilder toolTips = new BaseScreenToolTipsBuilder().addTranslatableAsTitle(titleTooltipLine).addTranslatableAsValue("gui.zerocore.base.control.fluidbar.line2").addTextAsValue(TextHelper.translatable("gui.zerocore.base.control.fluidbar.line3a"), new Component[]{TextHelper.translatable("gui.zerocore.base.control.fluidbar.line3b", CodeHelper.formatAsMillibuckets(maxValue))}).addTextAsValue(TextHelper.translatable("gui.zerocore.base.control.fluidbar.line4a"), new Component[]{TextHelper.translatable("gui.zerocore.base.control.fluidbar.line4b")}).addBindableObjectAsValue(bindableStack, this::formatFluidText).addBindableObjectAsValue(bindableStack.amount(), this::formatAmountText).addBindableObjectAsValue(bindableStack.amount(), this::formatPercentageText);
        if (!Strings.isNullOrEmpty((String)optionalTooltipLine)) {
            toolTips.addEmptyLine();
            toolTips.addTranslatable(optionalTooltipLine);
        }
        this.setTooltips(toolTips);
    }

    public MutableComponent formatFluidText(FluidStack stack) {
        return BaseHelper.getFluidNameOrEmpty(stack);
    }

    public MutableComponent formatAmountText(int amount) {
        return TextHelper.literal(CodeHelper.formatAsMillibuckets(amount));
    }

    public MutableComponent formatPercentageText(int amount) {
        return TextHelper.literal("%d", (int)((double)amount / ((GaugeBar)this._bar).getMaxValue() * 100.0));
    }

    private void setFluidSprite(FluidStack stack) {
        if (stack.isEmpty()) {
            ((GaugeBar)this._bar).setBarSprite(Sprite.EMPTY);
            ((GaugeBar)this._bar).setBarSpriteTint(Colour.WHITE);
            ((GaugeBar)this._bar).setValue(0);
        } else {
            Fluid fluid = stack.getFluid();
            ISprite fluidSprite = ModRenderHelper.getStillFluidSprite(fluid);
            Colour fluidTint = Colour.fromARGB(ModRenderHelper.getFluidTint(stack));
            ((GaugeBar)this._bar).setBarSprite(fluidSprite);
            ((GaugeBar)this._bar).setBarSpriteTint(fluidTint);
            ((GaugeBar)this._bar).setValue(stack.getAmount());
        }
    }
}

