/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.base.client.screen.control;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.zerocore.base.client.screen.BaseScreenToolTipsBuilder;
import it.zerono.mods.zerocore.base.client.screen.control.CommonPanels;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractCompositeControl;
import it.zerono.mods.zerocore.lib.client.gui.control.ITableCellLayoutBuilder;
import it.zerono.mods.zerocore.lib.client.gui.control.ITableLayoutBuilder;
import it.zerono.mods.zerocore.lib.client.gui.control.Label;
import it.zerono.mods.zerocore.lib.client.gui.control.Picture;
import it.zerono.mods.zerocore.lib.client.gui.control.Table;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.Sprite;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IBindableData;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class InformationDisplay
extends Table {
    public InformationDisplay(ModContainerScreen<? extends ModContainer> gui, String name, NonNullConsumer<ITableLayoutBuilder> builder) {
        super(gui, name, builder);
    }

    public void addInformationCell(NonNullConsumer<InformationCellBuilder> builder) {
        InformationCellBuilder cellBuilder = (InformationCellBuilder)Util.m_137469_((Object)new InformationCellBuilder(), arg_0 -> builder.accept(arg_0));
        this.addCellContent(new InformationCell(this.getGui(), cellBuilder), cellBuilder._layoutBuilder);
    }

    public static class InformationCellBuilder {
        protected String _name = "cell";
        protected NonNullSupplier<ISprite> _iconSprite = Sprite.EMPTY_SUPPLIER;
        protected NonNullConsumer<Label> _labelTextConfig = $ -> {};
        protected List<Component> _tooltipsLines = ObjectLists.emptyList();
        protected List<Object> _tooltipsObjects = ObjectLists.emptyList();
        @Nullable
        protected IControl _tooltipsSource = null;
        protected NonNullConsumer<ITableCellLayoutBuilder> _layoutBuilder = $ -> {};

        protected InformationCellBuilder() {
        }

        public InformationCellBuilder name(String name) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Name must not be null or empty.");
            this._name = name;
            return this;
        }

        public InformationCellBuilder icon(NonNullSupplier<ISprite> sprite) {
            this._iconSprite = (NonNullSupplier)Preconditions.checkNotNull(sprite, (Object)"Sprite must not be null.");
            return this;
        }

        public InformationCellBuilder tooltips(List<Component> lines) {
            this._tooltipsLines = (List)Preconditions.checkNotNull(lines, (Object)"Lines must not be null");
            this._tooltipsObjects = ObjectLists.emptyList();
            this._tooltipsSource = null;
            return this;
        }

        public InformationCellBuilder tooltips(List<Component> lines, List<Object> objects) {
            this._tooltipsLines = (List)Preconditions.checkNotNull(lines, (Object)"Lines must not be null");
            this._tooltipsObjects = (List)Preconditions.checkNotNull(objects, (Object)"Objects must not be null");
            this._tooltipsSource = null;
            return this;
        }

        public InformationCellBuilder tooltips(BaseScreenToolTipsBuilder builder) {
            Preconditions.checkNotNull((Object)builder, (Object)"Builder must not be null.");
            ImmutablePair<List<Component>, List<Object>> values = builder.build();
            return this.tooltips((List)values.getLeft(), (List)values.getRight());
        }

        public InformationCellBuilder tooltips(NonNullConsumer<BaseScreenToolTipsBuilder> builder) {
            Preconditions.checkNotNull(builder, (Object)"Builder must not be null.");
            return this.tooltips((BaseScreenToolTipsBuilder)Util.m_137469_((Object)new BaseScreenToolTipsBuilder(), arg_0 -> builder.accept(arg_0)));
        }

        public InformationCellBuilder useTooltipsFrom(IControl source) {
            this._tooltipsSource = (IControl)Preconditions.checkNotNull((Object)source, (Object)"Source must not be null");
            this._tooltipsLines = ObjectLists.emptyList();
            this._tooltipsObjects = ObjectLists.emptyList();
            return this;
        }

        public InformationCellBuilder text(String text) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)text) ? 1 : 0) != 0, (Object)"Text must not be null or empty.");
            this._labelTextConfig = label -> label.setText(text);
            return this;
        }

        public <V> InformationCellBuilder bindText(IBindableData<V> bindableValue, Function<V, String> textFactory) {
            Preconditions.checkNotNull(bindableValue, (Object)"Bindable value must not be null.");
            Preconditions.checkNotNull(textFactory, (Object)"Text factory must not be null.");
            this._labelTextConfig = label -> {
                label.setText((String)textFactory.apply(bindableValue.defaultValue()));
                label.bindText(bindableValue, textFactory);
            };
            return this;
        }

        public InformationCellBuilder layout(NonNullConsumer<ITableCellLayoutBuilder> layoutBuilder) {
            Preconditions.checkNotNull(layoutBuilder, (Object)"Layout builder must not be null.");
            this._layoutBuilder = layoutBuilder;
            return this;
        }
    }

    private static class InformationCell
    extends AbstractCompositeControl {
        private final Picture _icon;
        private final Label _label;

        protected InformationCell(ModContainerScreen<? extends ModContainer> gui, InformationCellBuilder builder) {
            super(gui, builder._name);
            this.setPadding(0);
            this._label = new Label(gui, "lbl", "");
            this._label.useTooltipsFrom(this);
            builder._labelTextConfig.accept((Object)this._label);
            this._icon = CommonPanels.icon(gui, builder._iconSprite);
            this._icon.useTooltipsFrom(this);
            this.addChildControl(this._icon, this._label);
            if (null != builder._tooltipsSource) {
                this.useTooltipsFrom(builder._tooltipsSource);
            } else {
                this.setTooltips(builder._tooltipsLines, builder._tooltipsObjects);
            }
        }

        @Override
        public void setBounds(Rectangle bounds) {
            super.setBounds(bounds);
            this._icon.setBounds(new Rectangle(0, 0, 16, 16));
            this._label.setBounds(new Rectangle(19, 0, bounds.Width - 19, bounds.Height));
        }
    }
}

