/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.block.multiblock;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.ModBlock;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.multiblock.validation.ValidationError;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class MultiblockPartBlock<Controller extends IMultiblockController<Controller>, PartType extends IMultiblockPartType>
extends ModBlock
implements EntityBlock {
    private final PartType _partType;
    private final IMultiblockVariant _multiblockVariant;

    public MultiblockPartBlock(MultiblockPartProperties<PartType> properties) {
        super(properties);
        this._partType = properties._partType;
        this._multiblockVariant = properties._multiblockVariant;
    }

    public PartType getPartType() {
        return this._partType;
    }

    public Optional<IMultiblockVariant> getMultiblockVariant() {
        return Optional.ofNullable(this._multiblockVariant);
    }

    protected boolean openGui(ServerPlayer player, AbstractModBlockEntity mbe) {
        return mbe.openGui(player);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos position, Player player, InteractionHand hand, BlockHitResult hit) {
        if (CodeHelper.calledByLogicalServer(world)) {
            if (InteractionHand.MAIN_HAND == hand) {
                Optional part = WorldHelper.getMultiblockPartFrom(world, position);
                ItemStack heldItem = player.m_21120_(hand);
                if (heldItem.m_41619_()) {
                    ValidationError error;
                    Optional controller = part.flatMap(IMultiblockPart::getMultiblockController);
                    ValidationError validationError = error = !controller.isPresent() ? ValidationError.VALIDATION_ERROR_NOT_CONNECTED : (ValidationError)controller.filter(IMultiblockValidator::hasLastError).flatMap(IMultiblockValidator::getLastError).orElse(null);
                    if (null != error) {
                        CodeHelper.reportErrorToPlayer(player, error);
                        return InteractionResult.SUCCESS;
                    }
                }
                if (part.filter(p -> p instanceof MenuProvider && p instanceof AbstractModBlockEntity).map(p -> (AbstractModBlockEntity)((Object)p)).filter(mbe -> mbe.canOpenGui(world, position, state)).map(mbe -> this.openGui((ServerPlayer)player, (AbstractModBlockEntity)mbe)).orElse(false).booleanValue()) {
                    return InteractionResult.CONSUME;
                }
            }
        } else {
            return WorldHelper.getMultiblockPartFrom(world, position).filter(p -> p instanceof MenuProvider && p instanceof AbstractModBlockEntity).map(p -> (AbstractModBlockEntity)((Object)p)).filter(mbe -> mbe.canOpenGui(world, position, state)).map(mbe -> InteractionResult.CONSUME).orElse(InteractionResult.PASS);
        }
        return super.m_6227_(state, world, position, player, hand, hit);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos position, BlockState state) {
        return this.getPartType().createTileEntity(state, position);
    }

    public static class MultiblockPartProperties<PartType extends IMultiblockPartType>
    extends ModBlock.ExtendedProperties<MultiblockPartProperties<PartType>> {
        private final PartType _partType;
        private IMultiblockVariant _multiblockVariant;

        public static <PartType extends IMultiblockPartType> MultiblockPartProperties<PartType> create(PartType partType, BlockBehaviour.Properties blockProperties) {
            return new MultiblockPartProperties<PartType>(partType, blockProperties);
        }

        public MultiblockPartProperties<PartType> variant(IMultiblockVariant variant) {
            this._multiblockVariant = variant;
            return this;
        }

        private MultiblockPartProperties(PartType partType, BlockBehaviour.Properties blockProperties) {
            this._partType = partType;
            this._multiblockVariant = null;
            this.setBlockProperties(blockProperties);
        }
    }
}

