/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IDragSource;
import it.zerono.mods.zerocore.lib.client.gui.IDraggable;
import it.zerono.mods.zerocore.lib.client.gui.IWindow;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.control.AbstractControl;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.event.Event;
import it.zerono.mods.zerocore.lib.event.IEvent;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;

public abstract class AbstractDragSource
extends AbstractControl
implements IDragSource {
    public final IEvent<BiConsumer<IControl, IDraggable>> DraggableAdded;
    public final IEvent<BiConsumer<IControl, IDraggable>> DraggableRemoved;
    private IDraggable _draggable = null;
    private Point _paintXY = Point.ZERO;

    protected AbstractDragSource(ModContainerScreen<? extends ModContainer> gui, String name) {
        super(gui, name);
        this.DraggableAdded = new Event<BiConsumer<IControl, IDraggable>>();
        this.DraggableRemoved = new Event<BiConsumer<IControl, IDraggable>>();
        this.updatePaintCoordinates();
    }

    @Override
    public void onWindowClosed() {
        super.onWindowClosed();
        this.DraggableAdded.unsubscribeAll();
        this.DraggableRemoved.unsubscribeAll();
    }

    @Override
    public void onPaintBackground(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        super.onPaintBackground(gfx, partialTicks, mouseX, mouseY);
        this.paintHollowRect(gfx, 0, 0, this.getBounds().Width, this.getBounds().Height, this.getTheme().DARK_OUTLINE_COLOR);
    }

    @Override
    public void onPaint(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        this.getDraggable().ifPresent(draggable -> draggable.onPaint(gfx, this.getPaintX(), this.getPaintY(), this.getGuiZLevel(), this.getMouseOver() ? IDraggable.PaintState.Highlighted : IDraggable.PaintState.Default));
    }

    @Override
    public void onMoved() {
        this.updatePaintCoordinates();
    }

    @Override
    protected StringBuilder toStringBuilder() {
        return super.toStringBuilder().append(" paintAt:").append(this._paintXY);
    }

    @Override
    public Optional<IDraggable> getDraggable() {
        return Optional.ofNullable(this._draggable);
    }

    @Override
    public void setDraggable(@Nullable IDraggable draggable) {
        if (null != draggable) {
            this._draggable = draggable;
            this.DraggableAdded.raise(c -> c.accept(this, draggable));
        } else {
            this.getDraggable().ifPresent(currentDraggable -> {
                this._draggable = null;
                this.DraggableRemoved.raise(c -> c.accept(this, currentDraggable));
            });
        }
        this.updatePaintCoordinates();
    }

    protected boolean startDragging(IWindow wnd) {
        Optional<IDraggable> draggable = this.getDraggable();
        if (draggable.isPresent()) {
            this.setDraggable(null);
            wnd.startDragging(draggable.get(), this);
            return true;
        }
        return false;
    }

    protected int getPaintX() {
        return this._paintXY.X;
    }

    protected int getPaintY() {
        return this._paintXY.Y;
    }

    private void updatePaintCoordinates() {
        CodeHelper.optionalIfPresentOrElse(this.getDraggable(), draggable -> {
            this._paintXY = this.controlToScreen((this.getBounds().Width - draggable.getWidth()) / 2, (this.getBounds().Height - draggable.getHeight()) / 2);
        }, () -> {
            this._paintXY = Point.ZERO;
        });
    }
}

